/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.variable.custom;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.optaplanner.core.api.domain.variable.CustomShadowVariable;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.impl.domain.common.accessor.MemberAccessor;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.domain.policy.DescriptorPolicy;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.domain.variable.custom.CustomShadowVariableDemand;
import org.optaplanner.core.impl.domain.variable.descriptor.ShadowVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.VariableDescriptor;
import org.optaplanner.core.impl.domain.variable.listener.VariableListener;
import org.optaplanner.core.impl.domain.variable.supply.Demand;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;

public class CustomShadowVariableDescriptor
extends ShadowVariableDescriptor {
    protected Class<? extends VariableListener> variableListenerClass;
    protected List<VariableDescriptor> sourceVariableDescriptorList;

    public CustomShadowVariableDescriptor(EntityDescriptor entityDescriptor, MemberAccessor variableMemberAccessor) {
        super(entityDescriptor, variableMemberAccessor);
    }

    @Override
    public void processAnnotations(DescriptorPolicy descriptorPolicy) {
        this.processPropertyAnnotations(descriptorPolicy);
    }

    private void processPropertyAnnotations(DescriptorPolicy descriptorPolicy) {
        CustomShadowVariable shadowVariableAnnotation = this.variableMemberAccessor.getAnnotation(CustomShadowVariable.class);
        this.variableListenerClass = shadowVariableAnnotation.variableListenerClass();
        Object[] sources = shadowVariableAnnotation.sources();
        if (sources.length < 1) {
            throw new IllegalArgumentException("The entityClass (" + this.entityDescriptor.getEntityClass() + ") has a " + CustomShadowVariable.class.getSimpleName() + " annotated property (" + this.variableMemberAccessor.getName() + ") with sources (" + Arrays.toString(sources) + ") which is empty.");
        }
    }

    @Override
    public void linkShadowSources(DescriptorPolicy descriptorPolicy) {
        CustomShadowVariable shadowVariableAnnotation = this.variableMemberAccessor.getAnnotation(CustomShadowVariable.class);
        SolutionDescriptor solutionDescriptor = this.entityDescriptor.getSolutionDescriptor();
        CustomShadowVariable.Source[] sources = shadowVariableAnnotation.sources();
        this.sourceVariableDescriptorList = new ArrayList<VariableDescriptor>(sources.length);
        for (CustomShadowVariable.Source source : sources) {
            EntityDescriptor sourceEntityDescriptor;
            Class<?> sourceEntityClass = source.entityClass();
            if (sourceEntityClass.equals(CustomShadowVariable.Source.NullEntityClass.class)) {
                sourceEntityDescriptor = this.entityDescriptor;
            } else {
                sourceEntityDescriptor = solutionDescriptor.findEntityDescriptor(sourceEntityClass);
                if (sourceEntityDescriptor == null) {
                    throw new IllegalArgumentException("The entityClass (" + this.entityDescriptor.getEntityClass() + ") has a " + CustomShadowVariable.class.getSimpleName() + " annotated property (" + this.variableMemberAccessor.getName() + ") with a sourceEntityClass (" + sourceEntityClass + ") which is not a valid planning entity.");
                }
            }
            String sourceVariableName = source.variableName();
            VariableDescriptor sourceVariableDescriptor = sourceEntityDescriptor.getVariableDescriptor(sourceVariableName);
            if (sourceVariableDescriptor == null) {
                throw new IllegalArgumentException("The entityClass (" + this.entityDescriptor.getEntityClass() + ") has a " + CustomShadowVariable.class.getSimpleName() + " annotated property (" + this.variableMemberAccessor.getName() + ") with sourceVariableName (" + sourceVariableName + ") which is not a valid planning variable on entityClass (" + sourceEntityDescriptor.getEntityClass() + ").\n" + this.entityDescriptor.buildInvalidVariableNameExceptionMessage(sourceVariableName));
            }
            sourceVariableDescriptor.registerShadowVariableDescriptor(this);
            this.sourceVariableDescriptorList.add(sourceVariableDescriptor);
        }
    }

    @Override
    public Demand getProvidedDemand() {
        return new CustomShadowVariableDemand(this);
    }

    @Override
    public VariableListener buildVariableListener(InnerScoreDirector scoreDirector) {
        return ConfigUtils.newInstance(this, "variableListenerClass", this.variableListenerClass);
    }
}

