/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.buildin.hardsoft;

import org.junit.Assert;
import org.junit.Test;
import org.optaplanner.core.api.score.FeasibilityScore;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.AbstractScoreTest;
import org.optaplanner.core.api.score.buildin.hardsoft.HardSoftScore;
import org.optaplanner.core.impl.testdata.util.PlannerTestUtils;

public class HardSoftScoreTest
extends AbstractScoreTest {
    @Test
    public void parseScore() {
        Assert.assertEquals((Object)HardSoftScore.valueOf((int)-147, (int)-258), (Object)HardSoftScore.parseScore((String)"-147hard/-258soft"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void parseScoreIllegalArgument() {
        HardSoftScore.parseScore((String)"-147");
    }

    @Test
    public void feasible() {
        HardSoftScoreTest.assertScoreNotFeasible(new FeasibilityScore[]{HardSoftScore.valueOf((int)-5, (int)-300)});
        HardSoftScoreTest.assertScoreFeasible(new FeasibilityScore[]{HardSoftScore.valueOf((int)0, (int)-300), HardSoftScore.valueOf((int)2, (int)-300)});
    }

    @Test
    public void add() {
        Assert.assertEquals((Object)HardSoftScore.valueOf((int)19, (int)-320), (Object)HardSoftScore.valueOf((int)20, (int)-20).add(HardSoftScore.valueOf((int)-1, (int)-300)));
    }

    @Test
    public void subtract() {
        Assert.assertEquals((Object)HardSoftScore.valueOf((int)21, (int)280), (Object)HardSoftScore.valueOf((int)20, (int)-20).subtract(HardSoftScore.valueOf((int)-1, (int)-300)));
    }

    @Test
    public void multiply() {
        Assert.assertEquals((Object)HardSoftScore.valueOf((int)6, (int)-6), (Object)HardSoftScore.valueOf((int)5, (int)-5).multiply(1.2));
        Assert.assertEquals((Object)HardSoftScore.valueOf((int)1, (int)-2), (Object)HardSoftScore.valueOf((int)1, (int)-1).multiply(1.2));
        Assert.assertEquals((Object)HardSoftScore.valueOf((int)4, (int)-5), (Object)HardSoftScore.valueOf((int)4, (int)-4).multiply(1.2));
    }

    @Test
    public void divide() {
        Assert.assertEquals((Object)HardSoftScore.valueOf((int)5, (int)-5), (Object)HardSoftScore.valueOf((int)25, (int)-25).divide(5.0));
        Assert.assertEquals((Object)HardSoftScore.valueOf((int)4, (int)-5), (Object)HardSoftScore.valueOf((int)21, (int)-21).divide(5.0));
        Assert.assertEquals((Object)HardSoftScore.valueOf((int)4, (int)-5), (Object)HardSoftScore.valueOf((int)24, (int)-24).divide(5.0));
    }

    @Test
    public void power() {
        Assert.assertEquals((Object)HardSoftScore.valueOf((int)16, (int)25), (Object)HardSoftScore.valueOf((int)-4, (int)5).power(2.0));
        Assert.assertEquals((Object)HardSoftScore.valueOf((int)4, (int)5), (Object)HardSoftScore.valueOf((int)16, (int)25).power(0.5));
    }

    @Test
    public void negate() {
        Assert.assertEquals((Object)HardSoftScore.valueOf((int)4, (int)-5), (Object)HardSoftScore.valueOf((int)-4, (int)5).negate());
        Assert.assertEquals((Object)HardSoftScore.valueOf((int)-4, (int)5), (Object)HardSoftScore.valueOf((int)4, (int)-5).negate());
    }

    @Test
    public void equalsAndHashCode() {
        HardSoftScoreTest.assertScoresEqualsAndHashCode(new Score[]{HardSoftScore.valueOf((int)-10, (int)-20), HardSoftScore.valueOf((int)-10, (int)-20)});
    }

    @Test
    public void compareTo() {
        HardSoftScoreTest.assertScoreCompareToOrder(new Score[]{HardSoftScore.valueOf((int)-20, (int)Integer.MIN_VALUE), HardSoftScore.valueOf((int)-20, (int)-20), HardSoftScore.valueOf((int)-1, (int)-300), HardSoftScore.valueOf((int)-1, (int)4000), HardSoftScore.valueOf((int)0, (int)-1), HardSoftScore.valueOf((int)0, (int)0), HardSoftScore.valueOf((int)0, (int)1)});
    }

    @Test
    public void serializeAndDeserialize() {
        HardSoftScore input = HardSoftScore.valueOf((int)-12, (int)3400);
        PlannerTestUtils.serializeAndDeserializeWithAll(input, new PlannerTestUtils.OutputAsserter<HardSoftScore>(){

            @Override
            public void assertOutput(HardSoftScore output) {
                Assert.assertEquals((long)-12L, (long)output.getHardScore());
                Assert.assertEquals((long)3400L, (long)output.getSoftScore());
            }
        });
    }
}

