/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.valuerange.buildin.collection;

import java.util.Arrays;
import java.util.Collections;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.optaplanner.core.impl.domain.valuerange.buildin.collection.ListValueRange;
import org.optaplanner.core.impl.testdata.util.PlannerAssert;

public class ListValueRangeTest {
    @Test
    public void getSize() {
        Assert.assertEquals((long)4L, (long)new ListValueRange(Arrays.asList(0, 2, 5, 10)).getSize());
        Assert.assertEquals((long)5L, (long)new ListValueRange(Arrays.asList(100, 120, 5, 7, 8)).getSize());
        Assert.assertEquals((long)3L, (long)new ListValueRange(Arrays.asList(-15, 25, 0)).getSize());
        Assert.assertEquals((long)3L, (long)new ListValueRange(Arrays.asList("b", "z", "a")).getSize());
        Assert.assertEquals((long)0L, (long)new ListValueRange(Collections.emptyList()).getSize());
    }

    @Test
    public void get() {
        Assert.assertEquals((long)5L, (long)((Integer)new ListValueRange(Arrays.asList(0, 2, 5, 10)).get(2L)).intValue());
        Assert.assertEquals((long)-120L, (long)((Integer)new ListValueRange(Arrays.asList(100, -120)).get(1L)).intValue());
        Assert.assertEquals((Object)"c", (Object)new ListValueRange(Arrays.asList("b", "z", "a", "c", "g", "d")).get(3L));
    }

    @Test
    public void contains() {
        Assert.assertEquals((Object)true, (Object)new ListValueRange(Arrays.asList(0, 2, 5, 10)).contains((Object)5));
        Assert.assertEquals((Object)false, (Object)new ListValueRange(Arrays.asList(0, 2, 5, 10)).contains((Object)4));
        Assert.assertEquals((Object)false, (Object)new ListValueRange(Arrays.asList(0, 2, 5, 10)).contains(null));
        Assert.assertEquals((Object)true, (Object)new ListValueRange(Arrays.asList(100, 120, 5, 7, 8)).contains((Object)7));
        Assert.assertEquals((Object)false, (Object)new ListValueRange(Arrays.asList(100, 120, 5, 7, 8)).contains((Object)9));
        Assert.assertEquals((Object)true, (Object)new ListValueRange(Arrays.asList(-15, 25, 0)).contains((Object)-15));
        Assert.assertEquals((Object)false, (Object)new ListValueRange(Arrays.asList(-15, 25, 0)).contains((Object)-14));
        Assert.assertEquals((Object)true, (Object)new ListValueRange(Arrays.asList("b", "z", "a")).contains((Object)"a"));
        Assert.assertEquals((Object)false, (Object)new ListValueRange(Arrays.asList("b", "z", "a")).contains((Object)"n"));
    }

    @Test
    public void createOriginalIterator() {
        PlannerAssert.assertAllElementsOfIterator(new ListValueRange(Arrays.asList(0, 2, 5, 10)).createOriginalIterator(), 0, 2, 5, 10);
        PlannerAssert.assertAllElementsOfIterator(new ListValueRange(Arrays.asList(100, 120, 5, 7, 8)).createOriginalIterator(), 100, 120, 5, 7, 8);
        PlannerAssert.assertAllElementsOfIterator(new ListValueRange(Arrays.asList(-15, 25, 0)).createOriginalIterator(), -15, 25, 0);
        PlannerAssert.assertAllElementsOfIterator(new ListValueRange(Arrays.asList("b", "z", "a")).createOriginalIterator(), "b", "z", "a");
        PlannerAssert.assertAllElementsOfIterator(new ListValueRange(Collections.emptyList()).createOriginalIterator(), new String[0]);
    }

    @Test
    public void createRandomIterator() {
        Random workingRandom = (Random)Mockito.mock(Random.class);
        Mockito.when((Object)workingRandom.nextInt(Mockito.anyInt())).thenReturn((Object)2, (Object[])new Integer[]{0});
        PlannerAssert.assertElementsOfIterator(new ListValueRange(Arrays.asList(0, 2, 5, 10)).createRandomIterator(workingRandom), 5, 0);
        Mockito.when((Object)workingRandom.nextInt(Mockito.anyInt())).thenReturn((Object)2, (Object[])new Integer[]{0});
        PlannerAssert.assertElementsOfIterator(new ListValueRange(Arrays.asList(100, 120, 5, 7, 8)).createRandomIterator(workingRandom), 5, 100);
        Mockito.when((Object)workingRandom.nextInt(Mockito.anyInt())).thenReturn((Object)2, (Object[])new Integer[]{0});
        PlannerAssert.assertElementsOfIterator(new ListValueRange(Arrays.asList(-15, 25, 0)).createRandomIterator(workingRandom), 0, -15);
        Mockito.when((Object)workingRandom.nextInt(Mockito.anyInt())).thenReturn((Object)2, (Object[])new Integer[]{0});
        PlannerAssert.assertElementsOfIterator(new ListValueRange(Arrays.asList("b", "z", "a")).createRandomIterator(workingRandom), "a", "b");
        PlannerAssert.assertAllElementsOfIterator(new ListValueRange(Collections.emptyList()).createRandomIterator(workingRandom), new String[0]);
    }
}

