/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.valuerange.buildin.primint;

import java.util.Random;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.optaplanner.core.impl.domain.valuerange.buildin.primint.IntValueRange;
import org.optaplanner.core.impl.testdata.util.PlannerAssert;

public class IntValueRangeTest {
    @Test
    public void getSize() {
        Assert.assertEquals((long)10L, (long)new IntValueRange(0, 10).getSize());
        Assert.assertEquals((long)20L, (long)new IntValueRange(100, 120).getSize());
        Assert.assertEquals((long)40L, (long)new IntValueRange(-15, 25).getSize());
        Assert.assertEquals((long)0L, (long)new IntValueRange(7, 7).getSize());
        Assert.assertEquals((long)0x80000383L, (long)new IntValueRange(-1000, 2147483547).getSize());
        Assert.assertEquals((long)5L, (long)new IntValueRange(0, 10, 2).getSize());
        Assert.assertEquals((long)5L, (long)new IntValueRange(-1, 9, 2).getSize());
        Assert.assertEquals((long)4L, (long)new IntValueRange(100, 120, 5).getSize());
    }

    @Test
    public void get() {
        Assert.assertEquals((long)3L, (long)new IntValueRange(0, 10).get(3L).intValue());
        Assert.assertEquals((long)103L, (long)new IntValueRange(100, 120).get(3L).intValue());
        Assert.assertEquals((long)-4L, (long)new IntValueRange(-5, 25).get(1L).intValue());
        Assert.assertEquals((long)1L, (long)new IntValueRange(-5, 25).get(6L).intValue());
        Assert.assertEquals((long)4L, (long)new IntValueRange(-1000, 2147483547).get(1004L).intValue());
        Assert.assertEquals((long)6L, (long)new IntValueRange(0, 10, 2).get(3L).intValue());
        Assert.assertEquals((long)5L, (long)new IntValueRange(-1, 9, 2).get(3L).intValue());
        Assert.assertEquals((long)115L, (long)new IntValueRange(100, 120, 5).get(3L).intValue());
    }

    @Test
    public void contains() {
        Assert.assertEquals((Object)true, (Object)new IntValueRange(0, 10).contains(Integer.valueOf(3)));
        Assert.assertEquals((Object)false, (Object)new IntValueRange(0, 10).contains(Integer.valueOf(10)));
        Assert.assertEquals((Object)false, (Object)new IntValueRange(0, 10).contains(null));
        Assert.assertEquals((Object)true, (Object)new IntValueRange(100, 120).contains(Integer.valueOf(100)));
        Assert.assertEquals((Object)false, (Object)new IntValueRange(100, 120).contains(Integer.valueOf(99)));
        Assert.assertEquals((Object)true, (Object)new IntValueRange(-5, 25).contains(Integer.valueOf(-4)));
        Assert.assertEquals((Object)false, (Object)new IntValueRange(-5, 25).contains(Integer.valueOf(-20)));
        Assert.assertEquals((Object)true, (Object)new IntValueRange(0, 10, 2).contains(Integer.valueOf(2)));
        Assert.assertEquals((Object)false, (Object)new IntValueRange(0, 10, 2).contains(Integer.valueOf(3)));
        Assert.assertEquals((Object)true, (Object)new IntValueRange(-1, 9, 2).contains(Integer.valueOf(1)));
        Assert.assertEquals((Object)false, (Object)new IntValueRange(-1, 9, 2).contains(Integer.valueOf(2)));
        Assert.assertEquals((Object)true, (Object)new IntValueRange(100, 120, 5).contains(Integer.valueOf(115)));
        Assert.assertEquals((Object)false, (Object)new IntValueRange(100, 120, 5).contains(Integer.valueOf(114)));
    }

    @Test
    public void createOriginalIterator() {
        PlannerAssert.assertAllElementsOfIterator(new IntValueRange(0, 7).createOriginalIterator(), 0, 1, 2, 3, 4, 5, 6);
        PlannerAssert.assertAllElementsOfIterator(new IntValueRange(100, 104).createOriginalIterator(), 100, 101, 102, 103);
        PlannerAssert.assertAllElementsOfIterator(new IntValueRange(-4, 3).createOriginalIterator(), -4, -3, -2, -1, 0, 1, 2);
        PlannerAssert.assertAllElementsOfIterator(new IntValueRange(7, 7).createOriginalIterator(), new Integer[0]);
        PlannerAssert.assertAllElementsOfIterator(new IntValueRange(0, 10, 2).createOriginalIterator(), 0, 2, 4, 6, 8);
        PlannerAssert.assertAllElementsOfIterator(new IntValueRange(-1, 9, 2).createOriginalIterator(), -1, 1, 3, 5, 7);
        PlannerAssert.assertAllElementsOfIterator(new IntValueRange(100, 120, 5).createOriginalIterator(), 100, 105, 110, 115);
    }

    @Test
    public void createRandomIterator() {
        Random workingRandom = (Random)Mockito.mock(Random.class);
        Mockito.when((Object)workingRandom.nextInt(Mockito.anyInt())).thenReturn((Object)3, (Object[])new Integer[]{0});
        PlannerAssert.assertElementsOfIterator(new IntValueRange(0, 7).createRandomIterator(workingRandom), 3, 0);
        Mockito.when((Object)workingRandom.nextInt(Mockito.anyInt())).thenReturn((Object)3, (Object[])new Integer[]{0});
        PlannerAssert.assertElementsOfIterator(new IntValueRange(100, 104).createRandomIterator(workingRandom), 103, 100);
        Mockito.when((Object)workingRandom.nextInt(Mockito.anyInt())).thenReturn((Object)3, (Object[])new Integer[]{0});
        PlannerAssert.assertElementsOfIterator(new IntValueRange(-4, 3).createRandomIterator(workingRandom), -1, -4);
        PlannerAssert.assertAllElementsOfIterator(new IntValueRange(7, 7).createRandomIterator(workingRandom), new Integer[0]);
        Mockito.when((Object)workingRandom.nextInt(Mockito.anyInt())).thenReturn((Object)3, (Object[])new Integer[]{0});
        PlannerAssert.assertElementsOfIterator(new IntValueRange(0, 10, 2).createRandomIterator(workingRandom), 6, 0);
        Mockito.when((Object)workingRandom.nextInt(Mockito.anyInt())).thenReturn((Object)3, (Object[])new Integer[]{0});
        PlannerAssert.assertElementsOfIterator(new IntValueRange(-1, 9, 2).createRandomIterator(workingRandom), 5, -1);
        Mockito.when((Object)workingRandom.nextInt(Mockito.anyInt())).thenReturn((Object)3, (Object[])new Integer[]{0});
        PlannerAssert.assertElementsOfIterator(new IntValueRange(100, 120, 5).createRandomIterator(workingRandom), 115, 100);
    }
}

