/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.variable.anchor;

import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.domain.variable.anchor.AnchorShadowVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.anchor.AnchorVariableListener;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.ShadowVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.VariableDescriptor;
import org.optaplanner.core.impl.domain.variable.inverserelation.InverseRelationShadowVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonInverseVariableListener;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonInverseVariableSupply;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.core.impl.testdata.domain.chained.rich.TestdataRichChainedAnchor;
import org.optaplanner.core.impl.testdata.domain.chained.rich.TestdataRichChainedEntity;
import org.optaplanner.core.impl.testdata.domain.chained.rich.TestdataRichChainedSolution;

public class AnchorVariableListenerTest {
    @Test
    public void chained() {
        SolutionDescriptor solutionDescriptor = TestdataRichChainedSolution.buildSolutionDescriptor();
        EntityDescriptor entityDescriptor = solutionDescriptor.findEntityDescriptorOrFail(TestdataRichChainedEntity.class);
        GenuineVariableDescriptor chainedObjectVariableDescriptor = entityDescriptor.getGenuineVariableDescriptor("chainedObject");
        ShadowVariableDescriptor nextEntityVariableDescriptor = entityDescriptor.getShadowVariableDescriptor("nextEntity");
        SingletonInverseVariableListener inverseVariableListener = new SingletonInverseVariableListener((InverseRelationShadowVariableDescriptor)nextEntityVariableDescriptor, (VariableDescriptor)entityDescriptor.getGenuineVariableDescriptor("chainedObject"));
        ShadowVariableDescriptor anchorVariableDescriptor = entityDescriptor.getShadowVariableDescriptor("anchor");
        AnchorVariableListener variableListener = new AnchorVariableListener((AnchorShadowVariableDescriptor)anchorVariableDescriptor, (VariableDescriptor)chainedObjectVariableDescriptor, (SingletonInverseVariableSupply)inverseVariableListener);
        ScoreDirector scoreDirector = (ScoreDirector)Mockito.mock(ScoreDirector.class);
        TestdataRichChainedAnchor a0 = new TestdataRichChainedAnchor("a0");
        TestdataRichChainedEntity a1 = new TestdataRichChainedEntity("a1", a0);
        a1.setAnchor(a0);
        a0.setNextEntity(a1);
        TestdataRichChainedEntity a2 = new TestdataRichChainedEntity("a2", a1);
        a2.setAnchor(a0);
        a1.setNextEntity(a2);
        TestdataRichChainedEntity a3 = new TestdataRichChainedEntity("a3", a2);
        a3.setAnchor(a0);
        a2.setNextEntity(a3);
        TestdataRichChainedAnchor b0 = new TestdataRichChainedAnchor("b0");
        TestdataRichChainedEntity b1 = new TestdataRichChainedEntity("b1", b0);
        b1.setAnchor(b0);
        b0.setNextEntity(b1);
        TestdataRichChainedSolution solution = new TestdataRichChainedSolution("solution");
        solution.setChainedAnchorList(Arrays.asList(a0, b0));
        solution.setChainedEntityList(Arrays.asList(a1, a2, a3, b1));
        Assert.assertSame((Object)a0, (Object)a1.getAnchor());
        Assert.assertSame((Object)a0, (Object)a2.getAnchor());
        Assert.assertSame((Object)a0, (Object)a3.getAnchor());
        Assert.assertSame((Object)b0, (Object)b1.getAnchor());
        inverseVariableListener.beforeVariableChanged(scoreDirector, (Object)a3);
        variableListener.beforeVariableChanged(scoreDirector, (Object)a3);
        a3.setChainedObject(b1);
        inverseVariableListener.afterVariableChanged(scoreDirector, (Object)a3);
        variableListener.afterVariableChanged(scoreDirector, (Object)a3);
        Assert.assertSame((Object)a0, (Object)a1.getAnchor());
        Assert.assertSame((Object)a0, (Object)a2.getAnchor());
        Assert.assertSame((Object)b0, (Object)a3.getAnchor());
        Assert.assertSame((Object)b0, (Object)b1.getAnchor());
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{scoreDirector});
        ((ScoreDirector)inOrder.verify((Object)scoreDirector)).beforeVariableChanged((VariableDescriptor)anchorVariableDescriptor, (Object)a3);
        ((ScoreDirector)inOrder.verify((Object)scoreDirector)).afterVariableChanged((VariableDescriptor)anchorVariableDescriptor, (Object)a3);
        inOrder.verifyNoMoreInteractions();
    }
}

