/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.variable.inverserelation;

import java.util.Arrays;
import org.junit.Test;
import org.mockito.Mockito;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.ShadowVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.VariableDescriptor;
import org.optaplanner.core.impl.domain.variable.inverserelation.CollectionInverseVariableListener;
import org.optaplanner.core.impl.domain.variable.inverserelation.InverseRelationShadowVariableDescriptor;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.core.impl.testdata.domain.shadow.inverserelation.TestdataInverseRelationEntity;
import org.optaplanner.core.impl.testdata.domain.shadow.inverserelation.TestdataInverseRelationSolution;
import org.optaplanner.core.impl.testdata.domain.shadow.inverserelation.TestdataInverseRelationValue;
import org.optaplanner.core.impl.testdata.util.PlannerAssert;

public class CollectionInverseVariableListenerTest {
    @Test
    public void normal() {
        ScoreDirector scoreDirector = (ScoreDirector)Mockito.mock(ScoreDirector.class);
        SolutionDescriptor solutionDescriptor = TestdataInverseRelationSolution.buildSolutionDescriptor();
        EntityDescriptor entityDescriptor = solutionDescriptor.findEntityDescriptorOrFail(TestdataInverseRelationEntity.class);
        EntityDescriptor shadowEntityDescriptor = solutionDescriptor.findEntityDescriptorOrFail(TestdataInverseRelationValue.class);
        ShadowVariableDescriptor entitiesVariableDescriptor = shadowEntityDescriptor.getShadowVariableDescriptor("entities");
        CollectionInverseVariableListener variableListener = new CollectionInverseVariableListener((InverseRelationShadowVariableDescriptor)entitiesVariableDescriptor, (VariableDescriptor)entityDescriptor.getGenuineVariableDescriptor("value"));
        TestdataInverseRelationValue val1 = new TestdataInverseRelationValue("1");
        TestdataInverseRelationValue val2 = new TestdataInverseRelationValue("2");
        TestdataInverseRelationValue val3 = new TestdataInverseRelationValue("3");
        TestdataInverseRelationEntity a = new TestdataInverseRelationEntity("a", val1);
        TestdataInverseRelationEntity b = new TestdataInverseRelationEntity("b", val1);
        TestdataInverseRelationEntity c = new TestdataInverseRelationEntity("c", val3);
        TestdataInverseRelationEntity d = new TestdataInverseRelationEntity("d", val3);
        TestdataInverseRelationSolution solution = new TestdataInverseRelationSolution("solution");
        solution.setEntityList(Arrays.asList(a, b, c, d));
        solution.setValueList(Arrays.asList(val1, val2, val3));
        PlannerAssert.assertCollectionContainsExactly(val1.getEntities(), a, b);
        PlannerAssert.assertCollectionContainsExactly(val2.getEntities(), new TestdataInverseRelationEntity[0]);
        PlannerAssert.assertCollectionContainsExactly(val3.getEntities(), c, d);
        variableListener.beforeVariableChanged(scoreDirector, (Object)c);
        c.setValue(val2);
        variableListener.afterVariableChanged(scoreDirector, (Object)c);
        PlannerAssert.assertCollectionContainsExactly(val1.getEntities(), a, b);
        PlannerAssert.assertCollectionContainsExactly(val2.getEntities(), c);
        PlannerAssert.assertCollectionContainsExactly(val3.getEntities(), d);
    }
}

