/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.variable.inverserelation;

import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.VariableDescriptor;
import org.optaplanner.core.impl.domain.variable.inverserelation.ExternalizedSingletonInverseVariableSupply;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.core.impl.testdata.domain.chained.TestdataChainedAnchor;
import org.optaplanner.core.impl.testdata.domain.chained.TestdataChainedEntity;
import org.optaplanner.core.impl.testdata.domain.chained.TestdataChainedSolution;

public class ExternalizedSingletonInverseVariableSupplyTest {
    @Test
    public void chainedEntity() {
        GenuineVariableDescriptor variableDescriptor = TestdataChainedEntity.buildVariableDescriptorForChainedObject();
        ScoreDirector scoreDirector = (ScoreDirector)Mockito.mock(ScoreDirector.class);
        ExternalizedSingletonInverseVariableSupply supply = new ExternalizedSingletonInverseVariableSupply((VariableDescriptor)variableDescriptor);
        TestdataChainedAnchor a0 = new TestdataChainedAnchor("a0");
        TestdataChainedEntity a1 = new TestdataChainedEntity("a1", a0);
        TestdataChainedEntity a2 = new TestdataChainedEntity("a2", a1);
        TestdataChainedEntity a3 = new TestdataChainedEntity("a3", a2);
        TestdataChainedAnchor b0 = new TestdataChainedAnchor("b0");
        TestdataChainedEntity b1 = new TestdataChainedEntity("b1", b0);
        TestdataChainedSolution solution = new TestdataChainedSolution("solution");
        solution.setChainedAnchorList(Arrays.asList(a0, b0));
        solution.setChainedEntityList(Arrays.asList(a1, a2, a3, b1));
        Mockito.when((Object)scoreDirector.getWorkingSolution()).thenReturn((Object)solution);
        supply.resetWorkingSolution(scoreDirector);
        Assert.assertSame((Object)a1, (Object)supply.getInverseSingleton((Object)a0));
        Assert.assertSame((Object)a2, (Object)supply.getInverseSingleton((Object)a1));
        Assert.assertSame((Object)a3, (Object)supply.getInverseSingleton((Object)a2));
        Assert.assertSame(null, (Object)supply.getInverseSingleton((Object)a3));
        Assert.assertSame((Object)b1, (Object)supply.getInverseSingleton((Object)b0));
        Assert.assertSame(null, (Object)supply.getInverseSingleton((Object)b1));
        supply.beforeVariableChanged(scoreDirector, (Object)a3);
        a3.setChainedObject(b1);
        supply.afterVariableChanged(scoreDirector, (Object)a3);
        Assert.assertSame(null, (Object)supply.getInverseSingleton((Object)a2));
        Assert.assertSame((Object)a3, (Object)supply.getInverseSingleton((Object)b1));
        supply.clearWorkingSolution(scoreDirector);
    }
}

