/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.exhaustivesearch;

import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.optaplanner.core.api.domain.solution.Solution;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.simple.SimpleScore;
import org.optaplanner.core.impl.exhaustivesearch.DefaultExhaustiveSearchPhase;
import org.optaplanner.core.impl.exhaustivesearch.decider.ExhaustiveSearchDecider;
import org.optaplanner.core.impl.exhaustivesearch.node.ExhaustiveSearchLayer;
import org.optaplanner.core.impl.exhaustivesearch.node.ExhaustiveSearchNode;
import org.optaplanner.core.impl.exhaustivesearch.scope.ExhaustiveSearchPhaseScope;
import org.optaplanner.core.impl.exhaustivesearch.scope.ExhaustiveSearchStepScope;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.heuristic.selector.entity.EntitySelector;
import org.optaplanner.core.impl.score.director.ScoreDirector;

public class DefaultExhaustiveSearchPhaseTest {
    @Test
    public void restoreWorkingSolution() {
        ExhaustiveSearchPhaseScope phaseScope = (ExhaustiveSearchPhaseScope)Mockito.mock(ExhaustiveSearchPhaseScope.class);
        ExhaustiveSearchStepScope lastCompletedStepScope = (ExhaustiveSearchStepScope)Mockito.mock(ExhaustiveSearchStepScope.class);
        Mockito.when((Object)phaseScope.getLastCompletedStepScope()).thenReturn((Object)lastCompletedStepScope);
        ExhaustiveSearchStepScope stepScope = (ExhaustiveSearchStepScope)Mockito.mock(ExhaustiveSearchStepScope.class);
        Mockito.when((Object)stepScope.getPhaseScope()).thenReturn((Object)phaseScope);
        Solution workingSolution = (Solution)Mockito.mock(Solution.class);
        Mockito.when((Object)phaseScope.getWorkingSolution()).thenReturn((Object)workingSolution);
        ExhaustiveSearchLayer layer0 = new ExhaustiveSearchLayer(0, Mockito.mock(Object.class), 100);
        ExhaustiveSearchLayer layer1 = new ExhaustiveSearchLayer(1, Mockito.mock(Object.class), 99);
        ExhaustiveSearchLayer layer2 = new ExhaustiveSearchLayer(2, Mockito.mock(Object.class), 98);
        ExhaustiveSearchLayer layer3 = new ExhaustiveSearchLayer(3, Mockito.mock(Object.class), 97);
        ExhaustiveSearchLayer layer4 = new ExhaustiveSearchLayer(4, Mockito.mock(Object.class), 96);
        ExhaustiveSearchNode node0 = new ExhaustiveSearchNode(layer0, null);
        node0.setMove((Move)Mockito.mock(Move.class));
        node0.setUndoMove((Move)Mockito.mock(Move.class));
        ExhaustiveSearchNode node1 = new ExhaustiveSearchNode(layer1, node0);
        node1.setMove((Move)Mockito.mock(Move.class));
        node1.setUndoMove((Move)Mockito.mock(Move.class));
        ExhaustiveSearchNode node2A = new ExhaustiveSearchNode(layer2, node1);
        node2A.setMove((Move)Mockito.mock(Move.class));
        node2A.setUndoMove((Move)Mockito.mock(Move.class));
        ExhaustiveSearchNode node3A = new ExhaustiveSearchNode(layer3, node2A);
        node3A.setMove((Move)Mockito.mock(Move.class));
        node3A.setUndoMove((Move)Mockito.mock(Move.class));
        ExhaustiveSearchNode node2B = new ExhaustiveSearchNode(layer2, node1);
        node2B.setMove((Move)Mockito.mock(Move.class));
        node2B.setUndoMove((Move)Mockito.mock(Move.class));
        ExhaustiveSearchNode node3B = new ExhaustiveSearchNode(layer3, node2B);
        node3B.setMove((Move)Mockito.mock(Move.class));
        node3B.setUndoMove((Move)Mockito.mock(Move.class));
        ExhaustiveSearchNode node4B = new ExhaustiveSearchNode(layer4, node3B);
        node4B.setMove((Move)Mockito.mock(Move.class));
        node4B.setUndoMove((Move)Mockito.mock(Move.class));
        SimpleScore newScore = SimpleScore.valueOf((int)7);
        node4B.setScore((Score)newScore);
        Mockito.when((Object)lastCompletedStepScope.getExpandingNode()).thenReturn((Object)node3A);
        Mockito.when((Object)stepScope.getExpandingNode()).thenReturn((Object)node4B);
        DefaultExhaustiveSearchPhase phase = new DefaultExhaustiveSearchPhase();
        phase.setEntitySelector((EntitySelector)Mockito.mock(EntitySelector.class));
        phase.setDecider((ExhaustiveSearchDecider)Mockito.mock(ExhaustiveSearchDecider.class));
        phase.restoreWorkingSolution(stepScope);
        ((Move)Mockito.verify((Object)node0.getMove(), (VerificationMode)Mockito.times((int)0))).doMove((ScoreDirector)Mockito.any(ScoreDirector.class));
        ((Move)Mockito.verify((Object)node0.getUndoMove(), (VerificationMode)Mockito.times((int)0))).doMove((ScoreDirector)Mockito.any(ScoreDirector.class));
        ((Move)Mockito.verify((Object)node1.getMove(), (VerificationMode)Mockito.times((int)0))).doMove((ScoreDirector)Mockito.any(ScoreDirector.class));
        ((Move)Mockito.verify((Object)node1.getUndoMove(), (VerificationMode)Mockito.times((int)0))).doMove((ScoreDirector)Mockito.any(ScoreDirector.class));
        ((Move)Mockito.verify((Object)node2A.getMove(), (VerificationMode)Mockito.times((int)0))).doMove((ScoreDirector)Mockito.any(ScoreDirector.class));
        ((Move)Mockito.verify((Object)node2A.getUndoMove(), (VerificationMode)Mockito.times((int)1))).doMove((ScoreDirector)Mockito.any(ScoreDirector.class));
        ((Move)Mockito.verify((Object)node3A.getMove(), (VerificationMode)Mockito.times((int)0))).doMove((ScoreDirector)Mockito.any(ScoreDirector.class));
        ((Move)Mockito.verify((Object)node3A.getUndoMove(), (VerificationMode)Mockito.times((int)1))).doMove((ScoreDirector)Mockito.any(ScoreDirector.class));
        ((Move)Mockito.verify((Object)node2B.getMove(), (VerificationMode)Mockito.times((int)1))).doMove((ScoreDirector)Mockito.any(ScoreDirector.class));
        ((Move)Mockito.verify((Object)node2B.getUndoMove(), (VerificationMode)Mockito.times((int)0))).doMove((ScoreDirector)Mockito.any(ScoreDirector.class));
        ((Move)Mockito.verify((Object)node3B.getMove(), (VerificationMode)Mockito.times((int)1))).doMove((ScoreDirector)Mockito.any(ScoreDirector.class));
        ((Move)Mockito.verify((Object)node3B.getUndoMove(), (VerificationMode)Mockito.times((int)0))).doMove((ScoreDirector)Mockito.any(ScoreDirector.class));
        ((Move)Mockito.verify((Object)node4B.getMove(), (VerificationMode)Mockito.times((int)1))).doMove((ScoreDirector)Mockito.any(ScoreDirector.class));
        ((Move)Mockito.verify((Object)node4B.getUndoMove(), (VerificationMode)Mockito.times((int)0))).doMove((ScoreDirector)Mockito.any(ScoreDirector.class));
    }
}

