/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.exhaustivesearch.node.comparator;

import java.util.Comparator;
import org.junit.Assert;
import org.mockito.Mockito;
import org.optaplanner.core.api.score.buildin.simple.SimpleScore;
import org.optaplanner.core.impl.exhaustivesearch.node.ExhaustiveSearchNode;

public abstract class AbstractNodeComparatorTest {
    protected ExhaustiveSearchNode buildNode(int depth, int scoreString, long parentBreadth, long breadth) {
        ExhaustiveSearchNode node = (ExhaustiveSearchNode)Mockito.mock(ExhaustiveSearchNode.class);
        Mockito.when((Object)node.getDepth()).thenReturn((Object)depth);
        Mockito.when((Object)node.getScore()).thenReturn((Object)SimpleScore.valueOf((int)scoreString));
        Mockito.when((Object)node.getOptimisticBound()).thenReturn((Object)SimpleScore.valueOf((int)scoreString));
        Mockito.when((Object)node.getParentBreadth()).thenReturn((Object)parentBreadth);
        Mockito.when((Object)node.getBreadth()).thenReturn((Object)breadth);
        return node;
    }

    protected ExhaustiveSearchNode buildNode(int depth, int scoreString, int optimisticBoundString, long parentBreadth, long breadth) {
        ExhaustiveSearchNode node = (ExhaustiveSearchNode)Mockito.mock(ExhaustiveSearchNode.class);
        Mockito.when((Object)node.getDepth()).thenReturn((Object)depth);
        Mockito.when((Object)node.getScore()).thenReturn((Object)SimpleScore.valueOf((int)scoreString));
        Mockito.when((Object)node.getOptimisticBound()).thenReturn((Object)SimpleScore.valueOf((int)optimisticBoundString));
        Mockito.when((Object)node.getParentBreadth()).thenReturn((Object)parentBreadth);
        Mockito.when((Object)node.getBreadth()).thenReturn((Object)breadth);
        return node;
    }

    protected static void assertLesser(Comparator<ExhaustiveSearchNode> comparator, ExhaustiveSearchNode a, ExhaustiveSearchNode b) {
        Assert.assertTrue((String)("Node (" + a + ") must be lesser than node (" + b + ")."), (comparator.compare(a, b) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)("Node (" + b + ") must be greater than node (" + a + ")."), (comparator.compare(b, a) > 0 ? 1 : 0) != 0);
    }

    protected static void assertScoreCompareToOrder(Comparator<ExhaustiveSearchNode> comparator, ExhaustiveSearchNode ... nodes) {
        for (int i = 0; i < nodes.length; ++i) {
            for (int j = i + 1; j < nodes.length; ++j) {
                AbstractNodeComparatorTest.assertLesser(comparator, nodes[i], nodes[j]);
            }
        }
    }
}

