/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.common.nearby;

import java.util.Random;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.BetaDistributionNearbyRandom;

public class BetaDistributionNearbyRandomTest {
    @Test(expected=IllegalArgumentException.class)
    public void betaDistributionAlphaTooLow() {
        BetaDistributionNearbyRandom nearbyRandom = new BetaDistributionNearbyRandom(-0.2, 0.3);
    }

    @Test(expected=IllegalArgumentException.class)
    public void betaDistributionBetaTooLow() {
        BetaDistributionNearbyRandom nearbyRandom = new BetaDistributionNearbyRandom(0.2, -0.3);
    }

    @Test
    public void nextIntUniform() {
        Random random = (Random)Mockito.mock(Random.class);
        BetaDistributionNearbyRandom nearbyRandom = new BetaDistributionNearbyRandom(1.0, 1.0);
        Mockito.when((Object)random.nextDouble()).thenReturn((Object)0.0);
        Assert.assertEquals((long)0L, (long)nearbyRandom.nextInt(random, 500));
        Mockito.when((Object)random.nextDouble()).thenReturn((Object)0.002);
        Assert.assertEquals((long)1L, (long)nearbyRandom.nextInt(random, 500));
        Mockito.when((Object)random.nextDouble()).thenReturn((Object)0.004);
        Assert.assertEquals((long)2L, (long)nearbyRandom.nextInt(random, 500));
        Mockito.when((Object)random.nextDouble()).thenReturn((Object)0.006);
        Assert.assertEquals((long)3L, (long)nearbyRandom.nextInt(random, 500));
    }
}

