/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.generic;

import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.heuristic.selector.move.generic.PillarChangeMove;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.core.impl.testdata.domain.TestdataEntity;
import org.optaplanner.core.impl.testdata.domain.TestdataValue;
import org.optaplanner.core.impl.testdata.domain.entityproviding.TestdataEntityProvidingEntity;

public class PillarChangeMoveTest {
    @Test
    public void isMoveDoableValueRangeProviderOnEntity() {
        TestdataValue v1 = new TestdataValue("1");
        TestdataValue v2 = new TestdataValue("2");
        TestdataValue v3 = new TestdataValue("3");
        TestdataValue v4 = new TestdataValue("4");
        TestdataValue v5 = new TestdataValue("5");
        TestdataEntityProvidingEntity a = new TestdataEntityProvidingEntity("a", Arrays.asList(v1, v2, v3), null);
        TestdataEntityProvidingEntity b = new TestdataEntityProvidingEntity("b", Arrays.asList(v2, v3, v4, v5), null);
        ScoreDirector scoreDirector = (ScoreDirector)Mockito.mock(ScoreDirector.class);
        GenuineVariableDescriptor variableDescriptor = TestdataEntityProvidingEntity.buildVariableDescriptorForValue();
        a.setValue(v2);
        b.setValue(v2);
        PillarChangeMove abMove = new PillarChangeMove(Arrays.asList(a, b), variableDescriptor, (Object)v1);
        Assert.assertEquals((Object)false, (Object)abMove.isMoveDoable(scoreDirector));
        a.setValue(v2);
        b.setValue(v2);
        abMove = new PillarChangeMove(Arrays.asList(a, b), variableDescriptor, (Object)v2);
        Assert.assertEquals((Object)false, (Object)abMove.isMoveDoable(scoreDirector));
        a.setValue(v2);
        b.setValue(v2);
        abMove = new PillarChangeMove(Arrays.asList(a, b), variableDescriptor, (Object)v3);
        Assert.assertEquals((Object)true, (Object)abMove.isMoveDoable(scoreDirector));
        a.setValue(v2);
        b.setValue(v2);
        abMove = new PillarChangeMove(Arrays.asList(a, b), variableDescriptor, (Object)v4);
        Assert.assertEquals((Object)false, (Object)abMove.isMoveDoable(scoreDirector));
    }

    @Test
    public void doMove() {
        TestdataValue v1 = new TestdataValue("1");
        TestdataValue v2 = new TestdataValue("2");
        TestdataValue v3 = new TestdataValue("3");
        TestdataValue v4 = new TestdataValue("4");
        TestdataValue v5 = new TestdataValue("5");
        TestdataEntityProvidingEntity a = new TestdataEntityProvidingEntity("a", Arrays.asList(v1, v2, v3), null);
        TestdataEntityProvidingEntity b = new TestdataEntityProvidingEntity("b", Arrays.asList(v2, v3, v4, v5), null);
        TestdataEntityProvidingEntity c = new TestdataEntityProvidingEntity("c", Arrays.asList(v3, v4, v5), null);
        ScoreDirector scoreDirector = (ScoreDirector)Mockito.mock(ScoreDirector.class);
        GenuineVariableDescriptor variableDescriptor = TestdataEntityProvidingEntity.buildVariableDescriptorForValue();
        PillarChangeMove abMove = new PillarChangeMove(Arrays.asList(a, b), variableDescriptor, (Object)v2);
        a.setValue(v3);
        b.setValue(v3);
        abMove.doMove(scoreDirector);
        Assert.assertEquals((Object)v2, (Object)a.getValue());
        Assert.assertEquals((Object)v2, (Object)b.getValue());
        a.setValue(v2);
        b.setValue(v2);
        abMove.doMove(scoreDirector);
        Assert.assertEquals((Object)v2, (Object)a.getValue());
        Assert.assertEquals((Object)v2, (Object)b.getValue());
        PillarChangeMove abcMove = new PillarChangeMove(Arrays.asList(a, b, c), variableDescriptor, (Object)v2);
        a.setValue(v2);
        b.setValue(v2);
        c.setValue(v2);
        abcMove.doMove(scoreDirector);
        Assert.assertEquals((Object)v2, (Object)a.getValue());
        Assert.assertEquals((Object)v2, (Object)b.getValue());
        Assert.assertEquals((Object)v2, (Object)c.getValue());
        a.setValue(v3);
        b.setValue(v3);
        c.setValue(v3);
        abcMove.doMove(scoreDirector);
        Assert.assertEquals((Object)v2, (Object)a.getValue());
        Assert.assertEquals((Object)v2, (Object)b.getValue());
        Assert.assertEquals((Object)v2, (Object)c.getValue());
    }

    @Test
    public void toStringTest() {
        TestdataValue v1 = new TestdataValue("v1");
        TestdataValue v2 = new TestdataValue("v2");
        TestdataEntity a = new TestdataEntity("a", null);
        TestdataEntity b = new TestdataEntity("b", null);
        TestdataEntity c = new TestdataEntity("c", v1);
        TestdataEntity d = new TestdataEntity("d", v1);
        TestdataEntity e = new TestdataEntity("e", v1);
        GenuineVariableDescriptor variableDescriptor = TestdataEntity.buildVariableDescriptorForValue();
        Assert.assertEquals((Object)"[a, b] {null -> v1}", (Object)new PillarChangeMove(Arrays.asList(a, b), variableDescriptor, (Object)v1).toString());
        Assert.assertEquals((Object)"[a, b] {null -> v2}", (Object)new PillarChangeMove(Arrays.asList(a, b), variableDescriptor, (Object)v2).toString());
        Assert.assertEquals((Object)"[c, d, e] {v1 -> null}", (Object)new PillarChangeMove(Arrays.asList(c, d, e), variableDescriptor, null).toString());
        Assert.assertEquals((Object)"[c, d, e] {v1 -> v2}", (Object)new PillarChangeMove(Arrays.asList(c, d, e), variableDescriptor, (Object)v2).toString());
        Assert.assertEquals((Object)"[d] {v1 -> v2}", (Object)new PillarChangeMove(Arrays.asList(d), variableDescriptor, (Object)v2).toString());
    }
}

