/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.generic;

import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.optaplanner.core.impl.heuristic.selector.move.generic.PillarSwapMove;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.core.impl.testdata.domain.TestdataEntity;
import org.optaplanner.core.impl.testdata.domain.TestdataValue;
import org.optaplanner.core.impl.testdata.domain.entityproviding.TestdataEntityProvidingEntity;

public class PillarSwapMoveTest {
    @Test
    public void isMoveDoableValueRangeProviderOnEntity() {
        TestdataValue v1 = new TestdataValue("1");
        TestdataValue v2 = new TestdataValue("2");
        TestdataValue v3 = new TestdataValue("3");
        TestdataValue v4 = new TestdataValue("4");
        TestdataValue v5 = new TestdataValue("5");
        TestdataEntityProvidingEntity a = new TestdataEntityProvidingEntity("a", Arrays.asList(v1, v2, v3), null);
        TestdataEntityProvidingEntity b = new TestdataEntityProvidingEntity("b", Arrays.asList(v2, v3, v4, v5), null);
        TestdataEntityProvidingEntity c = new TestdataEntityProvidingEntity("c", Arrays.asList(v4, v5), null);
        TestdataEntityProvidingEntity z = new TestdataEntityProvidingEntity("z", Arrays.asList(v1, v2, v3, v4, v5), null);
        ScoreDirector scoreDirector = (ScoreDirector)Mockito.mock(ScoreDirector.class);
        Collection variableDescriptors = TestdataEntityProvidingEntity.buildEntityDescriptor().getGenuineVariableDescriptors();
        PillarSwapMove abMove = new PillarSwapMove(variableDescriptors, Arrays.asList(a), Arrays.asList(b));
        a.setValue(v1);
        b.setValue(v2);
        Assert.assertEquals((Object)false, (Object)abMove.isMoveDoable(scoreDirector));
        a.setValue(v2);
        b.setValue(v2);
        Assert.assertEquals((Object)false, (Object)abMove.isMoveDoable(scoreDirector));
        a.setValue(v2);
        b.setValue(v3);
        Assert.assertEquals((Object)true, (Object)abMove.isMoveDoable(scoreDirector));
        a.setValue(v3);
        b.setValue(v2);
        Assert.assertEquals((Object)true, (Object)abMove.isMoveDoable(scoreDirector));
        a.setValue(v3);
        b.setValue(v3);
        Assert.assertEquals((Object)false, (Object)abMove.isMoveDoable(scoreDirector));
        a.setValue(v2);
        b.setValue(v4);
        Assert.assertEquals((Object)false, (Object)abMove.isMoveDoable(scoreDirector));
        PillarSwapMove acMove = new PillarSwapMove(variableDescriptors, Arrays.asList(a), Arrays.asList(c));
        a.setValue(v1);
        c.setValue(v4);
        Assert.assertEquals((Object)false, (Object)acMove.isMoveDoable(scoreDirector));
        a.setValue(v2);
        c.setValue(v5);
        Assert.assertEquals((Object)false, (Object)acMove.isMoveDoable(scoreDirector));
        PillarSwapMove bcMove = new PillarSwapMove(variableDescriptors, Arrays.asList(b), Arrays.asList(c));
        b.setValue(v2);
        c.setValue(v4);
        Assert.assertEquals((Object)false, (Object)bcMove.isMoveDoable(scoreDirector));
        b.setValue(v4);
        c.setValue(v5);
        Assert.assertEquals((Object)true, (Object)bcMove.isMoveDoable(scoreDirector));
        b.setValue(v5);
        c.setValue(v4);
        Assert.assertEquals((Object)true, (Object)bcMove.isMoveDoable(scoreDirector));
        b.setValue(v5);
        c.setValue(v5);
        Assert.assertEquals((Object)false, (Object)bcMove.isMoveDoable(scoreDirector));
        PillarSwapMove abzMove = new PillarSwapMove(variableDescriptors, Arrays.asList(a, b), Arrays.asList(z));
        a.setValue(v2);
        b.setValue(v2);
        z.setValue(v4);
        Assert.assertEquals((Object)false, (Object)abzMove.isMoveDoable(scoreDirector));
        a.setValue(v2);
        b.setValue(v2);
        z.setValue(v1);
        Assert.assertEquals((Object)false, (Object)abzMove.isMoveDoable(scoreDirector));
        a.setValue(v2);
        b.setValue(v2);
        z.setValue(v3);
        Assert.assertEquals((Object)true, (Object)abzMove.isMoveDoable(scoreDirector));
        a.setValue(v3);
        b.setValue(v3);
        z.setValue(v2);
        Assert.assertEquals((Object)true, (Object)abzMove.isMoveDoable(scoreDirector));
        a.setValue(v2);
        b.setValue(v2);
        z.setValue(v2);
        Assert.assertEquals((Object)false, (Object)abzMove.isMoveDoable(scoreDirector));
    }

    @Test
    public void doMove() {
        TestdataValue v1 = new TestdataValue("1");
        TestdataValue v2 = new TestdataValue("2");
        TestdataValue v3 = new TestdataValue("3");
        TestdataValue v4 = new TestdataValue("4");
        TestdataValue v5 = new TestdataValue("5");
        TestdataEntityProvidingEntity a = new TestdataEntityProvidingEntity("a", Arrays.asList(v1, v2, v3, v4), null);
        TestdataEntityProvidingEntity b = new TestdataEntityProvidingEntity("b", Arrays.asList(v2, v3, v4, v5), null);
        TestdataEntityProvidingEntity c = new TestdataEntityProvidingEntity("c", Arrays.asList(v4, v5), null);
        TestdataEntityProvidingEntity z = new TestdataEntityProvidingEntity("z", Arrays.asList(v1, v2, v3, v4, v5), null);
        ScoreDirector scoreDirector = (ScoreDirector)Mockito.mock(ScoreDirector.class);
        Collection variableDescriptors = TestdataEntityProvidingEntity.buildEntityDescriptor().getGenuineVariableDescriptors();
        PillarSwapMove abMove = new PillarSwapMove(variableDescriptors, Arrays.asList(a), Arrays.asList(b));
        a.setValue(v1);
        b.setValue(v1);
        abMove.doMove(scoreDirector);
        Assert.assertEquals((Object)v1, (Object)a.getValue());
        Assert.assertEquals((Object)v1, (Object)b.getValue());
        a.setValue(v2);
        b.setValue(v1);
        abMove.doMove(scoreDirector);
        Assert.assertEquals((Object)v1, (Object)a.getValue());
        Assert.assertEquals((Object)v2, (Object)b.getValue());
        a.setValue(v3);
        b.setValue(v2);
        abMove.doMove(scoreDirector);
        Assert.assertEquals((Object)v2, (Object)a.getValue());
        Assert.assertEquals((Object)v3, (Object)b.getValue());
        abMove.doMove(scoreDirector);
        Assert.assertEquals((Object)v3, (Object)a.getValue());
        Assert.assertEquals((Object)v2, (Object)b.getValue());
        PillarSwapMove abzMove = new PillarSwapMove(variableDescriptors, Arrays.asList(a, b), Arrays.asList(z));
        a.setValue(v3);
        b.setValue(v3);
        z.setValue(v2);
        abzMove.doMove(scoreDirector);
        Assert.assertEquals((Object)v2, (Object)a.getValue());
        Assert.assertEquals((Object)v2, (Object)b.getValue());
        Assert.assertEquals((Object)v3, (Object)z.getValue());
        abzMove.doMove(scoreDirector);
        Assert.assertEquals((Object)v3, (Object)a.getValue());
        Assert.assertEquals((Object)v3, (Object)b.getValue());
        Assert.assertEquals((Object)v2, (Object)z.getValue());
        a.setValue(v3);
        b.setValue(v3);
        z.setValue(v4);
        abzMove.doMove(scoreDirector);
        Assert.assertEquals((Object)v4, (Object)a.getValue());
        Assert.assertEquals((Object)v4, (Object)b.getValue());
        Assert.assertEquals((Object)v3, (Object)z.getValue());
        abzMove.doMove(scoreDirector);
        Assert.assertEquals((Object)v3, (Object)a.getValue());
        Assert.assertEquals((Object)v3, (Object)b.getValue());
        Assert.assertEquals((Object)v4, (Object)z.getValue());
        PillarSwapMove abczMove = new PillarSwapMove(variableDescriptors, Arrays.asList(a), Arrays.asList(b, c, z));
        a.setValue(v2);
        b.setValue(v3);
        c.setValue(v3);
        z.setValue(v3);
        abczMove.doMove(scoreDirector);
        Assert.assertEquals((Object)v3, (Object)a.getValue());
        Assert.assertEquals((Object)v2, (Object)b.getValue());
        Assert.assertEquals((Object)v2, (Object)c.getValue());
        Assert.assertEquals((Object)v2, (Object)z.getValue());
        abczMove.doMove(scoreDirector);
        Assert.assertEquals((Object)v2, (Object)a.getValue());
        Assert.assertEquals((Object)v3, (Object)b.getValue());
        Assert.assertEquals((Object)v3, (Object)c.getValue());
        Assert.assertEquals((Object)v3, (Object)z.getValue());
        PillarSwapMove abczMove2 = new PillarSwapMove(variableDescriptors, Arrays.asList(a, b), Arrays.asList(c, z));
        a.setValue(v4);
        b.setValue(v4);
        c.setValue(v3);
        z.setValue(v3);
        abczMove2.doMove(scoreDirector);
        Assert.assertEquals((Object)v3, (Object)a.getValue());
        Assert.assertEquals((Object)v3, (Object)b.getValue());
        Assert.assertEquals((Object)v4, (Object)c.getValue());
        Assert.assertEquals((Object)v4, (Object)z.getValue());
        abczMove2.doMove(scoreDirector);
        Assert.assertEquals((Object)v4, (Object)a.getValue());
        Assert.assertEquals((Object)v4, (Object)b.getValue());
        Assert.assertEquals((Object)v3, (Object)c.getValue());
        Assert.assertEquals((Object)v3, (Object)z.getValue());
    }

    @Test
    public void toStringTest() {
        TestdataValue v1 = new TestdataValue("v1");
        TestdataValue v2 = new TestdataValue("v2");
        TestdataEntity a = new TestdataEntity("a", null);
        TestdataEntity b = new TestdataEntity("b", null);
        TestdataEntity c = new TestdataEntity("c", v1);
        TestdataEntity d = new TestdataEntity("d", v1);
        TestdataEntity e = new TestdataEntity("e", v1);
        TestdataEntity f = new TestdataEntity("f", v2);
        TestdataEntity g = new TestdataEntity("g", v2);
        Collection variableDescriptors = TestdataEntity.buildEntityDescriptor().getGenuineVariableDescriptors();
        Assert.assertEquals((Object)"[a, b] {null} <-> [c, d, e] {v1}", (Object)new PillarSwapMove(variableDescriptors, Arrays.asList(a, b), Arrays.asList(c, d, e)).toString());
        Assert.assertEquals((Object)"[b] {null} <-> [c] {v1}", (Object)new PillarSwapMove(variableDescriptors, Arrays.asList(b), Arrays.asList(c)).toString());
        Assert.assertEquals((Object)"[f, g] {v2} <-> [c, d, e] {v1}", (Object)new PillarSwapMove(variableDescriptors, Arrays.asList(f, g), Arrays.asList(c, d, e)).toString());
    }
}

