/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.generic.chained;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.heuristic.selector.move.generic.chained.SubChainChangeMoveSelector;
import org.optaplanner.core.impl.heuristic.selector.value.EntityIndependentValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.chained.DefaultSubChainSelector;
import org.optaplanner.core.impl.heuristic.selector.value.chained.SubChainSelector;
import org.optaplanner.core.impl.testdata.domain.TestdataEntity;

public class SubChainChangeMoveSelectorTest {
    @Test(expected=IllegalStateException.class)
    public void differentValueDescriptorException() {
        SubChainSelector subChainSelector = (SubChainSelector)Mockito.mock(DefaultSubChainSelector.class);
        GenuineVariableDescriptor descriptor = TestdataEntity.buildVariableDescriptorForValue();
        Mockito.when((Object)subChainSelector.getVariableDescriptor()).thenReturn((Object)descriptor);
        EntityIndependentValueSelector valueSelector = (EntityIndependentValueSelector)Mockito.mock(EntityIndependentValueSelector.class);
        GenuineVariableDescriptor otherDescriptor = TestdataEntity.buildVariableDescriptorForValue();
        Mockito.when((Object)valueSelector.getVariableDescriptor()).thenReturn((Object)otherDescriptor);
        SubChainChangeMoveSelector testedSelector = new SubChainChangeMoveSelector(subChainSelector, valueSelector, true, true);
    }

    @Test(expected=IllegalStateException.class)
    public void determinedSelectionWithNeverEndingChainSelector() {
        SubChainSelector subChainSelector = (SubChainSelector)Mockito.mock(DefaultSubChainSelector.class);
        Mockito.when((Object)subChainSelector.isNeverEnding()).thenReturn((Object)true);
        GenuineVariableDescriptor descriptor = TestdataEntity.buildVariableDescriptorForValue();
        Mockito.when((Object)subChainSelector.getVariableDescriptor()).thenReturn((Object)descriptor);
        EntityIndependentValueSelector valueSelector = (EntityIndependentValueSelector)Mockito.mock(EntityIndependentValueSelector.class);
        Mockito.when((Object)valueSelector.getVariableDescriptor()).thenReturn((Object)descriptor);
        SubChainChangeMoveSelector testedSelector = new SubChainChangeMoveSelector(subChainSelector, valueSelector, false, true);
    }

    @Test(expected=IllegalStateException.class)
    public void determinedSelectionWithNeverEndingValueSelector() {
        SubChainSelector subChainSelector = (SubChainSelector)Mockito.mock(DefaultSubChainSelector.class);
        GenuineVariableDescriptor descriptor = TestdataEntity.buildVariableDescriptorForValue();
        Mockito.when((Object)subChainSelector.getVariableDescriptor()).thenReturn((Object)descriptor);
        EntityIndependentValueSelector valueSelector = (EntityIndependentValueSelector)Mockito.mock(EntityIndependentValueSelector.class);
        Mockito.when((Object)valueSelector.isNeverEnding()).thenReturn((Object)true);
        Mockito.when((Object)valueSelector.getVariableDescriptor()).thenReturn((Object)descriptor);
        SubChainChangeMoveSelector testedSelector = new SubChainChangeMoveSelector(subChainSelector, valueSelector, false, true);
    }

    @Test
    public void isCountable() {
        SubChainSelector subChainSelector = (SubChainSelector)Mockito.mock(DefaultSubChainSelector.class);
        GenuineVariableDescriptor descriptor = TestdataEntity.buildVariableDescriptorForValue();
        Mockito.when((Object)subChainSelector.getVariableDescriptor()).thenReturn((Object)descriptor);
        EntityIndependentValueSelector valueSelector = (EntityIndependentValueSelector)Mockito.mock(EntityIndependentValueSelector.class);
        Mockito.when((Object)valueSelector.getVariableDescriptor()).thenReturn((Object)descriptor);
        SubChainChangeMoveSelector testedSelector = new SubChainChangeMoveSelector(subChainSelector, valueSelector, true, true);
        Mockito.when((Object)subChainSelector.isCountable()).thenReturn((Object)false);
        Mockito.when((Object)valueSelector.isCountable()).thenReturn((Object)true);
        Assert.assertEquals((Object)false, (Object)testedSelector.isCountable());
        Mockito.when((Object)subChainSelector.isCountable()).thenReturn((Object)true);
        Mockito.when((Object)valueSelector.isCountable()).thenReturn((Object)false);
        Assert.assertEquals((Object)false, (Object)testedSelector.isCountable());
        Mockito.when((Object)subChainSelector.isCountable()).thenReturn((Object)true);
        Mockito.when((Object)valueSelector.isCountable()).thenReturn((Object)true);
        Assert.assertEquals((Object)true, (Object)testedSelector.isCountable());
        Mockito.when((Object)subChainSelector.isCountable()).thenReturn((Object)false);
        Mockito.when((Object)valueSelector.isCountable()).thenReturn((Object)false);
        Assert.assertEquals((Object)false, (Object)testedSelector.isCountable());
    }

    @Test
    public void getSize() {
        SubChainSelector subChainSelector = (SubChainSelector)Mockito.mock(DefaultSubChainSelector.class);
        GenuineVariableDescriptor descriptor = TestdataEntity.buildVariableDescriptorForValue();
        Mockito.when((Object)subChainSelector.getVariableDescriptor()).thenReturn((Object)descriptor);
        EntityIndependentValueSelector valueSelector = (EntityIndependentValueSelector)Mockito.mock(EntityIndependentValueSelector.class);
        Mockito.when((Object)valueSelector.getVariableDescriptor()).thenReturn((Object)descriptor);
        SubChainChangeMoveSelector testedSelector = new SubChainChangeMoveSelector(subChainSelector, valueSelector, true, true);
        Mockito.when((Object)subChainSelector.getSize()).thenReturn((Object)1L);
        Mockito.when((Object)valueSelector.getSize()).thenReturn((Object)2L);
        Assert.assertEquals((long)2L, (long)testedSelector.getSize());
        Mockito.when((Object)subChainSelector.getSize()).thenReturn((Object)100L);
        Mockito.when((Object)valueSelector.getSize()).thenReturn((Object)200L);
        Assert.assertEquals((long)20000L, (long)testedSelector.getSize());
    }
}

