/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.value.nearby;

import org.junit.Ignore;
import org.junit.Test;
import org.mockito.Mockito;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.heuristic.selector.SelectorTestUtils;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.NearbyDistanceMeter;
import org.optaplanner.core.impl.heuristic.selector.entity.EntitySelector;
import org.optaplanner.core.impl.heuristic.selector.entity.mimic.EntityMimicRecorder;
import org.optaplanner.core.impl.heuristic.selector.entity.mimic.ManualEntityMimicRecorder;
import org.optaplanner.core.impl.heuristic.selector.entity.mimic.MimicReplayingEntitySelector;
import org.optaplanner.core.impl.heuristic.selector.value.EntityIndependentValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.ValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.nearby.NearEntityNearbyValueSelector;
import org.optaplanner.core.impl.phase.event.PhaseLifecycleListener;
import org.optaplanner.core.impl.phase.scope.AbstractPhaseScope;
import org.optaplanner.core.impl.phase.scope.AbstractStepScope;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;
import org.optaplanner.core.impl.testdata.domain.TestdataEntity;
import org.optaplanner.core.impl.testdata.domain.TestdataValue;
import org.optaplanner.core.impl.testdata.domain.chained.TestdataChainedAnchor;
import org.optaplanner.core.impl.testdata.domain.chained.TestdataChainedEntity;
import org.optaplanner.core.impl.testdata.domain.chained.TestdataChainedObject;
import org.optaplanner.core.impl.testdata.util.PlannerAssert;

public class NearEntityNearbyValueSelectorTest {
    @Test
    @Ignore(value="Limitation in NearEntityNearbyValueSelector")
    public void originalSelection() {
        final TestdataEntity africa = new TestdataEntity("Africa");
        final TestdataEntity europe = new TestdataEntity("Europe");
        final TestdataEntity oceania = new TestdataEntity("Oceania");
        final TestdataValue morocco = new TestdataValue("Morocco");
        final TestdataValue spain = new TestdataValue("Spain");
        final TestdataValue australia = new TestdataValue("Australia");
        final TestdataValue brazil = new TestdataValue("Brazil");
        GenuineVariableDescriptor variableDescriptor = TestdataEntity.buildVariableDescriptorForValue();
        EntityIndependentValueSelector childValueSelector = SelectorTestUtils.mockEntityIndependentValueSelector(variableDescriptor, morocco, spain, australia, brazil);
        NearbyDistanceMeter<TestdataEntity, TestdataValue> meter = new NearbyDistanceMeter<TestdataEntity, TestdataValue>(){

            public double getNearbyDistance(TestdataEntity origin, TestdataValue destination) {
                if (origin == africa) {
                    if (destination == morocco) {
                        return 0.0;
                    }
                    if (destination == spain) {
                        return 1.0;
                    }
                    if (destination == australia) {
                        return 100.0;
                    }
                    if (destination == brazil) {
                        return 50.0;
                    }
                    throw new IllegalStateException("The destination (" + destination + ") is not implemented.");
                }
                if (origin == europe) {
                    if (destination == morocco) {
                        return 1.0;
                    }
                    if (destination == spain) {
                        return 0.0;
                    }
                    if (destination == australia) {
                        return 101.0;
                    }
                    if (destination == brazil) {
                        return 51.0;
                    }
                    throw new IllegalStateException("The destination (" + destination + ") is not implemented.");
                }
                if (origin == oceania) {
                    if (destination == morocco) {
                        return 100.0;
                    }
                    if (destination == spain) {
                        return 101.0;
                    }
                    if (destination == australia) {
                        return 0.0;
                    }
                    if (destination == brazil) {
                        return 60.0;
                    }
                    throw new IllegalStateException("The destination (" + destination + ") is not implemented.");
                }
                throw new IllegalStateException("The origin (" + origin + ") is not implemented.");
            }
        };
        EntitySelector entitySelector = SelectorTestUtils.mockEntitySelector(variableDescriptor.getEntityDescriptor(), africa, europe, oceania);
        ManualEntityMimicRecorder entityMimicRecorder = new ManualEntityMimicRecorder(entitySelector);
        NearEntityNearbyValueSelector valueSelector = new NearEntityNearbyValueSelector((ValueSelector)childValueSelector, (EntitySelector)new MimicReplayingEntitySelector((EntityMimicRecorder)entityMimicRecorder), (NearbyDistanceMeter)meter, null, false);
        DefaultSolverScope solverScope = (DefaultSolverScope)Mockito.mock(DefaultSolverScope.class);
        valueSelector.solvingStarted(solverScope);
        TestdataEntity movingEntity = europe;
        AbstractPhaseScope phaseScopeA = (AbstractPhaseScope)Mockito.mock(AbstractPhaseScope.class);
        Mockito.when((Object)phaseScopeA.getSolverScope()).thenReturn((Object)solverScope);
        valueSelector.phaseStarted(phaseScopeA);
        AbstractStepScope stepScopeA1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA1.getPhaseScope()).thenReturn((Object)phaseScopeA);
        valueSelector.stepStarted(stepScopeA1);
        entityMimicRecorder.setRecordedEntity((Object)europe);
        PlannerAssert.assertAllCodesOfValueSelectorForEntity((ValueSelector)valueSelector, (Object)movingEntity, "Spain", "Morocco", "Brazil", "Australia");
        valueSelector.stepEnded(stepScopeA1);
        AbstractStepScope stepScopeA2 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA2.getPhaseScope()).thenReturn((Object)phaseScopeA);
        valueSelector.stepStarted(stepScopeA2);
        entityMimicRecorder.setRecordedEntity((Object)africa);
        PlannerAssert.assertAllCodesOfValueSelectorForEntity((ValueSelector)valueSelector, (Object)movingEntity, "Morocco", "Spain", "Brazil", "Australia");
        valueSelector.stepEnded(stepScopeA2);
        valueSelector.phaseEnded(phaseScopeA);
        AbstractPhaseScope phaseScopeB = (AbstractPhaseScope)Mockito.mock(AbstractPhaseScope.class);
        Mockito.when((Object)phaseScopeB.getSolverScope()).thenReturn((Object)solverScope);
        valueSelector.phaseStarted(phaseScopeB);
        AbstractStepScope stepScopeB1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB1.getPhaseScope()).thenReturn((Object)phaseScopeB);
        valueSelector.stepStarted(stepScopeB1);
        entityMimicRecorder.setRecordedEntity((Object)africa);
        PlannerAssert.assertAllCodesOfValueSelectorForEntity((ValueSelector)valueSelector, (Object)movingEntity, "Morocco", "Spain", "Brazil", "Australia");
        valueSelector.stepEnded(stepScopeB1);
        AbstractStepScope stepScopeB2 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB2.getPhaseScope()).thenReturn((Object)phaseScopeB);
        valueSelector.stepStarted(stepScopeB2);
        entityMimicRecorder.setRecordedEntity((Object)oceania);
        PlannerAssert.assertAllCodesOfValueSelectorForEntity((ValueSelector)valueSelector, (Object)movingEntity, "Australia", "Brazil", "Morocco", "Spain");
        valueSelector.stepEnded(stepScopeB2);
        AbstractStepScope stepScopeB3 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB3.getPhaseScope()).thenReturn((Object)phaseScopeB);
        valueSelector.stepStarted(stepScopeB3);
        entityMimicRecorder.setRecordedEntity((Object)europe);
        PlannerAssert.assertAllCodesOfValueSelectorForEntity((ValueSelector)valueSelector, (Object)movingEntity, "Spain", "Morocco", "Brazil", "Australia");
        valueSelector.stepEnded(stepScopeB3);
        valueSelector.phaseEnded(phaseScopeB);
        valueSelector.solvingEnded(solverScope);
        PlannerAssert.verifyPhaseLifecycle((PhaseLifecycleListener)childValueSelector, 1, 2, 5);
    }

    @Test
    public void originalSelectionChained() {
        final TestdataChainedEntity morocco = new TestdataChainedEntity("Morocco");
        final TestdataChainedEntity spain = new TestdataChainedEntity("Spain");
        final TestdataChainedEntity australia = new TestdataChainedEntity("Australia");
        final TestdataChainedAnchor brazil = new TestdataChainedAnchor("Brazil");
        GenuineVariableDescriptor variableDescriptor = TestdataChainedEntity.buildVariableDescriptorForChainedObject();
        EntityIndependentValueSelector childValueSelector = SelectorTestUtils.mockEntityIndependentValueSelector(variableDescriptor, morocco, spain, australia, brazil);
        NearbyDistanceMeter<TestdataChainedEntity, TestdataChainedObject> meter = new NearbyDistanceMeter<TestdataChainedEntity, TestdataChainedObject>(){

            public double getNearbyDistance(TestdataChainedEntity origin, TestdataChainedObject destination) {
                if (origin == morocco) {
                    if (destination == morocco) {
                        return 0.0;
                    }
                    if (destination == spain) {
                        return 1.0;
                    }
                    if (destination == australia) {
                        return 100.0;
                    }
                    if (destination == brazil) {
                        return 50.0;
                    }
                    throw new IllegalStateException("The destination (" + destination + ") is not implemented.");
                }
                if (origin == spain) {
                    if (destination == morocco) {
                        return 1.0;
                    }
                    if (destination == spain) {
                        return 0.0;
                    }
                    if (destination == australia) {
                        return 101.0;
                    }
                    if (destination == brazil) {
                        return 51.0;
                    }
                    throw new IllegalStateException("The destination (" + destination + ") is not implemented.");
                }
                if (origin == australia) {
                    if (destination == morocco) {
                        return 100.0;
                    }
                    if (destination == spain) {
                        return 101.0;
                    }
                    if (destination == australia) {
                        return 0.0;
                    }
                    if (destination == brazil) {
                        return 60.0;
                    }
                    throw new IllegalStateException("The destination (" + destination + ") is not implemented.");
                }
                throw new IllegalStateException("The origin (" + origin + ") is not implemented.");
            }
        };
        EntitySelector entitySelector = SelectorTestUtils.mockEntitySelector(variableDescriptor.getEntityDescriptor(), morocco, spain, australia);
        ManualEntityMimicRecorder entityMimicRecorder = new ManualEntityMimicRecorder(entitySelector);
        NearEntityNearbyValueSelector valueSelector = new NearEntityNearbyValueSelector((ValueSelector)childValueSelector, (EntitySelector)new MimicReplayingEntitySelector((EntityMimicRecorder)entityMimicRecorder), (NearbyDistanceMeter)meter, null, false);
        DefaultSolverScope solverScope = (DefaultSolverScope)Mockito.mock(DefaultSolverScope.class);
        valueSelector.solvingStarted(solverScope);
        TestdataChainedEntity movingEntity = spain;
        AbstractPhaseScope phaseScopeA = (AbstractPhaseScope)Mockito.mock(AbstractPhaseScope.class);
        Mockito.when((Object)phaseScopeA.getSolverScope()).thenReturn((Object)solverScope);
        valueSelector.phaseStarted(phaseScopeA);
        AbstractStepScope stepScopeA1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA1.getPhaseScope()).thenReturn((Object)phaseScopeA);
        valueSelector.stepStarted(stepScopeA1);
        entityMimicRecorder.setRecordedEntity((Object)spain);
        PlannerAssert.assertAllCodesOfValueSelectorForEntity((ValueSelector)valueSelector, (Object)movingEntity, "Morocco", "Brazil", "Australia");
        valueSelector.stepEnded(stepScopeA1);
        AbstractStepScope stepScopeA2 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA2.getPhaseScope()).thenReturn((Object)phaseScopeA);
        valueSelector.stepStarted(stepScopeA2);
        entityMimicRecorder.setRecordedEntity((Object)morocco);
        PlannerAssert.assertAllCodesOfValueSelectorForEntity((ValueSelector)valueSelector, (Object)movingEntity, "Spain", "Brazil", "Australia");
        valueSelector.stepEnded(stepScopeA2);
        valueSelector.phaseEnded(phaseScopeA);
        AbstractPhaseScope phaseScopeB = (AbstractPhaseScope)Mockito.mock(AbstractPhaseScope.class);
        Mockito.when((Object)phaseScopeB.getSolverScope()).thenReturn((Object)solverScope);
        valueSelector.phaseStarted(phaseScopeB);
        AbstractStepScope stepScopeB1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB1.getPhaseScope()).thenReturn((Object)phaseScopeB);
        valueSelector.stepStarted(stepScopeB1);
        entityMimicRecorder.setRecordedEntity((Object)morocco);
        PlannerAssert.assertAllCodesOfValueSelectorForEntity((ValueSelector)valueSelector, (Object)movingEntity, "Spain", "Brazil", "Australia");
        valueSelector.stepEnded(stepScopeB1);
        AbstractStepScope stepScopeB2 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB2.getPhaseScope()).thenReturn((Object)phaseScopeB);
        valueSelector.stepStarted(stepScopeB2);
        entityMimicRecorder.setRecordedEntity((Object)australia);
        PlannerAssert.assertAllCodesOfValueSelectorForEntity((ValueSelector)valueSelector, (Object)movingEntity, "Brazil", "Morocco", "Spain");
        valueSelector.stepEnded(stepScopeB2);
        AbstractStepScope stepScopeB3 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB3.getPhaseScope()).thenReturn((Object)phaseScopeB);
        valueSelector.stepStarted(stepScopeB3);
        entityMimicRecorder.setRecordedEntity((Object)spain);
        PlannerAssert.assertAllCodesOfValueSelectorForEntity((ValueSelector)valueSelector, (Object)movingEntity, "Morocco", "Brazil", "Australia");
        valueSelector.stepEnded(stepScopeB3);
        valueSelector.phaseEnded(phaseScopeB);
        valueSelector.solvingEnded(solverScope);
        PlannerAssert.verifyPhaseLifecycle((PhaseLifecycleListener)childValueSelector, 1, 2, 5);
    }
}

