/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.localsearch.decider.acceptor.composite;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.optaplanner.core.impl.localsearch.decider.acceptor.Acceptor;
import org.optaplanner.core.impl.localsearch.decider.acceptor.CompositeAcceptor;
import org.optaplanner.core.impl.localsearch.event.LocalSearchPhaseLifecycleListener;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchMoveScope;
import org.optaplanner.core.impl.testdata.util.PlannerAssert;

public class CompositeAcceptorTest {
    @Test
    public void phaseLifecycle() {
        Acceptor acceptor1 = (Acceptor)Mockito.mock(Acceptor.class);
        Acceptor acceptor2 = (Acceptor)Mockito.mock(Acceptor.class);
        Acceptor acceptor3 = (Acceptor)Mockito.mock(Acceptor.class);
        CompositeAcceptor compositeAcceptor = new CompositeAcceptor(new Acceptor[]{acceptor1, acceptor2, acceptor3});
        compositeAcceptor.solvingStarted(null);
        compositeAcceptor.phaseStarted(null);
        compositeAcceptor.stepStarted(null);
        compositeAcceptor.stepEnded(null);
        compositeAcceptor.stepStarted(null);
        compositeAcceptor.stepEnded(null);
        compositeAcceptor.phaseEnded(null);
        compositeAcceptor.phaseStarted(null);
        compositeAcceptor.stepStarted(null);
        compositeAcceptor.stepEnded(null);
        compositeAcceptor.phaseEnded(null);
        compositeAcceptor.solvingEnded(null);
        PlannerAssert.verifyPhaseLifecycle((LocalSearchPhaseLifecycleListener)acceptor1, 1, 2, 3);
        PlannerAssert.verifyPhaseLifecycle((LocalSearchPhaseLifecycleListener)acceptor2, 1, 2, 3);
        PlannerAssert.verifyPhaseLifecycle((LocalSearchPhaseLifecycleListener)acceptor3, 1, 2, 3);
    }

    @Test
    public void isAccepted() {
        Assert.assertEquals((Object)true, (Object)this.isCompositeAccepted(true, true, true));
        Assert.assertEquals((Object)false, (Object)this.isCompositeAccepted(false, true, true));
        Assert.assertEquals((Object)false, (Object)this.isCompositeAccepted(true, false, true));
        Assert.assertEquals((Object)false, (Object)this.isCompositeAccepted(true, true, false));
        Assert.assertEquals((Object)false, (Object)this.isCompositeAccepted(false, false, false));
    }

    private boolean isCompositeAccepted(boolean ... childAccepts) {
        ArrayList<Acceptor> acceptorList = new ArrayList<Acceptor>(childAccepts.length);
        for (boolean childAccept : childAccepts) {
            Acceptor acceptor = (Acceptor)Mockito.mock(Acceptor.class);
            Mockito.when((Object)acceptor.isAccepted((LocalSearchMoveScope)Matchers.any(LocalSearchMoveScope.class))).thenReturn((Object)childAccept);
            acceptorList.add(acceptor);
        }
        CompositeAcceptor acceptor = new CompositeAcceptor(acceptorList);
        return acceptor.isAccepted((LocalSearchMoveScope)Mockito.mock(LocalSearchMoveScope.class));
    }
}

