/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.buildin.bendable;

import org.junit.Assert;
import org.junit.Test;
import org.optaplanner.core.api.score.buildin.bendable.BendableScore;
import org.optaplanner.core.config.score.trend.InitializingScoreTrendLevel;
import org.optaplanner.core.impl.score.buildin.bendable.BendableScoreDefinition;
import org.optaplanner.core.impl.score.trend.InitializingScoreTrend;

public class BendableScoreDefinitionTest {
    @Test
    public void getLevelsSize() {
        Assert.assertEquals((long)2L, (long)new BendableScoreDefinition(1, 1).getLevelsSize());
        Assert.assertEquals((long)7L, (long)new BendableScoreDefinition(3, 4).getLevelsSize());
        Assert.assertEquals((long)7L, (long)new BendableScoreDefinition(4, 3).getLevelsSize());
        Assert.assertEquals((long)5L, (long)new BendableScoreDefinition(0, 5).getLevelsSize());
        Assert.assertEquals((long)5L, (long)new BendableScoreDefinition(5, 0).getLevelsSize());
    }

    @Test
    public void getFeasibleLevelsSize() {
        Assert.assertEquals((long)1L, (long)new BendableScoreDefinition(1, 1).getFeasibleLevelsSize());
        Assert.assertEquals((long)3L, (long)new BendableScoreDefinition(3, 4).getFeasibleLevelsSize());
        Assert.assertEquals((long)4L, (long)new BendableScoreDefinition(4, 3).getFeasibleLevelsSize());
        Assert.assertEquals((long)0L, (long)new BendableScoreDefinition(0, 5).getFeasibleLevelsSize());
        Assert.assertEquals((long)5L, (long)new BendableScoreDefinition(5, 0).getFeasibleLevelsSize());
    }

    @Test(expected=IllegalArgumentException.class)
    public void createScoreWithIllegalArgument() {
        BendableScoreDefinition bendableScoreDefinition = new BendableScoreDefinition(2, 3);
        bendableScoreDefinition.createScore(new int[]{1, 2, 3});
    }

    @Test
    public void createScore() {
        int hardLevelSize = 3;
        int softLevelSize = 2;
        int levelSize = hardLevelSize + softLevelSize;
        int[] scores = new int[levelSize];
        for (int i = 0; i < levelSize; ++i) {
            scores[i] = i;
        }
        BendableScoreDefinition bendableScoreDefinition = new BendableScoreDefinition(hardLevelSize, softLevelSize);
        BendableScore bendableScore = bendableScoreDefinition.createScore(scores);
        Assert.assertEquals((long)hardLevelSize, (long)bendableScore.getHardLevelsSize());
        Assert.assertEquals((long)softLevelSize, (long)bendableScore.getSoftLevelsSize());
        for (int i = 0; i < levelSize; ++i) {
            if (i < hardLevelSize) {
                Assert.assertEquals((long)scores[i], (long)bendableScore.getHardScore(i));
                continue;
            }
            Assert.assertEquals((long)scores[i], (long)bendableScore.getSoftScore(i - hardLevelSize));
        }
    }

    @Test
    public void buildOptimisticBoundOnlyUp() {
        BendableScoreDefinition scoreDefinition = new BendableScoreDefinition(2, 3);
        BendableScore optimisticBound = scoreDefinition.buildOptimisticBound(InitializingScoreTrend.buildUniformTrend((InitializingScoreTrendLevel)InitializingScoreTrendLevel.ONLY_UP, (int)5), scoreDefinition.createScore(new int[]{-1, -2, -3, -4, -5}));
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)optimisticBound.getHardScore(0));
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)optimisticBound.getHardScore(1));
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)optimisticBound.getSoftScore(0));
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)optimisticBound.getSoftScore(1));
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)optimisticBound.getSoftScore(2));
    }

    @Test
    public void buildOptimisticBoundOnlyDown() {
        BendableScoreDefinition scoreDefinition = new BendableScoreDefinition(2, 3);
        BendableScore optimisticBound = scoreDefinition.buildOptimisticBound(InitializingScoreTrend.buildUniformTrend((InitializingScoreTrendLevel)InitializingScoreTrendLevel.ONLY_DOWN, (int)5), scoreDefinition.createScore(new int[]{-1, -2, -3, -4, -5}));
        Assert.assertEquals((long)-1L, (long)optimisticBound.getHardScore(0));
        Assert.assertEquals((long)-2L, (long)optimisticBound.getHardScore(1));
        Assert.assertEquals((long)-3L, (long)optimisticBound.getSoftScore(0));
        Assert.assertEquals((long)-4L, (long)optimisticBound.getSoftScore(1));
        Assert.assertEquals((long)-5L, (long)optimisticBound.getSoftScore(2));
    }

    @Test
    public void buildPessimisticBoundOnlyUp() {
        BendableScoreDefinition scoreDefinition = new BendableScoreDefinition(2, 3);
        BendableScore pessimisticBound = scoreDefinition.buildPessimisticBound(InitializingScoreTrend.buildUniformTrend((InitializingScoreTrendLevel)InitializingScoreTrendLevel.ONLY_UP, (int)5), scoreDefinition.createScore(new int[]{-1, -2, -3, -4, -5}));
        Assert.assertEquals((long)-1L, (long)pessimisticBound.getHardScore(0));
        Assert.assertEquals((long)-2L, (long)pessimisticBound.getHardScore(1));
        Assert.assertEquals((long)-3L, (long)pessimisticBound.getSoftScore(0));
        Assert.assertEquals((long)-4L, (long)pessimisticBound.getSoftScore(1));
        Assert.assertEquals((long)-5L, (long)pessimisticBound.getSoftScore(2));
    }

    @Test
    public void buildPessimisticBoundOnlyDown() {
        BendableScoreDefinition scoreDefinition = new BendableScoreDefinition(2, 3);
        BendableScore pessimisticBound = scoreDefinition.buildPessimisticBound(InitializingScoreTrend.buildUniformTrend((InitializingScoreTrendLevel)InitializingScoreTrendLevel.ONLY_DOWN, (int)5), scoreDefinition.createScore(new int[]{-1, -2, -3, -4, -5}));
        Assert.assertEquals((long)Integer.MIN_VALUE, (long)pessimisticBound.getHardScore(0));
        Assert.assertEquals((long)Integer.MIN_VALUE, (long)pessimisticBound.getHardScore(1));
        Assert.assertEquals((long)Integer.MIN_VALUE, (long)pessimisticBound.getSoftScore(0));
        Assert.assertEquals((long)Integer.MIN_VALUE, (long)pessimisticBound.getSoftScore(1));
        Assert.assertEquals((long)Integer.MIN_VALUE, (long)pessimisticBound.getSoftScore(2));
    }
}

