/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.buildin.simple;

import org.junit.Assert;
import org.junit.Test;
import org.optaplanner.core.api.score.buildin.simple.SimpleScore;
import org.optaplanner.core.config.score.trend.InitializingScoreTrendLevel;
import org.optaplanner.core.impl.score.buildin.simple.SimpleScoreDefinition;
import org.optaplanner.core.impl.score.trend.InitializingScoreTrend;

public class SimpleScoreDefinitionTest {
    @Test
    public void getLevelsSize() {
        Assert.assertEquals((long)1L, (long)new SimpleScoreDefinition().getLevelsSize());
    }

    @Test
    public void buildOptimisticBoundOnlyUp() {
        SimpleScoreDefinition scoreDefinition = new SimpleScoreDefinition();
        SimpleScore optimisticBound = scoreDefinition.buildOptimisticBound(InitializingScoreTrend.buildUniformTrend((InitializingScoreTrendLevel)InitializingScoreTrendLevel.ONLY_UP, (int)1), SimpleScore.valueOf((int)-1));
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)optimisticBound.getScore());
    }

    @Test
    public void buildOptimisticBoundOnlyDown() {
        SimpleScoreDefinition scoreDefinition = new SimpleScoreDefinition();
        SimpleScore optimisticBound = scoreDefinition.buildOptimisticBound(InitializingScoreTrend.buildUniformTrend((InitializingScoreTrendLevel)InitializingScoreTrendLevel.ONLY_DOWN, (int)1), SimpleScore.valueOf((int)-1));
        Assert.assertEquals((long)-1L, (long)optimisticBound.getScore());
    }

    @Test
    public void buildPessimisticBoundOnlyUp() {
        SimpleScoreDefinition scoreDefinition = new SimpleScoreDefinition();
        SimpleScore pessimisticBound = scoreDefinition.buildPessimisticBound(InitializingScoreTrend.buildUniformTrend((InitializingScoreTrendLevel)InitializingScoreTrendLevel.ONLY_UP, (int)1), SimpleScore.valueOf((int)-1));
        Assert.assertEquals((long)-1L, (long)pessimisticBound.getScore());
    }

    @Test
    public void buildPessimisticBoundOnlyDown() {
        SimpleScoreDefinition scoreDefinition = new SimpleScoreDefinition();
        SimpleScore pessimisticBound = scoreDefinition.buildPessimisticBound(InitializingScoreTrend.buildUniformTrend((InitializingScoreTrendLevel)InitializingScoreTrendLevel.ONLY_DOWN, (int)1), SimpleScore.valueOf((int)-1));
        Assert.assertEquals((long)Integer.MIN_VALUE, (long)pessimisticBound.getScore());
    }
}

