/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.testdata.domain.reflect.accessmodifier;

import java.util.Collection;
import java.util.List;
import org.optaplanner.core.api.domain.solution.PlanningEntityCollectionProperty;
import org.optaplanner.core.api.domain.solution.PlanningSolution;
import org.optaplanner.core.api.domain.solution.Solution;
import org.optaplanner.core.api.domain.valuerange.ValueRangeProvider;
import org.optaplanner.core.api.score.buildin.simple.SimpleScore;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.testdata.domain.TestdataEntity;
import org.optaplanner.core.impl.testdata.domain.TestdataObject;
import org.optaplanner.core.impl.testdata.domain.TestdataValue;

@PlanningSolution
public class TestdataAccessModifierSolution
extends TestdataObject
implements Solution<SimpleScore> {
    private static final String STATIC_FINAL_FIELD = "staticFinalFieldValue";
    private static Object staticField;
    private final String finalField;
    private String readWriteOnlyField;
    private List<TestdataValue> valueList;
    private List<TestdataEntity> entityList;
    private SimpleScore score;

    public static String getStaticFinalField() {
        return STATIC_FINAL_FIELD;
    }

    public static Object getStaticField() {
        return staticField;
    }

    public static void setStaticField(Object staticField) {
        TestdataAccessModifierSolution.staticField = staticField;
    }

    public static SolutionDescriptor buildSolutionDescriptor() {
        return SolutionDescriptor.buildSolutionDescriptor(TestdataAccessModifierSolution.class, (Class[])new Class[]{TestdataEntity.class});
    }

    private TestdataAccessModifierSolution() {
        this.finalField = "No-argument constructor";
    }

    public TestdataAccessModifierSolution(String code) {
        super(code);
        this.finalField = "Constructor with argument code (" + code + ")";
    }

    public String getFinalField() {
        return this.finalField;
    }

    public String getReadOnlyField() {
        return "read" + this.readWriteOnlyField;
    }

    public void setWriteOnlyField(String writeOnlyField) {
        if (!writeOnlyField.startsWith("write")) {
            throw new IllegalArgumentException("The writeOnlyField (" + writeOnlyField + ") should start with write.");
        }
        this.readWriteOnlyField = writeOnlyField.substring("write".length());
    }

    @ValueRangeProvider(id="valueRange")
    public List<TestdataValue> getValueList() {
        return this.valueList;
    }

    public void setValueList(List<TestdataValue> valueList) {
        this.valueList = valueList;
    }

    @PlanningEntityCollectionProperty
    public List<TestdataEntity> getEntityList() {
        return this.entityList;
    }

    public void setEntityList(List<TestdataEntity> entityList) {
        this.entityList = entityList;
    }

    public SimpleScore getScore() {
        return this.score;
    }

    public void setScore(SimpleScore score) {
        this.score = score;
    }

    public Collection<? extends Object> getProblemFacts() {
        return this.valueList;
    }
}

