/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.testdata.domain.shadow.extended;

import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.variable.CustomShadowVariable;
import org.optaplanner.core.api.domain.variable.PlanningVariable;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.listener.VariableListenerAdapter;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.core.impl.testdata.domain.TestdataObject;
import org.optaplanner.core.impl.testdata.domain.TestdataValue;
import org.optaplanner.core.impl.testdata.domain.shadow.extended.TestdataExtendedShadowedChildEntity;
import org.optaplanner.core.impl.testdata.domain.shadow.extended.TestdataExtendedShadowedSolution;

@PlanningEntity
public class TestdataExtendedShadowedParentEntity
extends TestdataObject {
    private TestdataValue value;
    private String firstShadow;
    private String thirdShadow;

    public static EntityDescriptor buildEntityDescriptor() {
        SolutionDescriptor solutionDescriptor = TestdataExtendedShadowedSolution.buildSolutionDescriptor();
        return solutionDescriptor.findEntityDescriptorOrFail(TestdataExtendedShadowedParentEntity.class);
    }

    public static GenuineVariableDescriptor buildVariableDescriptorForValue() {
        SolutionDescriptor solutionDescriptor = TestdataExtendedShadowedSolution.buildSolutionDescriptor();
        EntityDescriptor entityDescriptor = solutionDescriptor.findEntityDescriptorOrFail(TestdataExtendedShadowedParentEntity.class);
        return entityDescriptor.getGenuineVariableDescriptor("value");
    }

    public TestdataExtendedShadowedParentEntity() {
    }

    public TestdataExtendedShadowedParentEntity(String code) {
        super(code);
    }

    public TestdataExtendedShadowedParentEntity(String code, TestdataValue value) {
        this(code);
        this.value = value;
    }

    @PlanningVariable(valueRangeProviderRefs={"valueRange"})
    public TestdataValue getValue() {
        return this.value;
    }

    public void setValue(TestdataValue value) {
        this.value = value;
    }

    @CustomShadowVariable(variableListenerClass=FirstShadowUpdatingVariableListener.class, sources={@CustomShadowVariable.Source(variableName="value")})
    public String getFirstShadow() {
        return this.firstShadow;
    }

    public void setFirstShadow(String firstShadow) {
        this.firstShadow = firstShadow;
    }

    @CustomShadowVariable(variableListenerClass=ThirdShadowUpdatingVariableListener.class, sources={@CustomShadowVariable.Source(entityClass=TestdataExtendedShadowedChildEntity.class, variableName="secondShadow")})
    public String getThirdShadow() {
        return this.thirdShadow;
    }

    public void setThirdShadow(String thirdShadow) {
        this.thirdShadow = thirdShadow;
    }

    public static class ThirdShadowUpdatingVariableListener
    extends VariableListenerAdapter<TestdataExtendedShadowedChildEntity> {
        public void afterEntityAdded(ScoreDirector scoreDirector, TestdataExtendedShadowedChildEntity entity) {
            this.updateShadow(scoreDirector, entity);
        }

        public void afterVariableChanged(ScoreDirector scoreDirector, TestdataExtendedShadowedChildEntity entity) {
            this.updateShadow(scoreDirector, entity);
        }

        private void updateShadow(ScoreDirector scoreDirector, TestdataExtendedShadowedChildEntity entity) {
            String secondShadow = entity.getSecondShadow();
            scoreDirector.beforeVariableChanged((Object)entity, "thirdShadow");
            entity.setThirdShadow(secondShadow == null ? null : secondShadow + "/thirdShadow");
            scoreDirector.afterVariableChanged((Object)entity, "thirdShadow");
        }
    }

    public static class FirstShadowUpdatingVariableListener
    extends VariableListenerAdapter<TestdataExtendedShadowedParentEntity> {
        public void afterEntityAdded(ScoreDirector scoreDirector, TestdataExtendedShadowedParentEntity entity) {
            this.updateShadow(scoreDirector, entity);
        }

        public void afterVariableChanged(ScoreDirector scoreDirector, TestdataExtendedShadowedParentEntity entity) {
            this.updateShadow(scoreDirector, entity);
        }

        private void updateShadow(ScoreDirector scoreDirector, TestdataExtendedShadowedParentEntity entity) {
            TestdataValue value = entity.getValue();
            scoreDirector.beforeVariableChanged((Object)entity, "firstShadow");
            entity.setFirstShadow(value == null ? null : value.getCode() + "/firstShadow");
            scoreDirector.afterVariableChanged((Object)entity, "firstShadow");
        }
    }
}

