/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.config.constructionheuristic;

import org.optaplanner.core.config.constructionheuristic.placer.EntityPlacerConfig;
import org.optaplanner.core.config.constructionheuristic.placer.PooledEntityPlacerConfig;
import org.optaplanner.core.config.constructionheuristic.placer.QueuedEntityPlacerConfig;
import org.optaplanner.core.config.heuristic.selector.entity.EntitySorterManner;
import org.optaplanner.core.config.heuristic.selector.value.ValueSorterManner;

public enum ConstructionHeuristicType {
    FIRST_FIT,
    FIRST_FIT_DECREASING,
    WEAKEST_FIT,
    WEAKEST_FIT_DECREASING,
    STRONGEST_FIT,
    STRONGEST_FIT_DECREASING,
    ALLOCATE_ENTITY_FROM_QUEUE,
    CHEAPEST_INSERTION,
    ALLOCATE_FROM_POOL;


    public EntitySorterManner getDefaultEntitySorterManner() {
        switch (this) {
            case FIRST_FIT: 
            case WEAKEST_FIT: 
            case STRONGEST_FIT: {
                return EntitySorterManner.NONE;
            }
            case FIRST_FIT_DECREASING: 
            case WEAKEST_FIT_DECREASING: 
            case STRONGEST_FIT_DECREASING: {
                return EntitySorterManner.DECREASING_DIFFICULTY;
            }
            case ALLOCATE_ENTITY_FROM_QUEUE: 
            case CHEAPEST_INSERTION: 
            case ALLOCATE_FROM_POOL: {
                return EntitySorterManner.DECREASING_DIFFICULTY_IF_AVAILABLE;
            }
        }
        throw new IllegalStateException("The constructionHeuristicType (" + (Object)((Object)this) + ") is not implemented.");
    }

    public ValueSorterManner getDefaultValueSorterManner() {
        switch (this) {
            case FIRST_FIT: 
            case FIRST_FIT_DECREASING: {
                return ValueSorterManner.NONE;
            }
            case WEAKEST_FIT: 
            case WEAKEST_FIT_DECREASING: {
                return ValueSorterManner.INCREASING_STRENGTH;
            }
            case STRONGEST_FIT: 
            case STRONGEST_FIT_DECREASING: {
                return ValueSorterManner.DECREASING_STRENGTH;
            }
            case ALLOCATE_ENTITY_FROM_QUEUE: 
            case CHEAPEST_INSERTION: 
            case ALLOCATE_FROM_POOL: {
                return ValueSorterManner.INCREASING_STRENGTH_IF_AVAILABLE;
            }
        }
        throw new IllegalStateException("The constructionHeuristicType (" + (Object)((Object)this) + ") is not implemented.");
    }

    public EntityPlacerConfig newEntityPlacerConfig() {
        switch (this) {
            case FIRST_FIT: 
            case WEAKEST_FIT: 
            case STRONGEST_FIT: 
            case FIRST_FIT_DECREASING: 
            case WEAKEST_FIT_DECREASING: 
            case STRONGEST_FIT_DECREASING: 
            case ALLOCATE_ENTITY_FROM_QUEUE: {
                return new QueuedEntityPlacerConfig();
            }
            case CHEAPEST_INSERTION: 
            case ALLOCATE_FROM_POOL: {
                return new PooledEntityPlacerConfig();
            }
        }
        throw new IllegalStateException("The constructionHeuristicType (" + (Object)((Object)this) + ") is not implemented.");
    }

    public static ConstructionHeuristicType[] getBluePrintTypes() {
        return new ConstructionHeuristicType[]{FIRST_FIT, FIRST_FIT_DECREASING, WEAKEST_FIT, WEAKEST_FIT_DECREASING, STRONGEST_FIT, STRONGEST_FIT_DECREASING, CHEAPEST_INSERTION};
    }
}

