/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.buildin.bendable;

import org.junit.Assert;
import org.junit.Test;
import org.kie.api.runtime.rule.RuleContext;
import org.optaplanner.core.api.score.buildin.bendable.BendableScore;
import org.optaplanner.core.api.score.buildin.bendable.BendableScoreHolder;
import org.optaplanner.core.api.score.holder.AbstractScoreHolderTest;

public class BendableScoreHolderTest
extends AbstractScoreHolderTest {
    @Test
    public void addConstraintMatchWithConstraintMatch() {
        this.addConstraintMatch(true);
    }

    @Test
    public void addConstraintMatchWithoutConstraintMatch() {
        this.addConstraintMatch(false);
    }

    public void addConstraintMatch(boolean constraintMatchEnabled) {
        BendableScoreHolder scoreHolder = new BendableScoreHolder(constraintMatchEnabled, 1, 2);
        scoreHolder.addHardConstraintMatch(this.mockRuleContext("scoreRule1"), 0, -10000);
        Assert.assertEquals((Object)BendableScore.valueOf((int[])new int[]{-10000}, (int[])new int[]{0, 0}), (Object)scoreHolder.extractScore());
        RuleContext ruleContext2 = this.mockRuleContext("scoreRule2");
        scoreHolder.addHardConstraintMatch(ruleContext2, 0, -2000);
        Assert.assertEquals((Object)BendableScore.valueOf((int[])new int[]{-12000}, (int[])new int[]{0, 0}), (Object)scoreHolder.extractScore());
        this.callUnMatch(ruleContext2);
        Assert.assertEquals((Object)BendableScore.valueOf((int[])new int[]{-10000}, (int[])new int[]{0, 0}), (Object)scoreHolder.extractScore());
        RuleContext ruleContext3 = this.mockRuleContext("scoreRule3");
        scoreHolder.addHardConstraintMatch(ruleContext3, 0, -900);
        scoreHolder.addHardConstraintMatch(ruleContext3, 0, -300);
        scoreHolder.addSoftConstraintMatch(ruleContext3, 0, -90);
        scoreHolder.addSoftConstraintMatch(ruleContext3, 0, -40);
        Assert.assertEquals((Object)BendableScore.valueOf((int[])new int[]{-10300}, (int[])new int[]{-40, 0}), (Object)scoreHolder.extractScore());
        scoreHolder.addSoftConstraintMatch(this.mockRuleContext("scoreRule4"), 1, -5);
        Assert.assertEquals((Object)BendableScore.valueOf((int[])new int[]{-10300}, (int[])new int[]{-40, -5}), (Object)scoreHolder.extractScore());
        RuleContext ruleContext5 = this.mockRuleContext("scoreRule5");
        scoreHolder.addHardConstraintMatch(ruleContext5, 0, -2000);
        scoreHolder.addSoftConstraintMatch(ruleContext5, 0, -2000);
        Assert.assertEquals((Object)BendableScore.valueOf((int[])new int[]{-12300}, (int[])new int[]{-2040, -5}), (Object)scoreHolder.extractScore());
        this.callUnMatch(ruleContext5);
        Assert.assertEquals((Object)BendableScore.valueOf((int[])new int[]{-10300}, (int[])new int[]{-40, -5}), (Object)scoreHolder.extractScore());
        if (constraintMatchEnabled) {
            Assert.assertEquals((long)7L, (long)scoreHolder.getConstraintMatchTotals().size());
        }
    }
}

