/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.buildin.bendablebigdecimal;

import java.math.BigDecimal;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.runtime.rule.RuleContext;
import org.optaplanner.core.api.score.buildin.bendablebigdecimal.BendableBigDecimalScore;
import org.optaplanner.core.api.score.buildin.bendablebigdecimal.BendableBigDecimalScoreHolder;
import org.optaplanner.core.api.score.holder.AbstractScoreHolderTest;

public class BendableBigDecimalScoreHolderTest
extends AbstractScoreHolderTest {
    @Test
    public void addConstraintMatchWithConstraintMatch() {
        this.addConstraintMatch(true);
    }

    @Test
    public void addConstraintMatchWithoutConstraintMatch() {
        this.addConstraintMatch(false);
    }

    public void addConstraintMatch(boolean constraintMatchEnabled) {
        BendableBigDecimalScoreHolder scoreHolder = new BendableBigDecimalScoreHolder(constraintMatchEnabled, 1, 2);
        scoreHolder.addHardConstraintMatch(this.mockRuleContext("scoreRule1"), 0, BigDecimal.valueOf(-10000L));
        RuleContext ruleContext2 = this.mockRuleContext("scoreRule2");
        scoreHolder.addHardConstraintMatch(ruleContext2, 0, BigDecimal.valueOf(-2000L));
        this.callUnMatch(ruleContext2);
        RuleContext ruleContext3 = this.mockRuleContext("scoreRule3");
        scoreHolder.addSoftConstraintMatch(ruleContext3, 0, BigDecimal.valueOf(-90L));
        scoreHolder.addSoftConstraintMatch(ruleContext3, 0, BigDecimal.valueOf(-40L));
        scoreHolder.addHardConstraintMatch(ruleContext3, 0, BigDecimal.valueOf(-900L));
        scoreHolder.addHardConstraintMatch(ruleContext3, 0, BigDecimal.valueOf(-300L));
        scoreHolder.addSoftConstraintMatch(this.mockRuleContext("scoreRule4"), 1, BigDecimal.valueOf(-5L));
        RuleContext ruleContext5 = this.mockRuleContext("scoreRule5");
        scoreHolder.addHardConstraintMatch(ruleContext5, 0, BigDecimal.valueOf(-900L));
        scoreHolder.addSoftConstraintMatch(ruleContext5, 0, BigDecimal.valueOf(-9L));
        this.callUnMatch(ruleContext5);
        Assert.assertEquals((Object)BendableBigDecimalScore.valueOf((BigDecimal[])new BigDecimal[]{BigDecimal.valueOf(-10300L)}, (BigDecimal[])new BigDecimal[]{BigDecimal.valueOf(-40L), BigDecimal.valueOf(-5L)}), (Object)scoreHolder.extractScore());
        if (constraintMatchEnabled) {
            Assert.assertEquals((long)7L, (long)scoreHolder.getConstraintMatchTotals().size());
        }
    }
}

