/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.buildin.hardsoft;

import org.junit.Assert;
import org.junit.Test;
import org.kie.api.runtime.rule.RuleContext;
import org.optaplanner.core.api.score.buildin.hardsoft.HardSoftScore;
import org.optaplanner.core.api.score.buildin.hardsoft.HardSoftScoreHolder;
import org.optaplanner.core.api.score.holder.AbstractScoreHolderTest;

public class HardSoftScoreHolderTest
extends AbstractScoreHolderTest {
    @Test
    public void addConstraintMatchWithConstraintMatch() {
        this.addConstraintMatch(true);
    }

    @Test
    public void addConstraintMatchWithoutConstraintMatch() {
        this.addConstraintMatch(false);
    }

    public void addConstraintMatch(boolean constraintMatchEnabled) {
        HardSoftScoreHolder scoreHolder = new HardSoftScoreHolder(constraintMatchEnabled);
        scoreHolder.addHardConstraintMatch(this.mockRuleContext("scoreRule1"), -1000);
        RuleContext ruleContext2 = this.mockRuleContext("scoreRule2");
        scoreHolder.addHardConstraintMatch(ruleContext2, -200);
        this.callUnMatch(ruleContext2);
        RuleContext ruleContext3 = this.mockRuleContext("scoreRule3");
        scoreHolder.addSoftConstraintMatch(ruleContext3, -30);
        scoreHolder.addSoftConstraintMatch(ruleContext3, -3);
        scoreHolder.addHardConstraintMatch(ruleContext3, -300);
        scoreHolder.addHardConstraintMatch(ruleContext3, -400);
        RuleContext ruleContext4 = this.mockRuleContext("scoreRule4");
        scoreHolder.addHardConstraintMatch(ruleContext4, -1);
        scoreHolder.addSoftConstraintMatch(ruleContext4, -1);
        this.callUnMatch(ruleContext4);
        Assert.assertEquals((Object)HardSoftScore.valueOf((int)-1400, (int)-3), (Object)scoreHolder.extractScore());
        if (constraintMatchEnabled) {
            Assert.assertEquals((long)6L, (long)scoreHolder.getConstraintMatchTotals().size());
        }
    }
}

