/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.buildin.hardsoftbigdecimal;

import java.math.BigDecimal;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.runtime.rule.RuleContext;
import org.optaplanner.core.api.score.buildin.hardsoftbigdecimal.HardSoftBigDecimalScore;
import org.optaplanner.core.api.score.buildin.hardsoftbigdecimal.HardSoftBigDecimalScoreHolder;
import org.optaplanner.core.api.score.holder.AbstractScoreHolderTest;

public class HardSoftBigDecimalScoreHolderTest
extends AbstractScoreHolderTest {
    @Test
    public void addConstraintMatchWithConstraintMatch() {
        this.addConstraintMatch(true);
    }

    @Test
    public void addConstraintMatchWithoutConstraintMatch() {
        this.addConstraintMatch(false);
    }

    public void addConstraintMatch(boolean constraintMatchEnabled) {
        HardSoftBigDecimalScoreHolder scoreHolder = new HardSoftBigDecimalScoreHolder(constraintMatchEnabled);
        scoreHolder.addHardConstraintMatch(this.mockRuleContext("scoreRule1"), new BigDecimal("-10.00"));
        RuleContext ruleContext2 = this.mockRuleContext("scoreRule2");
        scoreHolder.addHardConstraintMatch(ruleContext2, new BigDecimal("-2.00"));
        this.callUnMatch(ruleContext2);
        RuleContext ruleContext3 = this.mockRuleContext("scoreRule3");
        scoreHolder.addSoftConstraintMatch(ruleContext3, new BigDecimal("-0.30"));
        scoreHolder.addSoftConstraintMatch(ruleContext3, new BigDecimal("-0.03"));
        scoreHolder.addHardConstraintMatch(ruleContext3, new BigDecimal("-3.00"));
        scoreHolder.addHardConstraintMatch(ruleContext3, new BigDecimal("-4.00"));
        RuleContext ruleContext4 = this.mockRuleContext("scoreRule4");
        scoreHolder.addHardConstraintMatch(ruleContext4, new BigDecimal("-1.00"));
        scoreHolder.addSoftConstraintMatch(ruleContext4, new BigDecimal("-1.00"));
        this.callUnMatch(ruleContext4);
        Assert.assertEquals((Object)HardSoftBigDecimalScore.valueOf((BigDecimal)new BigDecimal("-14.00"), (BigDecimal)new BigDecimal("-0.03")), (Object)scoreHolder.extractScore());
        if (constraintMatchEnabled) {
            Assert.assertEquals((long)6L, (long)scoreHolder.getConstraintMatchTotals().size());
        }
    }
}

