/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.buildin.hardsoftdouble;

import org.junit.Assert;
import org.junit.Test;
import org.kie.api.runtime.rule.RuleContext;
import org.optaplanner.core.api.score.buildin.hardsoftdouble.HardSoftDoubleScore;
import org.optaplanner.core.api.score.buildin.hardsoftdouble.HardSoftDoubleScoreHolder;
import org.optaplanner.core.api.score.holder.AbstractScoreHolderTest;

public class HardSoftDoubleScoreHolderTest
extends AbstractScoreHolderTest {
    @Test
    public void addConstraintMatchWithConstraintMatch() {
        this.addConstraintMatch(true);
    }

    @Test
    public void addConstraintMatchWithoutConstraintMatch() {
        this.addConstraintMatch(false);
    }

    public void addConstraintMatch(boolean constraintMatchEnabled) {
        HardSoftDoubleScoreHolder scoreHolder = new HardSoftDoubleScoreHolder(constraintMatchEnabled);
        scoreHolder.addHardConstraintMatch(this.mockRuleContext("scoreRule1"), -10.0);
        RuleContext ruleContext2 = this.mockRuleContext("scoreRule2");
        scoreHolder.addHardConstraintMatch(ruleContext2, -2.0);
        this.callUnMatch(ruleContext2);
        RuleContext ruleContext3 = this.mockRuleContext("scoreRule3");
        scoreHolder.addSoftConstraintMatch(ruleContext3, -0.3);
        scoreHolder.addSoftConstraintMatch(ruleContext3, -0.06);
        scoreHolder.addHardConstraintMatch(ruleContext3, -3.0);
        scoreHolder.addHardConstraintMatch(ruleContext3, -4.0);
        RuleContext ruleContext4 = this.mockRuleContext("scoreRule4");
        scoreHolder.addHardConstraintMatch(ruleContext4, -1.0);
        scoreHolder.addSoftConstraintMatch(ruleContext4, -0.02);
        this.callUnMatch(ruleContext4);
        Assert.assertEquals((Object)HardSoftDoubleScore.valueOf((double)-14.0, (double)-0.06), (Object)scoreHolder.extractScore());
        if (constraintMatchEnabled) {
            Assert.assertEquals((long)6L, (long)scoreHolder.getConstraintMatchTotals().size());
        }
    }
}

