/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.buildin.simplebigdecimal;

import java.math.BigDecimal;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.runtime.rule.RuleContext;
import org.optaplanner.core.api.score.buildin.simplebigdecimal.SimpleBigDecimalScore;
import org.optaplanner.core.api.score.buildin.simplebigdecimal.SimpleBigDecimalScoreHolder;
import org.optaplanner.core.api.score.holder.AbstractScoreHolderTest;

public class SimpleBigDecimalScoreHolderTest
extends AbstractScoreHolderTest {
    @Test
    public void addConstraintMatchWithConstraintMatch() {
        this.addConstraintMatch(true);
    }

    @Test
    public void addConstraintMatchWithoutConstraintMatch() {
        this.addConstraintMatch(false);
    }

    public void addConstraintMatch(boolean constraintMatchEnabled) {
        SimpleBigDecimalScoreHolder scoreHolder = new SimpleBigDecimalScoreHolder(constraintMatchEnabled);
        scoreHolder.addConstraintMatch(this.mockRuleContext("scoreRule1"), new BigDecimal("-10.00"));
        RuleContext ruleContext2 = this.mockRuleContext("scoreRule2");
        scoreHolder.addConstraintMatch(ruleContext2, new BigDecimal("-2.00"));
        this.callUnMatch(ruleContext2);
        RuleContext ruleContext3 = this.mockRuleContext("scoreRule3");
        scoreHolder.addConstraintMatch(ruleContext3, new BigDecimal("-0.30"));
        scoreHolder.addConstraintMatch(ruleContext3, new BigDecimal("-0.03"));
        Assert.assertEquals((Object)SimpleBigDecimalScore.valueOf((BigDecimal)new BigDecimal("-10.03")), (Object)scoreHolder.extractScore());
        if (constraintMatchEnabled) {
            Assert.assertEquals((long)3L, (long)scoreHolder.getConstraintMatchTotals().size());
        }
    }
}

