/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.solver;

import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import org.optaplanner.core.api.solver.DivertingClassLoader;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.core.config.solver.termination.TerminationConfig;

public class SolverFactoryTest {
    @Test
    public void testdataSolverConfigWithoutGenericsForBackwardsCompatibility() {
        SolverFactory solverFactory = SolverFactory.createFromXmlResource((String)"org/optaplanner/core/api/solver/testdataSolverConfig.xml");
        Solver solver = solverFactory.buildSolver();
        Assert.assertNotNull((Object)solver);
    }

    @Test
    public void testdataSolverConfig() {
        SolverFactory solverFactory = SolverFactory.createFromXmlResource((String)"org/optaplanner/core/api/solver/testdataSolverConfig.xml");
        Solver solver = solverFactory.buildSolver();
        Assert.assertNotNull((Object)solver);
    }

    @Test(expected=IllegalArgumentException.class)
    public void nonExistingSolverConfig() {
        SolverFactory solverFactory = SolverFactory.createFromXmlResource((String)"org/optaplanner/core/api/solver/nonExistingSolverConfig.xml");
        Solver solver = solverFactory.buildSolver();
        Assert.assertNotNull((Object)solver);
    }

    @Test
    public void testdataSolverConfigWithClassLoader() throws ClassNotFoundException, IOException {
        DivertingClassLoader classLoader = new DivertingClassLoader(this.getClass().getClassLoader());
        SolverFactory solverFactory = SolverFactory.createFromXmlResource((String)"divertThroughClassLoader/org/optaplanner/core/api/solver/classloaderTestdataSolverConfig.xml", (ClassLoader)classLoader);
        Solver solver = solverFactory.buildSolver();
        Assert.assertNotNull((Object)solver);
    }

    @Test
    public void cloneSolverFactory() {
        SolverFactory solverFactoryTemplate = SolverFactory.createFromXmlResource((String)"org/optaplanner/core/api/solver/testdataSolverConfig.xml");
        solverFactoryTemplate.getSolverConfig().setTerminationConfig(new TerminationConfig());
        SolverFactory solverFactory1 = solverFactoryTemplate.cloneSolverFactory();
        SolverFactory solverFactory2 = solverFactoryTemplate.cloneSolverFactory();
        Assert.assertNotSame((Object)solverFactory1, (Object)solverFactory2);
        solverFactory1.getSolverConfig().getTerminationConfig().setMinutesSpentLimit(Long.valueOf(1L));
        solverFactory2.getSolverConfig().getTerminationConfig().setMinutesSpentLimit(Long.valueOf(2L));
        Assert.assertEquals((Object)1L, (Object)solverFactory1.getSolverConfig().getTerminationConfig().getMinutesSpentLimit());
        Assert.assertEquals((Object)2L, (Object)solverFactory2.getSolverConfig().getTerminationConfig().getMinutesSpentLimit());
        Solver solver1 = solverFactory1.buildSolver();
        Solver solver2 = solverFactory2.buildSolver();
        Assert.assertNotSame((Object)solver1, (Object)solver2);
    }
}

