/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.config.solver.termination;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.optaplanner.core.config.heuristic.policy.HeuristicConfigPolicy;
import org.optaplanner.core.config.solver.termination.TerminationConfig;
import org.optaplanner.core.impl.solver.termination.Termination;
import org.optaplanner.core.impl.solver.termination.TimeMillisSpentTermination;
import org.optaplanner.core.impl.solver.termination.UnimprovedTimeMillisSpentTermination;
import org.optaplanner.core.impl.testdata.util.PlannerAssert;

public class TerminationConfigTest {
    @Test
    public void spendLimit() {
        TerminationConfig terminationConfig = new TerminationConfig();
        terminationConfig.setMillisecondsSpentLimit(Long.valueOf(5L));
        terminationConfig.setSecondsSpentLimit(Long.valueOf(4L));
        terminationConfig.setMinutesSpentLimit(Long.valueOf(3L));
        terminationConfig.setHoursSpentLimit(Long.valueOf(2L));
        terminationConfig.setDaysSpentLimit(Long.valueOf(1L));
        Termination termination = terminationConfig.buildTermination((HeuristicConfigPolicy)Mockito.mock(HeuristicConfigPolicy.class));
        PlannerAssert.assertInstanceOf(TimeMillisSpentTermination.class, termination);
        Assert.assertEquals((long)93784005L, (long)((TimeMillisSpentTermination)termination).getTimeMillisSpentLimit());
    }

    @Test
    public void unimprovedSpendLimit() {
        TerminationConfig terminationConfig = new TerminationConfig();
        terminationConfig.setUnimprovedMillisecondsSpentLimit(Long.valueOf(5L));
        terminationConfig.setUnimprovedSecondsSpentLimit(Long.valueOf(4L));
        terminationConfig.setUnimprovedMinutesSpentLimit(Long.valueOf(3L));
        terminationConfig.setUnimprovedHoursSpentLimit(Long.valueOf(2L));
        terminationConfig.setUnimprovedDaysSpentLimit(Long.valueOf(1L));
        Termination termination = terminationConfig.buildTermination((HeuristicConfigPolicy)Mockito.mock(HeuristicConfigPolicy.class));
        PlannerAssert.assertInstanceOf(UnimprovedTimeMillisSpentTermination.class, termination);
        Assert.assertEquals((long)93784005L, (long)((UnimprovedTimeMillisSpentTermination)termination).getUnimprovedTimeMillisSpentLimit());
    }
}

