/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.config.util;

import org.junit.Assert;
import org.junit.Test;
import org.optaplanner.core.config.util.ConfigUtils;

public class ConfigUtilsTest {
    @Test
    public void testMergeProperty() {
        Integer a = null;
        Integer b = null;
        Assert.assertEquals(null, (Object)ConfigUtils.mergeProperty(a, b));
        a = 1;
        Assert.assertEquals(null, (Object)ConfigUtils.mergeProperty((Object)a, b));
        b = 10;
        Assert.assertEquals(null, (Object)ConfigUtils.mergeProperty((Object)a, (Object)b));
        b = 1;
        Assert.assertEquals((Object)1, (Object)ConfigUtils.mergeProperty((Object)a, (Object)b));
        a = null;
        Assert.assertEquals(null, (Object)ConfigUtils.mergeProperty((Object)a, (Object)b));
    }

    @Test
    public void testMeldProperty() {
        Integer a = null;
        Integer b = null;
        Assert.assertEquals(null, (Object)ConfigUtils.meldProperty(a, b));
        a = 1;
        Assert.assertEquals((Object)1, (Object)ConfigUtils.meldProperty((Object)a, b));
        b = 10;
        Assert.assertEquals((Object)ConfigUtils.mergeProperty((Object)1, (Object)10), (Object)ConfigUtils.meldProperty((Object)a, (Object)b));
        a = null;
        Assert.assertEquals((Object)10, (Object)ConfigUtils.meldProperty((Object)a, (Object)b));
    }

    @Test
    public void testCeilDivide() {
        Assert.assertEquals((long)10L, (long)ConfigUtils.ceilDivide((int)19, (int)2));
        Assert.assertEquals((long)10L, (long)ConfigUtils.ceilDivide((int)20, (int)2));
        Assert.assertEquals((long)11L, (long)ConfigUtils.ceilDivide((int)21, (int)2));
        Assert.assertEquals((long)-9L, (long)ConfigUtils.ceilDivide((int)19, (int)-2));
        Assert.assertEquals((long)-10L, (long)ConfigUtils.ceilDivide((int)20, (int)-2));
        Assert.assertEquals((long)-10L, (long)ConfigUtils.ceilDivide((int)21, (int)-2));
        Assert.assertEquals((long)-9L, (long)ConfigUtils.ceilDivide((int)-19, (int)2));
        Assert.assertEquals((long)-10L, (long)ConfigUtils.ceilDivide((int)-20, (int)2));
        Assert.assertEquals((long)-10L, (long)ConfigUtils.ceilDivide((int)-21, (int)2));
        Assert.assertEquals((long)10L, (long)ConfigUtils.ceilDivide((int)-19, (int)-2));
        Assert.assertEquals((long)10L, (long)ConfigUtils.ceilDivide((int)-20, (int)-2));
        Assert.assertEquals((long)11L, (long)ConfigUtils.ceilDivide((int)-21, (int)-2));
    }

    @Test
    public void testFloorDivide() {
        Assert.assertEquals((long)9L, (long)ConfigUtils.floorDivide((long)19L, (long)2L));
        Assert.assertEquals((long)10L, (long)ConfigUtils.floorDivide((long)20L, (long)2L));
        Assert.assertEquals((long)10L, (long)ConfigUtils.floorDivide((long)21L, (long)2L));
        Assert.assertEquals((long)-10L, (long)ConfigUtils.floorDivide((long)19L, (long)-2L));
        Assert.assertEquals((long)-10L, (long)ConfigUtils.floorDivide((long)20L, (long)-2L));
        Assert.assertEquals((long)-11L, (long)ConfigUtils.floorDivide((long)21L, (long)-2L));
        Assert.assertEquals((long)-10L, (long)ConfigUtils.floorDivide((long)-19L, (long)2L));
        Assert.assertEquals((long)-10L, (long)ConfigUtils.floorDivide((long)-20L, (long)2L));
        Assert.assertEquals((long)-11L, (long)ConfigUtils.floorDivide((long)-21L, (long)2L));
        Assert.assertEquals((long)9L, (long)ConfigUtils.floorDivide((long)-19L, (long)-2L));
        Assert.assertEquals((long)10L, (long)ConfigUtils.floorDivide((long)-20L, (long)-2L));
        Assert.assertEquals((long)10L, (long)ConfigUtils.floorDivide((long)-21L, (long)-2L));
    }

    @Test(expected=ArithmeticException.class)
    public void testCeilDivideByZero() {
        ConfigUtils.ceilDivide((int)20, (int)0);
    }

    @Test(expected=ArithmeticException.class)
    public void testFloorDivideByZero() {
        ConfigUtils.floorDivide((long)20L, (long)0L);
    }
}

