/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.constructionheuristic.placer.entity;

import java.util.Iterator;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.optaplanner.core.impl.constructionheuristic.placer.Placement;
import org.optaplanner.core.impl.constructionheuristic.placer.QueuedValuePlacer;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.heuristic.selector.SelectorTestUtils;
import org.optaplanner.core.impl.heuristic.selector.entity.EntitySelector;
import org.optaplanner.core.impl.heuristic.selector.move.MoveSelector;
import org.optaplanner.core.impl.heuristic.selector.move.generic.ChangeMove;
import org.optaplanner.core.impl.heuristic.selector.move.generic.ChangeMoveSelector;
import org.optaplanner.core.impl.heuristic.selector.value.EntityIndependentValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.ValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.mimic.MimicRecordingValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.mimic.MimicReplayingValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.mimic.ValueMimicRecorder;
import org.optaplanner.core.impl.phase.event.PhaseLifecycleListener;
import org.optaplanner.core.impl.phase.scope.AbstractPhaseScope;
import org.optaplanner.core.impl.phase.scope.AbstractStepScope;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;
import org.optaplanner.core.impl.testdata.domain.TestdataEntity;
import org.optaplanner.core.impl.testdata.domain.TestdataValue;
import org.optaplanner.core.impl.testdata.util.PlannerAssert;

public class QueuedValuePlacerTest {
    @Test
    public void oneMoveSelector() {
        GenuineVariableDescriptor variableDescriptor = TestdataEntity.buildVariableDescriptorForValue();
        EntitySelector entitySelector = SelectorTestUtils.mockEntitySelector(variableDescriptor.getEntityDescriptor(), new TestdataEntity("a"), new TestdataEntity("b"), new TestdataEntity("c"));
        EntityIndependentValueSelector valueSelector = SelectorTestUtils.mockEntityIndependentValueSelector(variableDescriptor, new TestdataValue("1"), new TestdataValue("2"));
        MimicRecordingValueSelector recordingValueSelector = new MimicRecordingValueSelector(valueSelector);
        ChangeMoveSelector moveSelector = new ChangeMoveSelector(entitySelector, (ValueSelector)new MimicReplayingValueSelector((ValueMimicRecorder)recordingValueSelector), false);
        QueuedValuePlacer placer = new QueuedValuePlacer((EntityIndependentValueSelector)recordingValueSelector, (MoveSelector)moveSelector);
        DefaultSolverScope solverScope = (DefaultSolverScope)Mockito.mock(DefaultSolverScope.class);
        placer.solvingStarted(solverScope);
        AbstractPhaseScope phaseScopeA = (AbstractPhaseScope)Mockito.mock(AbstractPhaseScope.class);
        Mockito.when((Object)phaseScopeA.getSolverScope()).thenReturn((Object)solverScope);
        placer.phaseStarted(phaseScopeA);
        Iterator placementIterator = placer.iterator();
        Assert.assertTrue((boolean)placementIterator.hasNext());
        AbstractStepScope stepScopeA1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA1.getPhaseScope()).thenReturn((Object)phaseScopeA);
        placer.stepStarted(stepScopeA1);
        this.assertPlacement((Placement)placementIterator.next(), "1", "a", "b", "c");
        placer.stepEnded(stepScopeA1);
        Assert.assertTrue((boolean)placementIterator.hasNext());
        AbstractStepScope stepScopeA2 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA2.getPhaseScope()).thenReturn((Object)phaseScopeA);
        placer.stepStarted(stepScopeA2);
        this.assertPlacement((Placement)placementIterator.next(), "2", "a", "b", "c");
        placer.stepEnded(stepScopeA2);
        Assert.assertTrue((boolean)placementIterator.hasNext());
        AbstractStepScope stepScopeA3 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA3.getPhaseScope()).thenReturn((Object)phaseScopeA);
        placer.stepStarted(stepScopeA3);
        this.assertPlacement((Placement)placementIterator.next(), "1", "a", "b", "c");
        placer.stepEnded(stepScopeA3);
        placer.phaseEnded(phaseScopeA);
        AbstractPhaseScope phaseScopeB = (AbstractPhaseScope)Mockito.mock(AbstractPhaseScope.class);
        Mockito.when((Object)phaseScopeB.getSolverScope()).thenReturn((Object)solverScope);
        placer.phaseStarted(phaseScopeB);
        placementIterator = placer.iterator();
        Assert.assertTrue((boolean)placementIterator.hasNext());
        AbstractStepScope stepScopeB1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB1.getPhaseScope()).thenReturn((Object)phaseScopeB);
        placer.stepStarted(stepScopeB1);
        this.assertPlacement((Placement)placementIterator.next(), "1", "a", "b", "c");
        placer.stepEnded(stepScopeB1);
        placer.phaseEnded(phaseScopeB);
        placer.solvingEnded(solverScope);
        PlannerAssert.verifyPhaseLifecycle((PhaseLifecycleListener)entitySelector, 1, 2, 4);
        PlannerAssert.verifyPhaseLifecycle((PhaseLifecycleListener)valueSelector, 1, 2, 4);
    }

    private void assertPlacement(Placement placement, String valueCode, String ... entityCodes) {
        Iterator iterator = placement.iterator();
        Assert.assertNotNull((Object)iterator);
        for (String entityCode : entityCodes) {
            Assert.assertTrue((boolean)iterator.hasNext());
            ChangeMove move = (ChangeMove)iterator.next();
            PlannerAssert.assertCode(entityCode, move.getEntity());
            PlannerAssert.assertCode(valueCode, move.getToPlanningValue());
        }
        Assert.assertFalse((boolean)iterator.hasNext());
    }
}

