/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.solution;

import java.util.Arrays;
import java.util.List;
import org.junit.Test;
import org.optaplanner.core.api.domain.solution.PlanningEntityCollectionProperty;
import org.optaplanner.core.api.domain.solution.PlanningEntityProperty;
import org.optaplanner.core.api.domain.valuerange.ValueRangeProvider;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.simple.SimpleScore;
import org.optaplanner.core.impl.domain.solution.AbstractSolution;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.testdata.domain.TestdataEntity;
import org.optaplanner.core.impl.testdata.domain.TestdataValue;
import org.optaplanner.core.impl.testdata.util.PlannerAssert;

public class AbstractSolutionTest {
    @Test
    public void getScore() {
        TestdataAbstractSolutionBasedSolution solution = new TestdataAbstractSolutionBasedSolution();
        solution.setScore(null);
        PlannerAssert.assertEquals(null, (Object)solution.getScore());
        solution.setScore((Score)SimpleScore.valueOf((int)-10));
        PlannerAssert.assertEquals((Object)SimpleScore.valueOf((int)-10), (Object)solution.getScore());
        solution.setScore((Score)SimpleScore.valueOf((int)-2));
        PlannerAssert.assertEquals((Object)SimpleScore.valueOf((int)-2), (Object)solution.getScore());
    }

    @Test
    public void getProblemFacts() {
        TestdataAbstractSolutionBasedSolution solution = new TestdataAbstractSolutionBasedSolution();
        TestdataValue singleValue = new TestdataValue("sv1");
        solution.setSingleValue(singleValue);
        TestdataValue v1 = new TestdataValue("v1");
        TestdataValue v2 = new TestdataValue("v2");
        TestdataValue v3 = new TestdataValue("v3");
        List<TestdataValue> valueList = Arrays.asList(v1, v2, v3);
        solution.setValueList(valueList);
        List<TestdataEntity> entityList = Arrays.asList(new TestdataEntity("e1"), new TestdataEntity("e2"), new TestdataEntity("e3"));
        solution.setEntityList(entityList);
        TestdataEntity singleEntity = new TestdataEntity("se1");
        solution.setSingleEntity(singleEntity);
        SimpleScore score = SimpleScore.valueOf((int)-10);
        solution.setScore((Score)score);
        PlannerAssert.assertCollectionContainsExactly(solution.getProblemFacts(), singleValue, v1, v2, v3);
    }

    @Test
    public void getProblemFactsWithNullField() {
        TestdataAbstractSolutionBasedSolution solution = new TestdataAbstractSolutionBasedSolution();
        solution.setSingleValue(null);
        TestdataValue v1 = new TestdataValue("v1");
        TestdataValue v2 = new TestdataValue("v2");
        TestdataValue v3 = new TestdataValue("v3");
        List<TestdataValue> valueList = Arrays.asList(v1, v2, v3);
        solution.setValueList(valueList);
        solution.setEntityList(null);
        solution.setSingleEntity(null);
        solution.setScore(null);
        PlannerAssert.assertCollectionContainsExactly(solution.getProblemFacts(), v1, v2, v3);
    }

    public static class TestdataAbstractSolutionBasedSolution
    extends AbstractSolution<SimpleScore> {
        private TestdataValue singleValue;
        private List<TestdataValue> valueList;
        private List<TestdataEntity> entityList;
        private TestdataEntity singleEntity;

        public static SolutionDescriptor buildSolutionDescriptor() {
            return SolutionDescriptor.buildSolutionDescriptor(TestdataAbstractSolutionBasedSolution.class, (Class[])new Class[]{TestdataEntity.class});
        }

        public TestdataValue getSingleValue() {
            return this.singleValue;
        }

        public void setSingleValue(TestdataValue singleValue) {
            this.singleValue = singleValue;
        }

        @ValueRangeProvider(id="valueRange")
        public List<TestdataValue> getValueList() {
            return this.valueList;
        }

        public void setValueList(List<TestdataValue> valueList) {
            this.valueList = valueList;
        }

        @PlanningEntityCollectionProperty
        public List<TestdataEntity> getEntityList() {
            return this.entityList;
        }

        public void setEntityList(List<TestdataEntity> entityList) {
            this.entityList = entityList;
        }

        @PlanningEntityProperty
        public TestdataEntity getSingleEntity() {
            return this.singleEntity;
        }

        public void setSingleEntity(TestdataEntity singleEntity) {
            this.singleEntity = singleEntity;
        }
    }
}

