/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.valuerange.buildin.biginteger;

import java.math.BigInteger;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.optaplanner.core.impl.domain.valuerange.buildin.biginteger.BigIntegerValueRange;
import org.optaplanner.core.impl.testdata.util.PlannerAssert;

public class BigIntegerValueRangeTest {
    @Test
    public void getSize() {
        Assert.assertEquals((long)10L, (long)new BigIntegerValueRange(new BigInteger("0"), new BigInteger("10")).getSize());
        Assert.assertEquals((long)20L, (long)new BigIntegerValueRange(new BigInteger("100"), new BigInteger("120")).getSize());
        Assert.assertEquals((long)40L, (long)new BigIntegerValueRange(new BigInteger("-15"), new BigInteger("25")).getSize());
        Assert.assertEquals((long)0L, (long)new BigIntegerValueRange(new BigInteger("7"), new BigInteger("7")).getSize());
        Assert.assertEquals((long)5L, (long)new BigIntegerValueRange(new BigInteger("0"), new BigInteger("10"), new BigInteger("2")).getSize());
        Assert.assertEquals((long)5L, (long)new BigIntegerValueRange(new BigInteger("-1"), new BigInteger("9"), new BigInteger("2")).getSize());
        Assert.assertEquals((long)4L, (long)new BigIntegerValueRange(new BigInteger("100"), new BigInteger("120"), new BigInteger("5")).getSize());
    }

    @Test
    public void get() {
        Assert.assertEquals((Object)new BigInteger("3"), (Object)new BigIntegerValueRange(new BigInteger("0"), new BigInteger("10")).get(3L));
        Assert.assertEquals((Object)new BigInteger("103"), (Object)new BigIntegerValueRange(new BigInteger("100"), new BigInteger("120")).get(3L));
        Assert.assertEquals((Object)new BigInteger("-4"), (Object)new BigIntegerValueRange(new BigInteger("-5"), new BigInteger("25")).get(1L));
        Assert.assertEquals((Object)new BigInteger("1"), (Object)new BigIntegerValueRange(new BigInteger("-5"), new BigInteger("25")).get(6L));
        Assert.assertEquals((Object)new BigInteger("6"), (Object)new BigIntegerValueRange(new BigInteger("0"), new BigInteger("10"), new BigInteger("2")).get(3L));
        Assert.assertEquals((Object)new BigInteger("5"), (Object)new BigIntegerValueRange(new BigInteger("-1"), new BigInteger("9"), new BigInteger("2")).get(3L));
        Assert.assertEquals((Object)new BigInteger("115"), (Object)new BigIntegerValueRange(new BigInteger("100"), new BigInteger("120"), new BigInteger("5")).get(3L));
    }

    @Test
    public void contains() {
        Assert.assertEquals((Object)true, (Object)new BigIntegerValueRange(new BigInteger("0"), new BigInteger("10")).contains(new BigInteger("3")));
        Assert.assertEquals((Object)false, (Object)new BigIntegerValueRange(new BigInteger("0"), new BigInteger("10")).contains(new BigInteger("10")));
        Assert.assertEquals((Object)false, (Object)new BigIntegerValueRange(new BigInteger("0"), new BigInteger("10")).contains(null));
        Assert.assertEquals((Object)true, (Object)new BigIntegerValueRange(new BigInteger("100"), new BigInteger("120")).contains(new BigInteger("100")));
        Assert.assertEquals((Object)false, (Object)new BigIntegerValueRange(new BigInteger("100"), new BigInteger("120")).contains(new BigInteger("99")));
        Assert.assertEquals((Object)true, (Object)new BigIntegerValueRange(new BigInteger("-5"), new BigInteger("25")).contains(new BigInteger("-4")));
        Assert.assertEquals((Object)false, (Object)new BigIntegerValueRange(new BigInteger("-5"), new BigInteger("25")).contains(new BigInteger("-20")));
        Assert.assertEquals((Object)true, (Object)new BigIntegerValueRange(new BigInteger("0"), new BigInteger("10"), new BigInteger("2")).contains(new BigInteger("2")));
        Assert.assertEquals((Object)false, (Object)new BigIntegerValueRange(new BigInteger("0"), new BigInteger("10"), new BigInteger("2")).contains(new BigInteger("3")));
        Assert.assertEquals((Object)true, (Object)new BigIntegerValueRange(new BigInteger("-1"), new BigInteger("9"), new BigInteger("2")).contains(new BigInteger("1")));
        Assert.assertEquals((Object)false, (Object)new BigIntegerValueRange(new BigInteger("-1"), new BigInteger("9"), new BigInteger("2")).contains(new BigInteger("2")));
        Assert.assertEquals((Object)true, (Object)new BigIntegerValueRange(new BigInteger("100"), new BigInteger("120"), new BigInteger("5")).contains(new BigInteger("115")));
        Assert.assertEquals((Object)false, (Object)new BigIntegerValueRange(new BigInteger("100"), new BigInteger("120"), new BigInteger("5")).contains(new BigInteger("114")));
    }

    @Test
    public void createOriginalIterator() {
        PlannerAssert.assertAllElementsOfIterator(new BigIntegerValueRange(new BigInteger("0"), new BigInteger("4")).createOriginalIterator(), new BigInteger("0"), new BigInteger("1"), new BigInteger("2"), new BigInteger("3"));
        PlannerAssert.assertAllElementsOfIterator(new BigIntegerValueRange(new BigInteger("100"), new BigInteger("104")).createOriginalIterator(), new BigInteger("100"), new BigInteger("101"), new BigInteger("102"), new BigInteger("103"));
        PlannerAssert.assertAllElementsOfIterator(new BigIntegerValueRange(new BigInteger("-4"), new BigInteger("3")).createOriginalIterator(), new BigInteger("-4"), new BigInteger("-3"), new BigInteger("-2"), new BigInteger("-1"), new BigInteger("0"), new BigInteger("1"), new BigInteger("2"));
        PlannerAssert.assertAllElementsOfIterator(new BigIntegerValueRange(new BigInteger("7"), new BigInteger("7")).createOriginalIterator(), new BigInteger[0]);
        PlannerAssert.assertAllElementsOfIterator(new BigIntegerValueRange(new BigInteger("0"), new BigInteger("10"), new BigInteger("2")).createOriginalIterator(), new BigInteger("0"), new BigInteger("2"), new BigInteger("4"), new BigInteger("6"), new BigInteger("8"));
        PlannerAssert.assertAllElementsOfIterator(new BigIntegerValueRange(new BigInteger("-1"), new BigInteger("9"), new BigInteger("2")).createOriginalIterator(), new BigInteger("-1"), new BigInteger("1"), new BigInteger("3"), new BigInteger("5"), new BigInteger("7"));
        PlannerAssert.assertAllElementsOfIterator(new BigIntegerValueRange(new BigInteger("100"), new BigInteger("120"), new BigInteger("5")).createOriginalIterator(), new BigInteger("100"), new BigInteger("105"), new BigInteger("110"), new BigInteger("115"));
    }

    @Test
    public void createRandomIterator() {
        Random workingRandom = (Random)Mockito.mock(Random.class);
        Mockito.when((Object)workingRandom.nextInt(Matchers.anyInt())).thenReturn((Object)3, (Object[])new Integer[]{0});
        PlannerAssert.assertElementsOfIterator(new BigIntegerValueRange(new BigInteger("0"), new BigInteger("7")).createRandomIterator(workingRandom), new BigInteger("3"), new BigInteger("0"));
        Mockito.when((Object)workingRandom.nextInt(Matchers.anyInt())).thenReturn((Object)3, (Object[])new Integer[]{0});
        PlannerAssert.assertElementsOfIterator(new BigIntegerValueRange(new BigInteger("100"), new BigInteger("104")).createRandomIterator(workingRandom), new BigInteger("103"), new BigInteger("100"));
        Mockito.when((Object)workingRandom.nextInt(Matchers.anyInt())).thenReturn((Object)3, (Object[])new Integer[]{0});
        PlannerAssert.assertElementsOfIterator(new BigIntegerValueRange(new BigInteger("-4"), new BigInteger("3")).createRandomIterator(workingRandom), new BigInteger("-1"), new BigInteger("-4"));
        PlannerAssert.assertAllElementsOfIterator(new BigIntegerValueRange(new BigInteger("7"), new BigInteger("7")).createRandomIterator(workingRandom), new BigInteger[0]);
        Mockito.when((Object)workingRandom.nextInt(Matchers.anyInt())).thenReturn((Object)3, (Object[])new Integer[]{0});
        PlannerAssert.assertElementsOfIterator(new BigIntegerValueRange(new BigInteger("0"), new BigInteger("10"), new BigInteger("2")).createRandomIterator(workingRandom), new BigInteger("6"), new BigInteger("0"));
        Mockito.when((Object)workingRandom.nextInt(Matchers.anyInt())).thenReturn((Object)3, (Object[])new Integer[]{0});
        PlannerAssert.assertElementsOfIterator(new BigIntegerValueRange(new BigInteger("-1"), new BigInteger("9"), new BigInteger("2")).createRandomIterator(workingRandom), new BigInteger("5"), new BigInteger("-1"));
        Mockito.when((Object)workingRandom.nextInt(Matchers.anyInt())).thenReturn((Object)3, (Object[])new Integer[]{0});
        PlannerAssert.assertElementsOfIterator(new BigIntegerValueRange(new BigInteger("100"), new BigInteger("120"), new BigInteger("5")).createRandomIterator(workingRandom), new BigInteger("115"), new BigInteger("100"));
    }
}

