/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.variable.custom;

import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.optaplanner.core.api.domain.solution.Solution;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.VariableDescriptor;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;
import org.optaplanner.core.impl.testdata.domain.TestdataValue;
import org.optaplanner.core.impl.testdata.domain.shadow.cyclic.TestdataCyclicShadowedSolution;
import org.optaplanner.core.impl.testdata.domain.shadow.cyclic.reference.TestdataCyclicReferencedShadowedSolution;
import org.optaplanner.core.impl.testdata.domain.shadow.cyclic.seven.TestdataSevenNonCyclicShadowedSolution;
import org.optaplanner.core.impl.testdata.domain.shadow.extended.TestdataExtendedShadowedChildEntity;
import org.optaplanner.core.impl.testdata.domain.shadow.extended.TestdataExtendedShadowedParentEntity;
import org.optaplanner.core.impl.testdata.domain.shadow.extended.TestdataExtendedShadowedSolution;
import org.optaplanner.core.impl.testdata.domain.shadow.manytomany.TestdataManyToManyShadowedEntity;
import org.optaplanner.core.impl.testdata.domain.shadow.manytomany.TestdataManyToManyShadowedSolution;
import org.optaplanner.core.impl.testdata.util.PlannerTestUtils;

public class CustomVariableListenerTest {
    @Test(expected=IllegalStateException.class)
    public void cyclic() {
        SolutionDescriptor solutionDescriptor = TestdataCyclicShadowedSolution.buildSolutionDescriptor();
    }

    @Test(expected=IllegalStateException.class)
    public void cyclicReferenced() {
        SolutionDescriptor solutionDescriptor = TestdataCyclicReferencedShadowedSolution.buildSolutionDescriptor();
    }

    @Test
    public void nonCyclicWithSevenDisorderedShadows() {
        SolutionDescriptor solutionDescriptor = TestdataSevenNonCyclicShadowedSolution.buildSolutionDescriptor();
    }

    @Test
    public void extendedZigZag() {
        GenuineVariableDescriptor variableDescriptor = TestdataExtendedShadowedParentEntity.buildVariableDescriptorForValue();
        InnerScoreDirector scoreDirector = PlannerTestUtils.mockScoreDirector(variableDescriptor.getEntityDescriptor().getSolutionDescriptor());
        TestdataValue val1 = new TestdataValue("1");
        TestdataValue val2 = new TestdataValue("2");
        TestdataValue val3 = new TestdataValue("3");
        TestdataExtendedShadowedParentEntity a = new TestdataExtendedShadowedParentEntity("a", null);
        TestdataExtendedShadowedParentEntity b = new TestdataExtendedShadowedParentEntity("b", null);
        TestdataExtendedShadowedChildEntity c = new TestdataExtendedShadowedChildEntity("c", null);
        TestdataExtendedShadowedSolution solution = new TestdataExtendedShadowedSolution("solution");
        solution.setEntityList(Arrays.asList(a, b, c));
        solution.setValueList(Arrays.asList(val1, val2, val3));
        scoreDirector.setWorkingSolution((Solution)solution);
        scoreDirector.beforeVariableChanged((VariableDescriptor)variableDescriptor, (Object)a);
        a.setValue(val1);
        scoreDirector.afterVariableChanged((VariableDescriptor)variableDescriptor, (Object)a);
        scoreDirector.triggerVariableListeners();
        Assert.assertEquals((Object)"1/firstShadow", (Object)a.getFirstShadow());
        Assert.assertEquals(null, (Object)a.getThirdShadow());
        scoreDirector.beforeVariableChanged((VariableDescriptor)variableDescriptor, (Object)a);
        a.setValue(val3);
        scoreDirector.afterVariableChanged((VariableDescriptor)variableDescriptor, (Object)a);
        scoreDirector.triggerVariableListeners();
        Assert.assertEquals((Object)"3/firstShadow", (Object)a.getFirstShadow());
        Assert.assertEquals(null, (Object)a.getThirdShadow());
        scoreDirector.beforeVariableChanged((VariableDescriptor)variableDescriptor, (Object)c);
        c.setValue(val1);
        scoreDirector.afterVariableChanged((VariableDescriptor)variableDescriptor, (Object)c);
        scoreDirector.triggerVariableListeners();
        Assert.assertEquals((Object)"1/firstShadow", (Object)c.getFirstShadow());
        Assert.assertEquals((Object)"1/firstShadow/secondShadow", (Object)c.getSecondShadow());
        Assert.assertEquals((Object)"1/firstShadow/secondShadow/thirdShadow", (Object)c.getThirdShadow());
        scoreDirector.beforeVariableChanged((VariableDescriptor)variableDescriptor, (Object)c);
        c.setValue(val3);
        scoreDirector.afterVariableChanged((VariableDescriptor)variableDescriptor, (Object)c);
        scoreDirector.triggerVariableListeners();
        Assert.assertEquals((Object)"3/firstShadow", (Object)c.getFirstShadow());
        Assert.assertEquals((Object)"3/firstShadow/secondShadow", (Object)c.getSecondShadow());
        Assert.assertEquals((Object)"3/firstShadow/secondShadow/thirdShadow", (Object)c.getThirdShadow());
    }

    @Test
    public void manyToMany() {
        EntityDescriptor entityDescriptor = TestdataManyToManyShadowedEntity.buildEntityDescriptor();
        GenuineVariableDescriptor primaryVariableDescriptor = entityDescriptor.getGenuineVariableDescriptor("primaryValue");
        GenuineVariableDescriptor secondaryVariableDescriptor = entityDescriptor.getGenuineVariableDescriptor("secondaryValue");
        InnerScoreDirector scoreDirector = PlannerTestUtils.mockScoreDirector(primaryVariableDescriptor.getEntityDescriptor().getSolutionDescriptor());
        TestdataValue val1 = new TestdataValue("1");
        TestdataValue val2 = new TestdataValue("2");
        TestdataValue val3 = new TestdataValue("3");
        TestdataValue val4 = new TestdataValue("4");
        TestdataManyToManyShadowedEntity a = new TestdataManyToManyShadowedEntity("a", null, null);
        TestdataManyToManyShadowedEntity b = new TestdataManyToManyShadowedEntity("b", null, null);
        TestdataManyToManyShadowedEntity c = new TestdataManyToManyShadowedEntity("c", null, null);
        TestdataManyToManyShadowedSolution solution = new TestdataManyToManyShadowedSolution("solution");
        solution.setEntityList(Arrays.asList(a, b, c));
        solution.setValueList(Arrays.asList(val1, val2, val3, val4));
        scoreDirector.setWorkingSolution((Solution)solution);
        scoreDirector.beforeVariableChanged((VariableDescriptor)primaryVariableDescriptor, (Object)a);
        a.setPrimaryValue(val1);
        scoreDirector.afterVariableChanged((VariableDescriptor)primaryVariableDescriptor, (Object)a);
        scoreDirector.triggerVariableListeners();
        Assert.assertEquals(null, (Object)a.getComposedCode());
        Assert.assertEquals(null, (Object)a.getReverseComposedCode());
        scoreDirector.beforeVariableChanged((VariableDescriptor)secondaryVariableDescriptor, (Object)a);
        a.setSecondaryValue(val3);
        scoreDirector.afterVariableChanged((VariableDescriptor)secondaryVariableDescriptor, (Object)a);
        scoreDirector.triggerVariableListeners();
        Assert.assertEquals((Object)"1-3", (Object)a.getComposedCode());
        Assert.assertEquals((Object)"3-1", (Object)a.getReverseComposedCode());
        scoreDirector.beforeVariableChanged((VariableDescriptor)secondaryVariableDescriptor, (Object)a);
        a.setSecondaryValue(val4);
        scoreDirector.afterVariableChanged((VariableDescriptor)secondaryVariableDescriptor, (Object)a);
        scoreDirector.triggerVariableListeners();
        Assert.assertEquals((Object)"1-4", (Object)a.getComposedCode());
        Assert.assertEquals((Object)"4-1", (Object)a.getReverseComposedCode());
        scoreDirector.beforeVariableChanged((VariableDescriptor)primaryVariableDescriptor, (Object)a);
        a.setPrimaryValue(val2);
        scoreDirector.afterVariableChanged((VariableDescriptor)primaryVariableDescriptor, (Object)a);
        scoreDirector.triggerVariableListeners();
        Assert.assertEquals((Object)"2-4", (Object)a.getComposedCode());
        Assert.assertEquals((Object)"4-2", (Object)a.getReverseComposedCode());
        scoreDirector.beforeVariableChanged((VariableDescriptor)primaryVariableDescriptor, (Object)a);
        a.setPrimaryValue(null);
        scoreDirector.afterVariableChanged((VariableDescriptor)primaryVariableDescriptor, (Object)a);
        scoreDirector.triggerVariableListeners();
        Assert.assertEquals(null, (Object)a.getComposedCode());
        Assert.assertEquals(null, (Object)a.getReverseComposedCode());
        scoreDirector.beforeVariableChanged((VariableDescriptor)primaryVariableDescriptor, (Object)c);
        c.setPrimaryValue(val1);
        scoreDirector.afterVariableChanged((VariableDescriptor)primaryVariableDescriptor, (Object)c);
        scoreDirector.beforeVariableChanged((VariableDescriptor)secondaryVariableDescriptor, (Object)c);
        c.setSecondaryValue(val3);
        scoreDirector.afterVariableChanged((VariableDescriptor)secondaryVariableDescriptor, (Object)c);
        scoreDirector.triggerVariableListeners();
        Assert.assertEquals((Object)"1-3", (Object)c.getComposedCode());
        Assert.assertEquals((Object)"3-1", (Object)c.getReverseComposedCode());
    }
}

