/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.variable.listener.support;

import java.util.Collections;
import org.junit.Test;
import org.mockito.Mockito;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.VariableDescriptor;
import org.optaplanner.core.impl.domain.variable.inverserelation.ExternalizedSingletonInverseVariableSupply;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonInverseVariableDemand;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonInverseVariableListener;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonInverseVariableSupply;
import org.optaplanner.core.impl.domain.variable.listener.support.VariableListenerSupport;
import org.optaplanner.core.impl.domain.variable.supply.Demand;
import org.optaplanner.core.impl.domain.variable.supply.SupplyManager;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;
import org.optaplanner.core.impl.testdata.domain.TestdataEntity;
import org.optaplanner.core.impl.testdata.domain.TestdataSolution;
import org.optaplanner.core.impl.testdata.domain.chained.TestdataChainedEntity;
import org.optaplanner.core.impl.testdata.domain.chained.TestdataChainedSolution;
import org.optaplanner.core.impl.testdata.domain.chained.rich.TestdataRichChainedEntity;
import org.optaplanner.core.impl.testdata.domain.chained.rich.TestdataRichChainedSolution;
import org.optaplanner.core.impl.testdata.util.PlannerAssert;

public class VariableListenerSupportTest {
    @Test
    public void demandBasic() {
        SolutionDescriptor solutionDescriptor = TestdataSolution.buildSolutionDescriptor();
        InnerScoreDirector scoreDirector = (InnerScoreDirector)Mockito.mock(InnerScoreDirector.class);
        Mockito.when((Object)scoreDirector.getSolutionDescriptor()).thenReturn((Object)solutionDescriptor);
        TestdataSolution solution = new TestdataSolution();
        solution.setEntityList(Collections.<TestdataEntity>emptyList());
        Mockito.when((Object)scoreDirector.getWorkingSolution()).thenReturn((Object)solution);
        Mockito.when((Object)scoreDirector.getSupplyManager()).thenReturn(Mockito.mock(SupplyManager.class));
        VariableListenerSupport variableListenerSupport = new VariableListenerSupport(scoreDirector);
        variableListenerSupport.linkVariableListeners();
        VariableDescriptor variableDescriptor = solutionDescriptor.getEntityDescriptorStrict(TestdataEntity.class).getVariableDescriptor("value");
        SingletonInverseVariableSupply supply1 = (SingletonInverseVariableSupply)variableListenerSupport.demand((Demand)new SingletonInverseVariableDemand(variableDescriptor));
        SingletonInverseVariableSupply supply2 = (SingletonInverseVariableSupply)variableListenerSupport.demand((Demand)new SingletonInverseVariableDemand(variableDescriptor));
        PlannerAssert.assertSame((Object)supply1, (Object)supply2);
    }

    @Test
    public void demandChained() {
        SolutionDescriptor solutionDescriptor = TestdataChainedSolution.buildSolutionDescriptor();
        InnerScoreDirector scoreDirector = (InnerScoreDirector)Mockito.mock(InnerScoreDirector.class);
        Mockito.when((Object)scoreDirector.getSolutionDescriptor()).thenReturn((Object)solutionDescriptor);
        TestdataChainedSolution solution = new TestdataChainedSolution();
        solution.setChainedEntityList(Collections.<TestdataChainedEntity>emptyList());
        Mockito.when((Object)scoreDirector.getWorkingSolution()).thenReturn((Object)solution);
        Mockito.when((Object)scoreDirector.getSupplyManager()).thenReturn(Mockito.mock(SupplyManager.class));
        VariableListenerSupport variableListenerSupport = new VariableListenerSupport(scoreDirector);
        variableListenerSupport.linkVariableListeners();
        VariableDescriptor variableDescriptor = solutionDescriptor.getEntityDescriptorStrict(TestdataChainedEntity.class).getVariableDescriptor("chainedObject");
        SingletonInverseVariableSupply supply1 = (SingletonInverseVariableSupply)variableListenerSupport.demand((Demand)new SingletonInverseVariableDemand(variableDescriptor));
        PlannerAssert.assertInstanceOf(ExternalizedSingletonInverseVariableSupply.class, supply1);
        SingletonInverseVariableSupply supply2 = (SingletonInverseVariableSupply)variableListenerSupport.demand((Demand)new SingletonInverseVariableDemand(variableDescriptor));
        PlannerAssert.assertSame((Object)supply1, (Object)supply2);
    }

    @Test
    public void demandRichChained() {
        SolutionDescriptor solutionDescriptor = TestdataRichChainedSolution.buildSolutionDescriptor();
        InnerScoreDirector scoreDirector = (InnerScoreDirector)Mockito.mock(InnerScoreDirector.class);
        Mockito.when((Object)scoreDirector.getSolutionDescriptor()).thenReturn((Object)solutionDescriptor);
        TestdataRichChainedSolution solution = new TestdataRichChainedSolution();
        solution.setChainedEntityList(Collections.<TestdataRichChainedEntity>emptyList());
        Mockito.when((Object)scoreDirector.getWorkingSolution()).thenReturn((Object)solution);
        Mockito.when((Object)scoreDirector.getSupplyManager()).thenReturn(Mockito.mock(SupplyManager.class));
        VariableListenerSupport variableListenerSupport = new VariableListenerSupport(scoreDirector);
        variableListenerSupport.linkVariableListeners();
        VariableDescriptor variableDescriptor = solutionDescriptor.getEntityDescriptorStrict(TestdataRichChainedEntity.class).getVariableDescriptor("chainedObject");
        SingletonInverseVariableSupply supply1 = (SingletonInverseVariableSupply)variableListenerSupport.demand((Demand)new SingletonInverseVariableDemand(variableDescriptor));
        PlannerAssert.assertInstanceOf(SingletonInverseVariableListener.class, supply1);
        SingletonInverseVariableSupply supply2 = (SingletonInverseVariableSupply)variableListenerSupport.demand((Demand)new SingletonInverseVariableDemand(variableDescriptor));
        PlannerAssert.assertSame((Object)supply1, (Object)supply2);
    }
}

