/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.junit.Assert;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.optaplanner.core.config.heuristic.selector.common.SelectionCacheType;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonInverseVariableSupply;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.heuristic.selector.entity.EntitySelector;
import org.optaplanner.core.impl.heuristic.selector.move.MoveSelector;
import org.optaplanner.core.impl.heuristic.selector.value.EntityIndependentValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.ValueSelector;
import org.optaplanner.core.impl.testdata.domain.chained.TestdataChainedEntity;
import org.optaplanner.core.impl.testdata.domain.chained.TestdataChainedObject;

public class SelectorTestUtils {
    public static SolutionDescriptor mockSolutionDescriptor() {
        SolutionDescriptor solutionDescriptor = (SolutionDescriptor)Mockito.mock(SolutionDescriptor.class);
        return solutionDescriptor;
    }

    public static EntityDescriptor mockEntityDescriptor(Class entityClass) {
        EntityDescriptor entityDescriptor = (EntityDescriptor)Mockito.mock(EntityDescriptor.class);
        Mockito.when((Object)entityDescriptor.getEntityClass()).thenReturn((Object)entityClass);
        return entityDescriptor;
    }

    public static GenuineVariableDescriptor mockVariableDescriptor(Class entityClass, String variableName) {
        EntityDescriptor entityDescriptor = SelectorTestUtils.mockEntityDescriptor(entityClass);
        return SelectorTestUtils.mockVariableDescriptor(entityDescriptor, variableName);
    }

    public static GenuineVariableDescriptor mockVariableDescriptor(EntityDescriptor entityDescriptor, String variableName) {
        GenuineVariableDescriptor variableDescriptor = (GenuineVariableDescriptor)Mockito.mock(GenuineVariableDescriptor.class);
        Mockito.when((Object)variableDescriptor.getEntityDescriptor()).thenReturn((Object)entityDescriptor);
        Mockito.when((Object)variableDescriptor.getVariableName()).thenReturn((Object)variableName);
        return variableDescriptor;
    }

    public static EntitySelector mockEntitySelector(Class entityClass, Object ... entities) {
        EntityDescriptor entityDescriptor = SelectorTestUtils.mockEntityDescriptor(entityClass);
        return SelectorTestUtils.mockEntitySelector(entityDescriptor, entities);
    }

    public static EntitySelector mockEntitySelector(EntityDescriptor entityDescriptor, Object ... entities) {
        EntitySelector entitySelector = (EntitySelector)Mockito.mock(EntitySelector.class);
        Mockito.when((Object)entitySelector.getEntityDescriptor()).thenReturn((Object)entityDescriptor);
        final List<Object> entityList = Arrays.asList(entities);
        Mockito.when((Object)entitySelector.iterator()).thenAnswer((Answer)new Answer<Iterator<Object>>(){

            public Iterator<Object> answer(InvocationOnMock invocation) throws Throwable {
                return entityList.iterator();
            }
        });
        Mockito.when((Object)entitySelector.listIterator()).thenAnswer((Answer)new Answer<ListIterator<Object>>(){

            public ListIterator<Object> answer(InvocationOnMock invocation) throws Throwable {
                return entityList.listIterator();
            }
        });
        int i = 0;
        while (i < entityList.size()) {
            final int index = i++;
            Mockito.when((Object)entitySelector.listIterator(index)).thenAnswer((Answer)new Answer<ListIterator<Object>>(){

                public ListIterator<Object> answer(InvocationOnMock invocation) throws Throwable {
                    return entityList.listIterator(index);
                }
            });
        }
        Mockito.when((Object)entitySelector.endingIterator()).thenAnswer((Answer)new Answer<Iterator<Object>>(){

            public Iterator<Object> answer(InvocationOnMock invocation) throws Throwable {
                return entityList.iterator();
            }
        });
        Mockito.when((Object)entitySelector.isCountable()).thenReturn((Object)true);
        Mockito.when((Object)entitySelector.isNeverEnding()).thenReturn((Object)false);
        Mockito.when((Object)entitySelector.getSize()).thenReturn((Object)entityList.size());
        return entitySelector;
    }

    public static ValueSelector mockValueSelector(Class entityClass, String variableName, Object ... values) {
        GenuineVariableDescriptor variableDescriptor = SelectorTestUtils.mockVariableDescriptor(entityClass, variableName);
        return SelectorTestUtils.mockValueSelector(variableDescriptor, values);
    }

    public static ValueSelector mockValueSelector(EntityDescriptor entityDescriptor, String variableName, Object ... values) {
        GenuineVariableDescriptor variableDescriptor = SelectorTestUtils.mockVariableDescriptor(entityDescriptor, variableName);
        return SelectorTestUtils.mockValueSelector(variableDescriptor, values);
    }

    public static ValueSelector mockValueSelector(GenuineVariableDescriptor variableDescriptor, Object ... values) {
        ValueSelector valueSelector = (ValueSelector)Mockito.mock(ValueSelector.class);
        Mockito.when((Object)valueSelector.getVariableDescriptor()).thenReturn((Object)variableDescriptor);
        final List<Object> valueList = Arrays.asList(values);
        Mockito.when((Object)valueSelector.iterator(Mockito.any())).thenAnswer((Answer)new Answer<Iterator<Object>>(){

            public Iterator<Object> answer(InvocationOnMock invocation) throws Throwable {
                return valueList.iterator();
            }
        });
        Mockito.when((Object)valueSelector.isCountable()).thenReturn((Object)true);
        Mockito.when((Object)valueSelector.isNeverEnding()).thenReturn((Object)false);
        Mockito.when((Object)valueSelector.getSize(Mockito.any())).thenReturn((Object)valueList.size());
        return valueSelector;
    }

    public static ValueSelector mockValueSelectorForEntity(Class entityClass, Object entity, String variableName, Object ... values) {
        return SelectorTestUtils.mockValueSelectorForEntity(entityClass, variableName, (ListMultimap<Object, Object>)ImmutableListMultimap.builder().putAll(entity, values).build());
    }

    public static ValueSelector mockValueSelectorForEntity(Class entityClass, String variableName, ListMultimap<Object, Object> entityToValues) {
        GenuineVariableDescriptor variableDescriptor = SelectorTestUtils.mockVariableDescriptor(entityClass, variableName);
        return SelectorTestUtils.mockValueSelectorForEntity(variableDescriptor, entityToValues);
    }

    public static ValueSelector mockValueSelectorForEntity(GenuineVariableDescriptor variableDescriptor, ListMultimap<Object, Object> entityToValues) {
        ValueSelector valueSelector = (ValueSelector)Mockito.mock(ValueSelector.class);
        Mockito.when((Object)valueSelector.getVariableDescriptor()).thenReturn((Object)variableDescriptor);
        for (Map.Entry entry : entityToValues.asMap().entrySet()) {
            Object entity = entry.getKey();
            final List valueList = (List)entry.getValue();
            Mockito.when((Object)valueSelector.getSize(entity)).thenAnswer((Answer)new Answer<Long>(){

                public Long answer(InvocationOnMock invocation) {
                    return valueList.size();
                }
            });
            Mockito.when((Object)valueSelector.iterator(entity)).thenAnswer((Answer)new Answer<Iterator<Object>>(){

                public Iterator<Object> answer(InvocationOnMock invocation) {
                    return valueList.iterator();
                }
            });
            Mockito.when((Object)valueSelector.getSize(entity)).thenReturn((Object)valueList.size());
        }
        Mockito.when((Object)valueSelector.isCountable()).thenReturn((Object)true);
        Mockito.when((Object)valueSelector.isNeverEnding()).thenReturn((Object)false);
        return valueSelector;
    }

    public static EntityIndependentValueSelector mockEntityIndependentValueSelector(Class entityClass, String variableName, Object ... values) {
        GenuineVariableDescriptor variableDescriptor = SelectorTestUtils.mockVariableDescriptor(entityClass, variableName);
        Mockito.when((Object)variableDescriptor.isValueRangeEntityIndependent()).thenReturn((Object)true);
        return SelectorTestUtils.mockEntityIndependentValueSelector(variableDescriptor, values);
    }

    public static EntityIndependentValueSelector mockEntityIndependentValueSelector(GenuineVariableDescriptor variableDescriptor, Object ... values) {
        EntityIndependentValueSelector valueSelector = (EntityIndependentValueSelector)Mockito.mock(EntityIndependentValueSelector.class);
        Mockito.when((Object)valueSelector.getVariableDescriptor()).thenReturn((Object)variableDescriptor);
        final List<Object> valueList = Arrays.asList(values);
        Mockito.when((Object)valueSelector.iterator(Mockito.any())).thenAnswer((Answer)new Answer<Iterator<Object>>(){

            public Iterator<Object> answer(InvocationOnMock invocation) throws Throwable {
                return valueList.iterator();
            }
        });
        Mockito.when((Object)valueSelector.endingIterator(Mockito.any())).thenAnswer((Answer)new Answer<Iterator<Object>>(){

            public Iterator<Object> answer(InvocationOnMock invocation) throws Throwable {
                return valueList.iterator();
            }
        });
        Mockito.when((Object)valueSelector.iterator()).thenAnswer((Answer)new Answer<Iterator<Object>>(){

            public Iterator<Object> answer(InvocationOnMock invocation) throws Throwable {
                return valueList.iterator();
            }
        });
        Mockito.when((Object)valueSelector.isCountable()).thenReturn((Object)true);
        Mockito.when((Object)valueSelector.isNeverEnding()).thenReturn((Object)false);
        Mockito.when((Object)valueSelector.getSize(Mockito.any())).thenReturn((Object)valueList.size());
        Mockito.when((Object)valueSelector.getSize()).thenReturn((Object)valueList.size());
        return valueSelector;
    }

    public static MoveSelector mockMoveSelector(Class moveClass, Move ... moves) {
        MoveSelector moveSelector = (MoveSelector)Mockito.mock(MoveSelector.class);
        final List<Move> moveList = Arrays.asList(moves);
        Mockito.when((Object)moveSelector.iterator()).thenAnswer((Answer)new Answer<Iterator<Move>>(){

            public Iterator<Move> answer(InvocationOnMock invocation) throws Throwable {
                return moveList.iterator();
            }
        });
        Mockito.when((Object)moveSelector.isCountable()).thenReturn((Object)true);
        Mockito.when((Object)moveSelector.isNeverEnding()).thenReturn((Object)false);
        Mockito.when((Object)moveSelector.getCacheType()).thenReturn((Object)SelectionCacheType.JUST_IN_TIME);
        Mockito.when((Object)moveSelector.getSize()).thenReturn((Object)moveList.size());
        return moveSelector;
    }

    public static SingletonInverseVariableSupply mockSingletonInverseVariableSupply(final TestdataChainedEntity[] allEntities) {
        return new SingletonInverseVariableSupply(){

            public Object getInverseSingleton(Object planningValue) {
                for (TestdataChainedEntity entity : allEntities) {
                    if (!entity.getChainedObject().equals(planningValue)) continue;
                    return entity;
                }
                return null;
            }
        };
    }

    public static void assertChain(TestdataChainedObject ... chainedObjects) {
        TestdataChainedObject chainedObject = chainedObjects[0];
        for (int i = 1; i < chainedObjects.length; ++i) {
            TestdataChainedEntity chainedEntity = (TestdataChainedEntity)chainedObjects[i];
            if (!ObjectUtils.equals((Object)chainedObject, (Object)chainedEntity.getChainedObject())) {
                Assert.fail((String)("Chain assertion failed for chainedEntity (" + chainedEntity + ").\n" + "Expected: " + chainedObject + "\n" + "Actual:   " + chainedEntity.getChainedObject() + "\n" + "Expected chain: " + Arrays.toString(chainedObjects) + "\n" + "Actual chain:   " + Arrays.toString(ArrayUtils.subarray((Object[])chainedObjects, (int)0, (int)i)) + " ... [" + chainedEntity.getChainedObject() + ", " + chainedEntity + "] ..."));
            }
            chainedObject = chainedEntity;
        }
    }

    private SelectorTestUtils() {
    }
}

