/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.common.decorator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.optaplanner.core.config.heuristic.selector.common.decorator.SelectionSorterOrder;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.ComparatorSelectionSorter;

public class ComparatorSelectionSorterTest {
    @Test
    public void sort() {
        Integer[] baseArray = new Integer[]{3, 4, 3, 5, 1};
        ArrayList<Integer> arrayToSort = new ArrayList<Integer>();
        Collections.addAll(arrayToSort, baseArray);
        ComparatorSelectionSorter selectionSorter = new ComparatorSelectionSorter((Comparator)new TestComparator(), SelectionSorterOrder.ASCENDING);
        selectionSorter.sort(null, arrayToSort);
        Assert.assertTrue((boolean)this.ascendingSort(arrayToSort));
        arrayToSort = new ArrayList();
        Collections.addAll(arrayToSort, baseArray);
        selectionSorter = new ComparatorSelectionSorter((Comparator)new TestComparator(), SelectionSorterOrder.DESCENDING);
        selectionSorter.sort(null, arrayToSort);
        Assert.assertTrue((boolean)this.descendingSort(arrayToSort));
    }

    private boolean ascendingSort(List<Integer> list) {
        Integer tmp = list.get(0);
        for (Integer aList : list) {
            if (tmp <= aList) {
                tmp = aList;
                continue;
            }
            return false;
        }
        return true;
    }

    private boolean descendingSort(List<Integer> list) {
        Integer tmp = list.get(0);
        for (Integer aList : list) {
            if (tmp >= aList) {
                tmp = aList;
                continue;
            }
            return false;
        }
        return true;
    }

    private class TestComparator
    implements Comparator<Integer> {
        private TestComparator() {
        }

        @Override
        public int compare(Integer a, Integer b) {
            return a.compareTo(b);
        }
    }
}

