/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.common.nearby;

import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.NearbyDistanceMatrix;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.NearbyDistanceMeter;
import org.optaplanner.core.impl.testdata.domain.TestdataObject;

public class NearbyDistanceMatrixTest {
    @Test
    public void addAllDestinations() {
        MatrixTestdataObject a = new MatrixTestdataObject("a", 0, new double[]{0.0, 4.0, 2.0, 6.0});
        MatrixTestdataObject b = new MatrixTestdataObject("b", 1, new double[]{4.0, 0.0, 5.0, 10.0});
        MatrixTestdataObject c = new MatrixTestdataObject("c", 2, new double[]{2.0, 5.0, 0.0, 7.0});
        MatrixTestdataObject d = new MatrixTestdataObject("d", 3, new double[]{6.0, 10.0, 7.0, 0.0});
        List<Object> entityList = Arrays.asList(a, b, c, d);
        NearbyDistanceMeter<MatrixTestdataObject, MatrixTestdataObject> meter = new NearbyDistanceMeter<MatrixTestdataObject, MatrixTestdataObject>(){

            public double getNearbyDistance(MatrixTestdataObject origin, MatrixTestdataObject destination) {
                return origin.distances[destination.index];
            }
        };
        NearbyDistanceMatrix nearbyDistanceMatrix = new NearbyDistanceMatrix((NearbyDistanceMeter)meter, 4);
        nearbyDistanceMatrix.addAllDestinations((Object)a, entityList.iterator(), 4);
        nearbyDistanceMatrix.addAllDestinations((Object)b, entityList.iterator(), 4);
        nearbyDistanceMatrix.addAllDestinations((Object)c, entityList.iterator(), 4);
        nearbyDistanceMatrix.addAllDestinations((Object)d, entityList.iterator(), 4);
        Assert.assertSame((Object)a, (Object)nearbyDistanceMatrix.getDestination((Object)a, 0));
        Assert.assertSame((Object)c, (Object)nearbyDistanceMatrix.getDestination((Object)a, 1));
        Assert.assertSame((Object)b, (Object)nearbyDistanceMatrix.getDestination((Object)a, 2));
        Assert.assertSame((Object)d, (Object)nearbyDistanceMatrix.getDestination((Object)a, 3));
        Assert.assertSame((Object)b, (Object)nearbyDistanceMatrix.getDestination((Object)b, 0));
        Assert.assertSame((Object)a, (Object)nearbyDistanceMatrix.getDestination((Object)b, 1));
        Assert.assertSame((Object)c, (Object)nearbyDistanceMatrix.getDestination((Object)b, 2));
        Assert.assertSame((Object)d, (Object)nearbyDistanceMatrix.getDestination((Object)b, 3));
        Assert.assertSame((Object)c, (Object)nearbyDistanceMatrix.getDestination((Object)c, 0));
        Assert.assertSame((Object)a, (Object)nearbyDistanceMatrix.getDestination((Object)c, 1));
        Assert.assertSame((Object)b, (Object)nearbyDistanceMatrix.getDestination((Object)c, 2));
        Assert.assertSame((Object)d, (Object)nearbyDistanceMatrix.getDestination((Object)c, 3));
        Assert.assertSame((Object)d, (Object)nearbyDistanceMatrix.getDestination((Object)d, 0));
        Assert.assertSame((Object)a, (Object)nearbyDistanceMatrix.getDestination((Object)d, 1));
        Assert.assertSame((Object)c, (Object)nearbyDistanceMatrix.getDestination((Object)d, 2));
        Assert.assertSame((Object)b, (Object)nearbyDistanceMatrix.getDestination((Object)d, 3));
    }

    @Test
    public void addAllDestinationsWithSameDistance() {
        MatrixTestdataObject a = new MatrixTestdataObject("a", 0, new double[]{0.0, 1.0, 1.0, 1.0});
        MatrixTestdataObject b = new MatrixTestdataObject("b", 1, new double[]{1.0, 0.0, 2.0, 1.0});
        MatrixTestdataObject c = new MatrixTestdataObject("c", 2, new double[]{1.0, 2.0, 0.0, 3.0});
        MatrixTestdataObject d = new MatrixTestdataObject("d", 3, new double[]{1.0, 1.0, 3.0, 0.0});
        List<Object> entityList = Arrays.asList(a, b, c, d);
        NearbyDistanceMeter<MatrixTestdataObject, MatrixTestdataObject> meter = new NearbyDistanceMeter<MatrixTestdataObject, MatrixTestdataObject>(){

            public double getNearbyDistance(MatrixTestdataObject origin, MatrixTestdataObject destination) {
                return origin.distances[destination.index];
            }
        };
        NearbyDistanceMatrix nearbyDistanceMatrix = new NearbyDistanceMatrix((NearbyDistanceMeter)meter, 4);
        nearbyDistanceMatrix.addAllDestinations((Object)a, entityList.iterator(), 4);
        nearbyDistanceMatrix.addAllDestinations((Object)b, entityList.iterator(), 4);
        nearbyDistanceMatrix.addAllDestinations((Object)c, entityList.iterator(), 4);
        nearbyDistanceMatrix.addAllDestinations((Object)d, entityList.iterator(), 4);
        Assert.assertSame((Object)a, (Object)nearbyDistanceMatrix.getDestination((Object)a, 0));
        Assert.assertSame((Object)b, (Object)nearbyDistanceMatrix.getDestination((Object)a, 1));
        Assert.assertSame((Object)c, (Object)nearbyDistanceMatrix.getDestination((Object)a, 2));
        Assert.assertSame((Object)d, (Object)nearbyDistanceMatrix.getDestination((Object)a, 3));
        Assert.assertSame((Object)b, (Object)nearbyDistanceMatrix.getDestination((Object)b, 0));
        Assert.assertSame((Object)a, (Object)nearbyDistanceMatrix.getDestination((Object)b, 1));
        Assert.assertSame((Object)d, (Object)nearbyDistanceMatrix.getDestination((Object)b, 2));
        Assert.assertSame((Object)c, (Object)nearbyDistanceMatrix.getDestination((Object)b, 3));
        Assert.assertSame((Object)c, (Object)nearbyDistanceMatrix.getDestination((Object)c, 0));
        Assert.assertSame((Object)a, (Object)nearbyDistanceMatrix.getDestination((Object)c, 1));
        Assert.assertSame((Object)b, (Object)nearbyDistanceMatrix.getDestination((Object)c, 2));
        Assert.assertSame((Object)d, (Object)nearbyDistanceMatrix.getDestination((Object)c, 3));
        Assert.assertSame((Object)d, (Object)nearbyDistanceMatrix.getDestination((Object)d, 0));
        Assert.assertSame((Object)a, (Object)nearbyDistanceMatrix.getDestination((Object)d, 1));
        Assert.assertSame((Object)b, (Object)nearbyDistanceMatrix.getDestination((Object)d, 2));
        Assert.assertSame((Object)c, (Object)nearbyDistanceMatrix.getDestination((Object)d, 3));
    }

    private static class MatrixTestdataObject
    extends TestdataObject {
        private int index;
        private double[] distances;

        public MatrixTestdataObject(String code, int index, double[] distances) {
            super(code);
            this.index = index;
            this.distances = distances;
        }
    }
}

