/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.generic;

import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.heuristic.selector.move.generic.SwapMove;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.core.impl.testdata.domain.TestdataEntity;
import org.optaplanner.core.impl.testdata.domain.TestdataValue;
import org.optaplanner.core.impl.testdata.domain.entityproviding.TestdataEntityProvidingEntity;
import org.optaplanner.core.impl.testdata.domain.multivar.TestdataMultiVarEntity;
import org.optaplanner.core.impl.testdata.domain.multivar.TestdataOtherValue;

public class SwapMoveTest {
    @Test
    public void isMoveDoableValueRangeProviderOnEntity() {
        TestdataValue v1 = new TestdataValue("1");
        TestdataValue v2 = new TestdataValue("2");
        TestdataValue v3 = new TestdataValue("3");
        TestdataValue v4 = new TestdataValue("4");
        TestdataValue v5 = new TestdataValue("5");
        TestdataEntityProvidingEntity a = new TestdataEntityProvidingEntity("a", Arrays.asList(v1, v2, v3), null);
        TestdataEntityProvidingEntity b = new TestdataEntityProvidingEntity("b", Arrays.asList(v2, v3, v4, v5), null);
        TestdataEntityProvidingEntity c = new TestdataEntityProvidingEntity("c", Arrays.asList(v4, v5), null);
        ScoreDirector scoreDirector = (ScoreDirector)Mockito.mock(ScoreDirector.class);
        EntityDescriptor entityDescriptor = TestdataEntityProvidingEntity.buildEntityDescriptor();
        SwapMove abMove = new SwapMove(entityDescriptor.getGenuineVariableDescriptorList(), (Object)a, (Object)b);
        a.setValue(v1);
        b.setValue(v2);
        Assert.assertEquals((Object)false, (Object)abMove.isMoveDoable(scoreDirector));
        a.setValue(v2);
        b.setValue(v2);
        Assert.assertEquals((Object)false, (Object)abMove.isMoveDoable(scoreDirector));
        a.setValue(v2);
        b.setValue(v3);
        Assert.assertEquals((Object)true, (Object)abMove.isMoveDoable(scoreDirector));
        a.setValue(v3);
        b.setValue(v2);
        Assert.assertEquals((Object)true, (Object)abMove.isMoveDoable(scoreDirector));
        a.setValue(v3);
        b.setValue(v3);
        Assert.assertEquals((Object)false, (Object)abMove.isMoveDoable(scoreDirector));
        a.setValue(v2);
        b.setValue(v4);
        Assert.assertEquals((Object)false, (Object)abMove.isMoveDoable(scoreDirector));
        SwapMove acMove = new SwapMove(entityDescriptor.getGenuineVariableDescriptorList(), (Object)a, (Object)c);
        a.setValue(v1);
        c.setValue(v4);
        Assert.assertEquals((Object)false, (Object)acMove.isMoveDoable(scoreDirector));
        a.setValue(v2);
        c.setValue(v5);
        Assert.assertEquals((Object)false, (Object)acMove.isMoveDoable(scoreDirector));
        SwapMove bcMove = new SwapMove(entityDescriptor.getGenuineVariableDescriptorList(), (Object)b, (Object)c);
        b.setValue(v2);
        c.setValue(v4);
        Assert.assertEquals((Object)false, (Object)bcMove.isMoveDoable(scoreDirector));
        b.setValue(v4);
        c.setValue(v5);
        Assert.assertEquals((Object)true, (Object)bcMove.isMoveDoable(scoreDirector));
        b.setValue(v5);
        c.setValue(v4);
        Assert.assertEquals((Object)true, (Object)bcMove.isMoveDoable(scoreDirector));
        b.setValue(v5);
        c.setValue(v5);
        Assert.assertEquals((Object)false, (Object)bcMove.isMoveDoable(scoreDirector));
    }

    @Test
    public void doMove() {
        TestdataValue v1 = new TestdataValue("1");
        TestdataValue v2 = new TestdataValue("2");
        TestdataValue v3 = new TestdataValue("3");
        TestdataValue v4 = new TestdataValue("4");
        TestdataEntityProvidingEntity a = new TestdataEntityProvidingEntity("a", Arrays.asList(v1, v2, v3), null);
        TestdataEntityProvidingEntity b = new TestdataEntityProvidingEntity("b", Arrays.asList(v1, v2, v3, v4), null);
        TestdataEntityProvidingEntity c = new TestdataEntityProvidingEntity("c", Arrays.asList(v2, v3, v4), null);
        ScoreDirector scoreDirector = (ScoreDirector)Mockito.mock(ScoreDirector.class);
        EntityDescriptor entityDescriptor = TestdataEntityProvidingEntity.buildEntityDescriptor();
        SwapMove abMove = new SwapMove(entityDescriptor.getGenuineVariableDescriptorList(), (Object)a, (Object)b);
        a.setValue(v1);
        b.setValue(v1);
        abMove.doMove(scoreDirector);
        Assert.assertEquals((Object)v1, (Object)a.getValue());
        Assert.assertEquals((Object)v1, (Object)b.getValue());
        a.setValue(v1);
        b.setValue(v2);
        abMove.doMove(scoreDirector);
        Assert.assertEquals((Object)v2, (Object)a.getValue());
        Assert.assertEquals((Object)v1, (Object)b.getValue());
        a.setValue(v2);
        b.setValue(v3);
        abMove.doMove(scoreDirector);
        Assert.assertEquals((Object)v3, (Object)a.getValue());
        Assert.assertEquals((Object)v2, (Object)b.getValue());
        abMove.doMove(scoreDirector);
        Assert.assertEquals((Object)v2, (Object)a.getValue());
        Assert.assertEquals((Object)v3, (Object)b.getValue());
        SwapMove acMove = new SwapMove(entityDescriptor.getGenuineVariableDescriptorList(), (Object)a, (Object)c);
        a.setValue(v2);
        c.setValue(v2);
        acMove.doMove(scoreDirector);
        Assert.assertEquals((Object)v2, (Object)a.getValue());
        Assert.assertEquals((Object)v2, (Object)c.getValue());
        a.setValue(v3);
        c.setValue(v2);
        acMove.doMove(scoreDirector);
        Assert.assertEquals((Object)v2, (Object)a.getValue());
        Assert.assertEquals((Object)v3, (Object)c.getValue());
        a.setValue(v3);
        c.setValue(v4);
        acMove.doMove(scoreDirector);
        Assert.assertEquals((Object)v4, (Object)a.getValue());
        Assert.assertEquals((Object)v3, (Object)c.getValue());
        acMove.doMove(scoreDirector);
        Assert.assertEquals((Object)v3, (Object)a.getValue());
        Assert.assertEquals((Object)v4, (Object)c.getValue());
        SwapMove bcMove = new SwapMove(entityDescriptor.getGenuineVariableDescriptorList(), (Object)b, (Object)c);
        b.setValue(v2);
        c.setValue(v2);
        bcMove.doMove(scoreDirector);
        Assert.assertEquals((Object)v2, (Object)b.getValue());
        Assert.assertEquals((Object)v2, (Object)c.getValue());
        b.setValue(v2);
        c.setValue(v3);
        bcMove.doMove(scoreDirector);
        Assert.assertEquals((Object)v3, (Object)b.getValue());
        Assert.assertEquals((Object)v2, (Object)c.getValue());
        b.setValue(v2);
        c.setValue(v3);
        bcMove.doMove(scoreDirector);
        Assert.assertEquals((Object)v3, (Object)b.getValue());
        Assert.assertEquals((Object)v2, (Object)c.getValue());
        bcMove.doMove(scoreDirector);
        Assert.assertEquals((Object)v2, (Object)b.getValue());
        Assert.assertEquals((Object)v3, (Object)c.getValue());
    }

    @Test
    public void toStringTest() {
        TestdataValue v1 = new TestdataValue("v1");
        TestdataValue v2 = new TestdataValue("v2");
        TestdataEntity a = new TestdataEntity("a", null);
        TestdataEntity b = new TestdataEntity("b", v1);
        TestdataEntity c = new TestdataEntity("c", v2);
        EntityDescriptor entityDescriptor = TestdataEntity.buildEntityDescriptor();
        List variableDescriptorList = entityDescriptor.getGenuineVariableDescriptorList();
        Assert.assertEquals((Object)"a {null} <-> a {null}", (Object)new SwapMove(variableDescriptorList, (Object)a, (Object)a).toString());
        Assert.assertEquals((Object)"a {null} <-> b {v1}", (Object)new SwapMove(variableDescriptorList, (Object)a, (Object)b).toString());
        Assert.assertEquals((Object)"a {null} <-> c {v2}", (Object)new SwapMove(variableDescriptorList, (Object)a, (Object)c).toString());
        Assert.assertEquals((Object)"b {v1} <-> c {v2}", (Object)new SwapMove(variableDescriptorList, (Object)b, (Object)c).toString());
        Assert.assertEquals((Object)"c {v2} <-> b {v1}", (Object)new SwapMove(variableDescriptorList, (Object)c, (Object)b).toString());
    }

    @Test
    public void toStringTestMultiVar() {
        TestdataValue v1 = new TestdataValue("v1");
        TestdataValue v2 = new TestdataValue("v2");
        TestdataValue v3 = new TestdataValue("v3");
        TestdataValue v4 = new TestdataValue("v4");
        TestdataOtherValue w1 = new TestdataOtherValue("w1");
        TestdataOtherValue w2 = new TestdataOtherValue("w2");
        TestdataMultiVarEntity a = new TestdataMultiVarEntity("a", null, null, null);
        TestdataMultiVarEntity b = new TestdataMultiVarEntity("b", v1, v3, w1);
        TestdataMultiVarEntity c = new TestdataMultiVarEntity("c", v2, v4, w2);
        EntityDescriptor entityDescriptor = TestdataMultiVarEntity.buildEntityDescriptor();
        List variableDescriptorList = entityDescriptor.getGenuineVariableDescriptorList();
        Assert.assertEquals((Object)"a {null, null, null} <-> a {null, null, null}", (Object)new SwapMove(variableDescriptorList, (Object)a, (Object)a).toString());
        Assert.assertEquals((Object)"a {null, null, null} <-> b {v1, v3, w1}", (Object)new SwapMove(variableDescriptorList, (Object)a, (Object)b).toString());
        Assert.assertEquals((Object)"a {null, null, null} <-> c {v2, v4, w2}", (Object)new SwapMove(variableDescriptorList, (Object)a, (Object)c).toString());
        Assert.assertEquals((Object)"b {v1, v3, w1} <-> c {v2, v4, w2}", (Object)new SwapMove(variableDescriptorList, (Object)b, (Object)c).toString());
        Assert.assertEquals((Object)"c {v2, v4, w2} <-> b {v1, v3, w1}", (Object)new SwapMove(variableDescriptorList, (Object)c, (Object)b).toString());
    }
}

