/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.generic.chained;

import java.util.Arrays;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.optaplanner.core.api.domain.solution.Solution;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.domain.variable.anchor.AnchorVariableDemand;
import org.optaplanner.core.impl.domain.variable.anchor.AnchorVariableSupply;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.VariableDescriptor;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonInverseVariableDemand;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonInverseVariableSupply;
import org.optaplanner.core.impl.domain.variable.supply.Demand;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.heuristic.selector.SelectorTestUtils;
import org.optaplanner.core.impl.heuristic.selector.move.generic.chained.KOptMove;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.core.impl.testdata.domain.chained.TestdataChainedAnchor;
import org.optaplanner.core.impl.testdata.domain.chained.TestdataChainedEntity;
import org.optaplanner.core.impl.testdata.domain.chained.TestdataChainedSolution;
import org.optaplanner.core.impl.testdata.util.PlannerTestUtils;

public class KOptMoveTest {
    @Test
    public void doMove3OptWith3Chains() {
        GenuineVariableDescriptor variableDescriptor = TestdataChainedEntity.buildVariableDescriptorForChainedObject();
        SolutionDescriptor solutionDescriptor = variableDescriptor.getEntityDescriptor().getSolutionDescriptor();
        InnerScoreDirector scoreDirector = PlannerTestUtils.mockScoreDirector(solutionDescriptor);
        TestdataChainedAnchor a0 = new TestdataChainedAnchor("a0");
        TestdataChainedEntity a1 = new TestdataChainedEntity("a1", a0);
        TestdataChainedEntity a2 = new TestdataChainedEntity("a2", a1);
        TestdataChainedEntity a3 = new TestdataChainedEntity("a3", a2);
        TestdataChainedAnchor b0 = new TestdataChainedAnchor("b0");
        TestdataChainedEntity b1 = new TestdataChainedEntity("b1", b0);
        TestdataChainedEntity b2 = new TestdataChainedEntity("b2", b1);
        TestdataChainedAnchor c0 = new TestdataChainedAnchor("c0");
        TestdataChainedEntity c1 = new TestdataChainedEntity("c1", c0);
        TestdataChainedEntity c2 = new TestdataChainedEntity("c2", c1);
        TestdataChainedSolution solution = new TestdataChainedSolution("solution");
        solution.setChainedAnchorList(Arrays.asList(a0, b0, c0));
        solution.setChainedEntityList(Arrays.asList(a1, a2, a3, b1, b2, c1, c2));
        scoreDirector.setWorkingSolution((Solution)solution);
        SingletonInverseVariableSupply inverseVariableSupply = (SingletonInverseVariableSupply)scoreDirector.getSupplyManager().demand((Demand)new SingletonInverseVariableDemand((VariableDescriptor)variableDescriptor));
        AnchorVariableSupply anchorVariableSupply = (AnchorVariableSupply)scoreDirector.getSupplyManager().demand((Demand)new AnchorVariableDemand((VariableDescriptor)variableDescriptor));
        SelectorTestUtils.assertChain(a0, a1, a2, a3);
        SelectorTestUtils.assertChain(b0, b1, b2);
        SelectorTestUtils.assertChain(c0, c1, c2);
        KOptMove move = new KOptMove(variableDescriptor, inverseVariableSupply, anchorVariableSupply, (Object)a2, new Object[]{b0, c1});
        Assert.assertEquals((Object)true, (Object)move.isMoveDoable((ScoreDirector)scoreDirector));
        Move undoMove = move.createUndoMove((ScoreDirector)scoreDirector);
        move.doMove((ScoreDirector)scoreDirector);
        SelectorTestUtils.assertChain(a0, a1, c2);
        SelectorTestUtils.assertChain(b0, a2, a3);
        SelectorTestUtils.assertChain(c0, c1, b1, b2);
        Assert.assertEquals((Object)true, (Object)undoMove.isMoveDoable((ScoreDirector)scoreDirector));
        undoMove.doMove((ScoreDirector)scoreDirector);
        SelectorTestUtils.assertChain(a0, a1, a2, a3);
        SelectorTestUtils.assertChain(b0, b1, b2);
        SelectorTestUtils.assertChain(c0, c1, c2);
        move = new KOptMove(variableDescriptor, inverseVariableSupply, anchorVariableSupply, (Object)a2, new Object[]{b2, c2});
        Assert.assertEquals((Object)true, (Object)move.isMoveDoable((ScoreDirector)scoreDirector));
        undoMove = move.createUndoMove((ScoreDirector)scoreDirector);
        move.doMove((ScoreDirector)scoreDirector);
        SelectorTestUtils.assertChain(a0, a1);
        SelectorTestUtils.assertChain(b0, b1, b2, a2, a3);
        SelectorTestUtils.assertChain(c0, c1, c2);
        Assert.assertEquals((Object)true, (Object)undoMove.isMoveDoable((ScoreDirector)scoreDirector));
        undoMove.doMove((ScoreDirector)scoreDirector);
        SelectorTestUtils.assertChain(a0, a1, a2, a3);
        SelectorTestUtils.assertChain(b0, b1, b2);
        SelectorTestUtils.assertChain(c0, c1, c2);
    }

    @Test
    public void doMove3OptWithOnly2Chains() {
        GenuineVariableDescriptor variableDescriptor = TestdataChainedEntity.buildVariableDescriptorForChainedObject();
        SolutionDescriptor solutionDescriptor = variableDescriptor.getEntityDescriptor().getSolutionDescriptor();
        InnerScoreDirector scoreDirector = PlannerTestUtils.mockScoreDirector(solutionDescriptor);
        TestdataChainedAnchor a0 = new TestdataChainedAnchor("a0");
        TestdataChainedEntity a1 = new TestdataChainedEntity("a1", a0);
        TestdataChainedEntity a2 = new TestdataChainedEntity("a2", a1);
        TestdataChainedEntity a3 = new TestdataChainedEntity("a3", a2);
        TestdataChainedEntity a4 = new TestdataChainedEntity("a4", a3);
        TestdataChainedAnchor b0 = new TestdataChainedAnchor("b0");
        TestdataChainedEntity b1 = new TestdataChainedEntity("b1", b0);
        TestdataChainedEntity b2 = new TestdataChainedEntity("b2", b1);
        TestdataChainedEntity b3 = new TestdataChainedEntity("b3", b2);
        TestdataChainedSolution solution = new TestdataChainedSolution("solution");
        solution.setChainedAnchorList(Arrays.asList(a0, b0));
        solution.setChainedEntityList(Arrays.asList(a1, a2, a3, a4, b1, b2, b3));
        scoreDirector.setWorkingSolution((Solution)solution);
        SingletonInverseVariableSupply inverseVariableSupply = (SingletonInverseVariableSupply)scoreDirector.getSupplyManager().demand((Demand)new SingletonInverseVariableDemand((VariableDescriptor)variableDescriptor));
        AnchorVariableSupply anchorVariableSupply = (AnchorVariableSupply)scoreDirector.getSupplyManager().demand((Demand)new AnchorVariableDemand((VariableDescriptor)variableDescriptor));
        SelectorTestUtils.assertChain(a0, a1, a2, a3, a4);
        SelectorTestUtils.assertChain(b0, b1, b2, b3);
        KOptMove move = new KOptMove(variableDescriptor, inverseVariableSupply, anchorVariableSupply, (Object)a4, new Object[]{a1, b2});
        Assert.assertEquals((Object)true, (Object)move.isMoveDoable((ScoreDirector)scoreDirector));
        Move undoMove = move.createUndoMove((ScoreDirector)scoreDirector);
        move.doMove((ScoreDirector)scoreDirector);
        SelectorTestUtils.assertChain(a0, a1, a4);
        SelectorTestUtils.assertChain(b0, b1, b2, a2, a3, b3);
        Assert.assertEquals((Object)true, (Object)undoMove.isMoveDoable((ScoreDirector)scoreDirector));
        undoMove.doMove((ScoreDirector)scoreDirector);
        SelectorTestUtils.assertChain(a0, a1, a2, a3, a4);
        SelectorTestUtils.assertChain(b0, b1, b2, b3);
        move = new KOptMove(variableDescriptor, inverseVariableSupply, anchorVariableSupply, (Object)a2, new Object[]{b2, a3});
        Assert.assertEquals((Object)true, (Object)move.isMoveDoable((ScoreDirector)scoreDirector));
        undoMove = move.createUndoMove((ScoreDirector)scoreDirector);
        move.doMove((ScoreDirector)scoreDirector);
        SelectorTestUtils.assertChain(a0, a1, a4);
        SelectorTestUtils.assertChain(b0, b1, b2, a2, a3, b3);
        Assert.assertEquals((Object)true, (Object)undoMove.isMoveDoable((ScoreDirector)scoreDirector));
        undoMove.doMove((ScoreDirector)scoreDirector);
        SelectorTestUtils.assertChain(a0, a1, a2, a3, a4);
        SelectorTestUtils.assertChain(b0, b1, b2, b3);
        move = new KOptMove(variableDescriptor, inverseVariableSupply, anchorVariableSupply, (Object)b3, new Object[]{a3, a1});
        Assert.assertEquals((Object)true, (Object)move.isMoveDoable((ScoreDirector)scoreDirector));
        undoMove = move.createUndoMove((ScoreDirector)scoreDirector);
        move.doMove((ScoreDirector)scoreDirector);
        SelectorTestUtils.assertChain(a0, a1, a4);
        SelectorTestUtils.assertChain(b0, b1, b2, a2, a3, b3);
        Assert.assertEquals((Object)true, (Object)undoMove.isMoveDoable((ScoreDirector)scoreDirector));
        undoMove.doMove((ScoreDirector)scoreDirector);
        SelectorTestUtils.assertChain(a0, a1, a2, a3, a4);
        SelectorTestUtils.assertChain(b0, b1, b2, b3);
        move = new KOptMove(variableDescriptor, inverseVariableSupply, anchorVariableSupply, (Object)a2, new Object[]{a3, b2});
        Assert.assertEquals((Object)false, (Object)move.isMoveDoable((ScoreDirector)scoreDirector));
        move = new KOptMove(variableDescriptor, inverseVariableSupply, anchorVariableSupply, (Object)a4, new Object[]{b2, a1});
        Assert.assertEquals((Object)false, (Object)move.isMoveDoable((ScoreDirector)scoreDirector));
        move = new KOptMove(variableDescriptor, inverseVariableSupply, anchorVariableSupply, (Object)b3, new Object[]{a1, a3});
        Assert.assertEquals((Object)false, (Object)move.isMoveDoable((ScoreDirector)scoreDirector));
    }

    @Test
    @Ignore(value="Valid 1 chain moves aren't supported yet")
    public void doMove3OptWithOnly1Chain() {
        GenuineVariableDescriptor variableDescriptor = TestdataChainedEntity.buildVariableDescriptorForChainedObject();
        SolutionDescriptor solutionDescriptor = variableDescriptor.getEntityDescriptor().getSolutionDescriptor();
        InnerScoreDirector scoreDirector = PlannerTestUtils.mockScoreDirector(solutionDescriptor);
        TestdataChainedAnchor a0 = new TestdataChainedAnchor("a0");
        TestdataChainedEntity a1 = new TestdataChainedEntity("a1", a0);
        TestdataChainedEntity a2 = new TestdataChainedEntity("a2", a1);
        TestdataChainedEntity a3 = new TestdataChainedEntity("a3", a2);
        TestdataChainedEntity a4 = new TestdataChainedEntity("a4", a3);
        TestdataChainedEntity a5 = new TestdataChainedEntity("a5", a4);
        TestdataChainedEntity a6 = new TestdataChainedEntity("a6", a5);
        TestdataChainedSolution solution = new TestdataChainedSolution("solution");
        solution.setChainedAnchorList(Arrays.asList(a0));
        solution.setChainedEntityList(Arrays.asList(a1, a2, a3, a4, a5, a6));
        scoreDirector.setWorkingSolution((Solution)solution);
        SingletonInverseVariableSupply inverseVariableSupply = (SingletonInverseVariableSupply)scoreDirector.getSupplyManager().demand((Demand)new SingletonInverseVariableDemand((VariableDescriptor)variableDescriptor));
        AnchorVariableSupply anchorVariableSupply = (AnchorVariableSupply)scoreDirector.getSupplyManager().demand((Demand)new AnchorVariableDemand((VariableDescriptor)variableDescriptor));
        SelectorTestUtils.assertChain(a0, a1, a2, a3, a4, a5, a6);
        KOptMove move = new KOptMove(variableDescriptor, inverseVariableSupply, anchorVariableSupply, (Object)a6, new Object[]{a3, a1});
        Assert.assertEquals((Object)true, (Object)move.isMoveDoable((ScoreDirector)scoreDirector));
        Move undoMove = move.createUndoMove((ScoreDirector)scoreDirector);
        move.doMove((ScoreDirector)scoreDirector);
        SelectorTestUtils.assertChain(a0, a1, a4, a5, a2, a3, a6);
        Assert.assertEquals((Object)true, (Object)undoMove.isMoveDoable((ScoreDirector)scoreDirector));
        undoMove.doMove((ScoreDirector)scoreDirector);
        SelectorTestUtils.assertChain(a0, a1, a2, a3, a4, a5, a6);
        move = new KOptMove(variableDescriptor, inverseVariableSupply, anchorVariableSupply, (Object)a4, new Object[]{a1, a5});
        Assert.assertEquals((Object)true, (Object)move.isMoveDoable((ScoreDirector)scoreDirector));
        undoMove = move.createUndoMove((ScoreDirector)scoreDirector);
        move.doMove((ScoreDirector)scoreDirector);
        SelectorTestUtils.assertChain(a0, a1, a4, a5, a2, a3, a6);
        Assert.assertEquals((Object)true, (Object)undoMove.isMoveDoable((ScoreDirector)scoreDirector));
        undoMove.doMove((ScoreDirector)scoreDirector);
        SelectorTestUtils.assertChain(a0, a1, a2, a3, a4, a5, a6);
        move = new KOptMove(variableDescriptor, inverseVariableSupply, anchorVariableSupply, (Object)a2, new Object[]{a5, a3});
        Assert.assertEquals((Object)true, (Object)move.isMoveDoable((ScoreDirector)scoreDirector));
        undoMove = move.createUndoMove((ScoreDirector)scoreDirector);
        move.doMove((ScoreDirector)scoreDirector);
        SelectorTestUtils.assertChain(a0, a1, a4, a5, a2, a3, a6);
        Assert.assertEquals((Object)true, (Object)undoMove.isMoveDoable((ScoreDirector)scoreDirector));
        undoMove.doMove((ScoreDirector)scoreDirector);
        SelectorTestUtils.assertChain(a0, a1, a2, a3, a4, a5, a6);
    }

    @Test
    public void toStringTest() {
        GenuineVariableDescriptor variableDescriptor = TestdataChainedEntity.buildVariableDescriptorForChainedObject();
        SolutionDescriptor solutionDescriptor = variableDescriptor.getEntityDescriptor().getSolutionDescriptor();
        InnerScoreDirector scoreDirector = PlannerTestUtils.mockScoreDirector(solutionDescriptor);
        TestdataChainedAnchor a0 = new TestdataChainedAnchor("a0");
        TestdataChainedEntity a1 = new TestdataChainedEntity("a1", a0);
        TestdataChainedEntity a2 = new TestdataChainedEntity("a2", a1);
        TestdataChainedEntity a3 = new TestdataChainedEntity("a3", a2);
        TestdataChainedAnchor b0 = new TestdataChainedAnchor("b0");
        TestdataChainedEntity b1 = new TestdataChainedEntity("b1", b0);
        TestdataChainedEntity b2 = new TestdataChainedEntity("b2", b1);
        TestdataChainedAnchor c0 = new TestdataChainedAnchor("c0");
        TestdataChainedEntity c1 = new TestdataChainedEntity("c1", c0);
        TestdataChainedEntity c2 = new TestdataChainedEntity("c2", c1);
        TestdataChainedSolution solution = new TestdataChainedSolution("solution");
        solution.setChainedAnchorList(Arrays.asList(a0, b0, c0));
        solution.setChainedEntityList(Arrays.asList(a1, a2, a3, b1, b2, c1, c2));
        scoreDirector.setWorkingSolution((Solution)solution);
        SingletonInverseVariableSupply inverseVariableSupply = (SingletonInverseVariableSupply)scoreDirector.getSupplyManager().demand((Demand)new SingletonInverseVariableDemand((VariableDescriptor)variableDescriptor));
        AnchorVariableSupply anchorVariableSupply = (AnchorVariableSupply)scoreDirector.getSupplyManager().demand((Demand)new AnchorVariableDemand((VariableDescriptor)variableDescriptor));
        Assert.assertEquals((Object)"a2 {a1} -kOpt-> b1 {b0} -kOpt-> c2 {c1}", (Object)new KOptMove(variableDescriptor, inverseVariableSupply, anchorVariableSupply, (Object)a2, new Object[]{b0, c1}).toString());
        Assert.assertEquals((Object)"a2 {a1} -kOpt-> null {b2} -kOpt-> null {c2}", (Object)new KOptMove(variableDescriptor, inverseVariableSupply, anchorVariableSupply, (Object)a2, new Object[]{b2, c2}).toString());
    }
}

