/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.generic.chained;

import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.VariableDescriptor;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonInverseVariableSupply;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.heuristic.selector.SelectorTestUtils;
import org.optaplanner.core.impl.heuristic.selector.move.generic.chained.SubChainChangeMove;
import org.optaplanner.core.impl.heuristic.selector.value.chained.SubChain;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.core.impl.testdata.domain.chained.TestdataChainedAnchor;
import org.optaplanner.core.impl.testdata.domain.chained.TestdataChainedEntity;
import org.optaplanner.core.impl.testdata.util.PlannerTestUtils;

public class SubChainChangeMoveTest {
    @Test
    public void noTrailing() {
        GenuineVariableDescriptor variableDescriptor = TestdataChainedEntity.buildVariableDescriptorForChainedObject();
        InnerScoreDirector scoreDirector = PlannerTestUtils.mockScoreDirector(variableDescriptor.getEntityDescriptor().getSolutionDescriptor());
        TestdataChainedAnchor a0 = new TestdataChainedAnchor("a0");
        TestdataChainedEntity a1 = new TestdataChainedEntity("a1", a0);
        TestdataChainedEntity a2 = new TestdataChainedEntity("a2", a1);
        TestdataChainedEntity a3 = new TestdataChainedEntity("a3", a2);
        TestdataChainedEntity a4 = new TestdataChainedEntity("a4", a3);
        TestdataChainedEntity a5 = new TestdataChainedEntity("a5", a4);
        TestdataChainedAnchor b0 = new TestdataChainedAnchor("b0");
        TestdataChainedEntity b1 = new TestdataChainedEntity("b1", b0);
        SingletonInverseVariableSupply inverseVariableSupply = SelectorTestUtils.mockSingletonInverseVariableSupply(new TestdataChainedEntity[]{a1, a2, a3, a4, a5, b1});
        SubChainChangeMove move = new SubChainChangeMove(new SubChain(Arrays.asList(a3, a4, a5)), variableDescriptor, inverseVariableSupply, (Object)b1);
        Move undoMove = move.createUndoMove((ScoreDirector)scoreDirector);
        move.doMove((ScoreDirector)scoreDirector);
        SelectorTestUtils.assertChain(a0, a1, a2);
        SelectorTestUtils.assertChain(b0, b1, a3, a4, a5);
        ((InnerScoreDirector)Mockito.verify((Object)scoreDirector)).changeVariableFacade((VariableDescriptor)variableDescriptor, (Object)a3, (Object)b1);
        undoMove.doMove((ScoreDirector)scoreDirector);
        SelectorTestUtils.assertChain(a0, a1, a2, a3, a4, a5);
        SelectorTestUtils.assertChain(b0, b1);
    }

    @Test
    public void oldAndNewTrailing() {
        GenuineVariableDescriptor variableDescriptor = TestdataChainedEntity.buildVariableDescriptorForChainedObject();
        InnerScoreDirector scoreDirector = PlannerTestUtils.mockScoreDirector(variableDescriptor.getEntityDescriptor().getSolutionDescriptor());
        TestdataChainedAnchor a0 = new TestdataChainedAnchor("a0");
        TestdataChainedEntity a1 = new TestdataChainedEntity("a1", a0);
        TestdataChainedEntity a2 = new TestdataChainedEntity("a2", a1);
        TestdataChainedEntity a3 = new TestdataChainedEntity("a3", a2);
        TestdataChainedEntity a4 = new TestdataChainedEntity("a4", a3);
        TestdataChainedEntity a5 = new TestdataChainedEntity("a5", a4);
        TestdataChainedAnchor b0 = new TestdataChainedAnchor("b0");
        TestdataChainedEntity b1 = new TestdataChainedEntity("b1", b0);
        SingletonInverseVariableSupply inverseVariableSupply = SelectorTestUtils.mockSingletonInverseVariableSupply(new TestdataChainedEntity[]{a1, a2, a3, a4, a5, b1});
        SubChainChangeMove move = new SubChainChangeMove(new SubChain(Arrays.asList(a2, a3, a4)), variableDescriptor, inverseVariableSupply, (Object)b0);
        Move undoMove = move.createUndoMove((ScoreDirector)scoreDirector);
        move.doMove((ScoreDirector)scoreDirector);
        SelectorTestUtils.assertChain(a0, a1, a5);
        SelectorTestUtils.assertChain(b0, a2, a3, a4, b1);
        ((InnerScoreDirector)Mockito.verify((Object)scoreDirector)).changeVariableFacade((VariableDescriptor)variableDescriptor, (Object)a5, (Object)a1);
        ((InnerScoreDirector)Mockito.verify((Object)scoreDirector)).changeVariableFacade((VariableDescriptor)variableDescriptor, (Object)a2, (Object)b0);
        ((InnerScoreDirector)Mockito.verify((Object)scoreDirector)).changeVariableFacade((VariableDescriptor)variableDescriptor, (Object)b1, (Object)a4);
        undoMove.doMove((ScoreDirector)scoreDirector);
        SelectorTestUtils.assertChain(a0, a1, a2, a3, a4, a5);
        SelectorTestUtils.assertChain(b0, b1);
    }

    @Test
    public void sameChainWithOneBetween() {
        GenuineVariableDescriptor variableDescriptor = TestdataChainedEntity.buildVariableDescriptorForChainedObject();
        InnerScoreDirector scoreDirector = PlannerTestUtils.mockScoreDirector(variableDescriptor.getEntityDescriptor().getSolutionDescriptor());
        TestdataChainedAnchor a0 = new TestdataChainedAnchor("a0");
        TestdataChainedEntity a1 = new TestdataChainedEntity("a1", a0);
        TestdataChainedEntity a2 = new TestdataChainedEntity("a2", a1);
        TestdataChainedEntity a3 = new TestdataChainedEntity("a3", a2);
        TestdataChainedEntity a4 = new TestdataChainedEntity("a4", a3);
        TestdataChainedEntity a5 = new TestdataChainedEntity("a5", a4);
        SingletonInverseVariableSupply inverseVariableSupply = SelectorTestUtils.mockSingletonInverseVariableSupply(new TestdataChainedEntity[]{a1, a2, a3, a4, a5});
        SubChainChangeMove move = new SubChainChangeMove(new SubChain(Arrays.asList(a1, a2, a3)), variableDescriptor, inverseVariableSupply, (Object)a4);
        Move undoMove = move.createUndoMove((ScoreDirector)scoreDirector);
        move.doMove((ScoreDirector)scoreDirector);
        SelectorTestUtils.assertChain(a0, a4, a1, a2, a3, a5);
        ((InnerScoreDirector)Mockito.verify((Object)scoreDirector)).changeVariableFacade((VariableDescriptor)variableDescriptor, (Object)a4, (Object)a0);
        ((InnerScoreDirector)Mockito.verify((Object)scoreDirector)).changeVariableFacade((VariableDescriptor)variableDescriptor, (Object)a1, (Object)a4);
        ((InnerScoreDirector)Mockito.verify((Object)scoreDirector)).changeVariableFacade((VariableDescriptor)variableDescriptor, (Object)a5, (Object)a3);
        undoMove.doMove((ScoreDirector)scoreDirector);
        SelectorTestUtils.assertChain(a0, a1, a2, a3, a4, a5);
    }

    @Test
    public void toStringTest() {
        TestdataChainedAnchor a0 = new TestdataChainedAnchor("a0");
        TestdataChainedEntity a1 = new TestdataChainedEntity("a1", a0);
        TestdataChainedEntity a2 = new TestdataChainedEntity("a2", a1);
        TestdataChainedEntity a3 = new TestdataChainedEntity("a3", a2);
        TestdataChainedEntity a4 = new TestdataChainedEntity("a4", a3);
        TestdataChainedEntity a5 = new TestdataChainedEntity("a5", a4);
        TestdataChainedAnchor b0 = new TestdataChainedAnchor("b0");
        TestdataChainedEntity b1 = new TestdataChainedEntity("b1", b0);
        TestdataChainedEntity b2 = new TestdataChainedEntity("b2", b1);
        TestdataChainedEntity b3 = new TestdataChainedEntity("b3", b2);
        GenuineVariableDescriptor variableDescriptor = TestdataChainedEntity.buildVariableDescriptorForChainedObject();
        SingletonInverseVariableSupply inverseVariableSupply = SelectorTestUtils.mockSingletonInverseVariableSupply(new TestdataChainedEntity[]{a1, a2, a3, a4, a5, b1, b2, b3});
        Assert.assertEquals((Object)"[a2..a4] {a1 -> b0}", (Object)new SubChainChangeMove(new SubChain(Arrays.asList(a2, a3, a4)), variableDescriptor, inverseVariableSupply, (Object)b0).toString());
        Assert.assertEquals((Object)"[a1..a5] {a0 -> b3}", (Object)new SubChainChangeMove(new SubChain(Arrays.asList(a1, a2, a3, a4, a5)), variableDescriptor, inverseVariableSupply, (Object)b3).toString());
        Assert.assertEquals((Object)"[a1..a3] {a0 -> a5}", (Object)new SubChainChangeMove(new SubChain(Arrays.asList(a1, a2, a3)), variableDescriptor, inverseVariableSupply, (Object)a5).toString());
        Assert.assertEquals((Object)"[a3..a3] {a2 -> b2}", (Object)new SubChainChangeMove(new SubChain(Arrays.asList(a3)), variableDescriptor, inverseVariableSupply, (Object)b2).toString());
    }
}

