/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.generic.chained;

import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.VariableDescriptor;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonInverseVariableSupply;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.heuristic.selector.SelectorTestUtils;
import org.optaplanner.core.impl.heuristic.selector.move.generic.chained.SubChainReversingSwapMove;
import org.optaplanner.core.impl.heuristic.selector.value.chained.SubChain;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.core.impl.testdata.domain.chained.TestdataChainedAnchor;
import org.optaplanner.core.impl.testdata.domain.chained.TestdataChainedEntity;
import org.optaplanner.core.impl.testdata.util.PlannerTestUtils;

public class SubChainReversingSwapMoveTest {
    @Test
    public void noTrailing() {
        GenuineVariableDescriptor variableDescriptor = TestdataChainedEntity.buildVariableDescriptorForChainedObject();
        InnerScoreDirector scoreDirector = PlannerTestUtils.mockScoreDirector(variableDescriptor.getEntityDescriptor().getSolutionDescriptor());
        TestdataChainedAnchor a0 = new TestdataChainedAnchor("a0");
        TestdataChainedEntity a1 = new TestdataChainedEntity("a1", a0);
        TestdataChainedEntity a2 = new TestdataChainedEntity("a2", a1);
        TestdataChainedEntity a3 = new TestdataChainedEntity("a3", a2);
        TestdataChainedEntity a4 = new TestdataChainedEntity("a4", a3);
        TestdataChainedEntity a5 = new TestdataChainedEntity("a5", a4);
        TestdataChainedAnchor b0 = new TestdataChainedAnchor("b0");
        TestdataChainedEntity b1 = new TestdataChainedEntity("b1", b0);
        TestdataChainedEntity b2 = new TestdataChainedEntity("b2", b1);
        TestdataChainedEntity b3 = new TestdataChainedEntity("b3", b2);
        SingletonInverseVariableSupply inverseVariableSupply = SelectorTestUtils.mockSingletonInverseVariableSupply(new TestdataChainedEntity[]{a1, a2, a3, a4, a5, b1, b2, b3});
        SubChainReversingSwapMove move = new SubChainReversingSwapMove(variableDescriptor, inverseVariableSupply, new SubChain(Arrays.asList(a3, a4, a5)), new SubChain(Arrays.asList(b2, b3)));
        Move undoMove = move.createUndoMove((ScoreDirector)scoreDirector);
        move.doMove((ScoreDirector)scoreDirector);
        SelectorTestUtils.assertChain(a0, a1, a2, b3, b2);
        SelectorTestUtils.assertChain(b0, b1, a5, a4, a3);
        ((InnerScoreDirector)Mockito.verify((Object)scoreDirector)).changeVariableFacade((VariableDescriptor)variableDescriptor, (Object)a5, (Object)b1);
        ((InnerScoreDirector)Mockito.verify((Object)scoreDirector)).changeVariableFacade((VariableDescriptor)variableDescriptor, (Object)a4, (Object)a5);
        ((InnerScoreDirector)Mockito.verify((Object)scoreDirector)).changeVariableFacade((VariableDescriptor)variableDescriptor, (Object)a3, (Object)a4);
        ((InnerScoreDirector)Mockito.verify((Object)scoreDirector)).changeVariableFacade((VariableDescriptor)variableDescriptor, (Object)b3, (Object)a2);
        ((InnerScoreDirector)Mockito.verify((Object)scoreDirector)).changeVariableFacade((VariableDescriptor)variableDescriptor, (Object)b2, (Object)b3);
        undoMove.doMove((ScoreDirector)scoreDirector);
        SelectorTestUtils.assertChain(a0, a1, a2, a3, a4, a5);
        SelectorTestUtils.assertChain(b0, b1, b2, b3);
    }

    @Test
    public void oldAndNewTrailing() {
        GenuineVariableDescriptor variableDescriptor = TestdataChainedEntity.buildVariableDescriptorForChainedObject();
        InnerScoreDirector scoreDirector = PlannerTestUtils.mockScoreDirector(variableDescriptor.getEntityDescriptor().getSolutionDescriptor());
        TestdataChainedAnchor a0 = new TestdataChainedAnchor("a0");
        TestdataChainedEntity a1 = new TestdataChainedEntity("a1", a0);
        TestdataChainedEntity a2 = new TestdataChainedEntity("a2", a1);
        TestdataChainedEntity a3 = new TestdataChainedEntity("a3", a2);
        TestdataChainedEntity a4 = new TestdataChainedEntity("a4", a3);
        TestdataChainedEntity a5 = new TestdataChainedEntity("a5", a4);
        TestdataChainedAnchor b0 = new TestdataChainedAnchor("b0");
        TestdataChainedEntity b1 = new TestdataChainedEntity("b1", b0);
        TestdataChainedEntity b2 = new TestdataChainedEntity("b2", b1);
        TestdataChainedEntity b3 = new TestdataChainedEntity("b3", b2);
        SingletonInverseVariableSupply inverseVariableSupply = SelectorTestUtils.mockSingletonInverseVariableSupply(new TestdataChainedEntity[]{a1, a2, a3, a4, a5, b1, b2, b3});
        SubChainReversingSwapMove move = new SubChainReversingSwapMove(variableDescriptor, inverseVariableSupply, new SubChain(Arrays.asList(a2, a3, a4)), new SubChain(Arrays.asList(b1, b2)));
        Move undoMove = move.createUndoMove((ScoreDirector)scoreDirector);
        move.doMove((ScoreDirector)scoreDirector);
        SelectorTestUtils.assertChain(a0, a1, b2, b1, a5);
        SelectorTestUtils.assertChain(b0, a4, a3, a2, b3);
        ((InnerScoreDirector)Mockito.verify((Object)scoreDirector)).changeVariableFacade((VariableDescriptor)variableDescriptor, (Object)a4, (Object)b0);
        ((InnerScoreDirector)Mockito.verify((Object)scoreDirector)).changeVariableFacade((VariableDescriptor)variableDescriptor, (Object)a3, (Object)a4);
        ((InnerScoreDirector)Mockito.verify((Object)scoreDirector)).changeVariableFacade((VariableDescriptor)variableDescriptor, (Object)a2, (Object)a3);
        ((InnerScoreDirector)Mockito.verify((Object)scoreDirector)).changeVariableFacade((VariableDescriptor)variableDescriptor, (Object)b3, (Object)a2);
        ((InnerScoreDirector)Mockito.verify((Object)scoreDirector)).changeVariableFacade((VariableDescriptor)variableDescriptor, (Object)b2, (Object)a1);
        ((InnerScoreDirector)Mockito.verify((Object)scoreDirector)).changeVariableFacade((VariableDescriptor)variableDescriptor, (Object)b1, (Object)b2);
        ((InnerScoreDirector)Mockito.verify((Object)scoreDirector)).changeVariableFacade((VariableDescriptor)variableDescriptor, (Object)a5, (Object)b1);
        undoMove.doMove((ScoreDirector)scoreDirector);
        SelectorTestUtils.assertChain(a0, a1, a2, a3, a4, a5);
        SelectorTestUtils.assertChain(b0, b1, b2, b3);
    }

    @Test
    public void sameChainInPlaceNoTrailing() {
        GenuineVariableDescriptor variableDescriptor = TestdataChainedEntity.buildVariableDescriptorForChainedObject();
        InnerScoreDirector scoreDirector = PlannerTestUtils.mockScoreDirector(variableDescriptor.getEntityDescriptor().getSolutionDescriptor());
        TestdataChainedAnchor a0 = new TestdataChainedAnchor("a0");
        TestdataChainedEntity a1 = new TestdataChainedEntity("a1", a0);
        TestdataChainedEntity a2 = new TestdataChainedEntity("a2", a1);
        TestdataChainedEntity a3 = new TestdataChainedEntity("a3", a2);
        TestdataChainedEntity a4 = new TestdataChainedEntity("a4", a3);
        TestdataChainedEntity a5 = new TestdataChainedEntity("a5", a4);
        TestdataChainedEntity a6 = new TestdataChainedEntity("a6", a5);
        TestdataChainedEntity a7 = new TestdataChainedEntity("a7", a6);
        SingletonInverseVariableSupply inverseVariableSupply = SelectorTestUtils.mockSingletonInverseVariableSupply(new TestdataChainedEntity[]{a1, a2, a3, a4, a5, a6, a7});
        SubChainReversingSwapMove move = new SubChainReversingSwapMove(variableDescriptor, inverseVariableSupply, new SubChain(Arrays.asList(a3, a4, a5)), new SubChain(Arrays.asList(a6, a7)));
        Move undoMove = move.createUndoMove((ScoreDirector)scoreDirector);
        move.doMove((ScoreDirector)scoreDirector);
        SelectorTestUtils.assertChain(a0, a1, a2, a7, a6, a5, a4, a3);
        ((InnerScoreDirector)Mockito.verify((Object)scoreDirector)).changeVariableFacade((VariableDescriptor)variableDescriptor, (Object)a7, (Object)a2);
        ((InnerScoreDirector)Mockito.verify((Object)scoreDirector)).changeVariableFacade((VariableDescriptor)variableDescriptor, (Object)a6, (Object)a7);
        ((InnerScoreDirector)Mockito.verify((Object)scoreDirector)).changeVariableFacade((VariableDescriptor)variableDescriptor, (Object)a5, (Object)a6);
        ((InnerScoreDirector)Mockito.verify((Object)scoreDirector)).changeVariableFacade((VariableDescriptor)variableDescriptor, (Object)a4, (Object)a5);
        ((InnerScoreDirector)Mockito.verify((Object)scoreDirector)).changeVariableFacade((VariableDescriptor)variableDescriptor, (Object)a3, (Object)a4);
        undoMove.doMove((ScoreDirector)scoreDirector);
        SelectorTestUtils.assertChain(a0, a1, a2, a3, a4, a5, a6, a7);
    }

    @Test
    public void sameChainInPlaceOldAndNewTrailing() {
        GenuineVariableDescriptor variableDescriptor = TestdataChainedEntity.buildVariableDescriptorForChainedObject();
        InnerScoreDirector scoreDirector = PlannerTestUtils.mockScoreDirector(variableDescriptor.getEntityDescriptor().getSolutionDescriptor());
        TestdataChainedAnchor a0 = new TestdataChainedAnchor("a0");
        TestdataChainedEntity a1 = new TestdataChainedEntity("a1", a0);
        TestdataChainedEntity a2 = new TestdataChainedEntity("a2", a1);
        TestdataChainedEntity a3 = new TestdataChainedEntity("a3", a2);
        TestdataChainedEntity a4 = new TestdataChainedEntity("a4", a3);
        TestdataChainedEntity a5 = new TestdataChainedEntity("a5", a4);
        TestdataChainedEntity a6 = new TestdataChainedEntity("a6", a5);
        TestdataChainedEntity a7 = new TestdataChainedEntity("a7", a6);
        SingletonInverseVariableSupply inverseVariableSupply = SelectorTestUtils.mockSingletonInverseVariableSupply(new TestdataChainedEntity[]{a1, a2, a3, a4, a5, a6, a7});
        SubChainReversingSwapMove move = new SubChainReversingSwapMove(variableDescriptor, inverseVariableSupply, new SubChain(Arrays.asList(a2, a3, a4)), new SubChain(Arrays.asList(a5, a6)));
        Move undoMove = move.createUndoMove((ScoreDirector)scoreDirector);
        move.doMove((ScoreDirector)scoreDirector);
        SelectorTestUtils.assertChain(a0, a1, a6, a5, a4, a3, a2, a7);
        ((InnerScoreDirector)Mockito.verify((Object)scoreDirector)).changeVariableFacade((VariableDescriptor)variableDescriptor, (Object)a6, (Object)a1);
        ((InnerScoreDirector)Mockito.verify((Object)scoreDirector)).changeVariableFacade((VariableDescriptor)variableDescriptor, (Object)a5, (Object)a6);
        ((InnerScoreDirector)Mockito.verify((Object)scoreDirector)).changeVariableFacade((VariableDescriptor)variableDescriptor, (Object)a4, (Object)a5);
        ((InnerScoreDirector)Mockito.verify((Object)scoreDirector)).changeVariableFacade((VariableDescriptor)variableDescriptor, (Object)a3, (Object)a4);
        ((InnerScoreDirector)Mockito.verify((Object)scoreDirector)).changeVariableFacade((VariableDescriptor)variableDescriptor, (Object)a2, (Object)a3);
        ((InnerScoreDirector)Mockito.verify((Object)scoreDirector)).changeVariableFacade((VariableDescriptor)variableDescriptor, (Object)a7, (Object)a2);
        undoMove.doMove((ScoreDirector)scoreDirector);
        SelectorTestUtils.assertChain(a0, a1, a2, a3, a4, a5, a6, a7);
    }

    @Test
    public void sameChainInPlaceOldAndNewTrailingOppositeParameterOrder() {
        GenuineVariableDescriptor variableDescriptor = TestdataChainedEntity.buildVariableDescriptorForChainedObject();
        InnerScoreDirector scoreDirector = PlannerTestUtils.mockScoreDirector(variableDescriptor.getEntityDescriptor().getSolutionDescriptor());
        TestdataChainedAnchor a0 = new TestdataChainedAnchor("a0");
        TestdataChainedEntity a1 = new TestdataChainedEntity("a1", a0);
        TestdataChainedEntity a2 = new TestdataChainedEntity("a2", a1);
        TestdataChainedEntity a3 = new TestdataChainedEntity("a3", a2);
        TestdataChainedEntity a4 = new TestdataChainedEntity("a4", a3);
        TestdataChainedEntity a5 = new TestdataChainedEntity("a5", a4);
        TestdataChainedEntity a6 = new TestdataChainedEntity("a6", a5);
        TestdataChainedEntity a7 = new TestdataChainedEntity("a7", a6);
        SingletonInverseVariableSupply inverseVariableSupply = SelectorTestUtils.mockSingletonInverseVariableSupply(new TestdataChainedEntity[]{a1, a2, a3, a4, a5, a6, a7});
        SubChainReversingSwapMove move = new SubChainReversingSwapMove(variableDescriptor, inverseVariableSupply, new SubChain(Arrays.asList(a5, a6)), new SubChain(Arrays.asList(a2, a3, a4)));
        Move undoMove = move.createUndoMove((ScoreDirector)scoreDirector);
        move.doMove((ScoreDirector)scoreDirector);
        SelectorTestUtils.assertChain(a0, a1, a6, a5, a4, a3, a2, a7);
        ((InnerScoreDirector)Mockito.verify((Object)scoreDirector)).changeVariableFacade((VariableDescriptor)variableDescriptor, (Object)a6, (Object)a1);
        ((InnerScoreDirector)Mockito.verify((Object)scoreDirector)).changeVariableFacade((VariableDescriptor)variableDescriptor, (Object)a5, (Object)a6);
        ((InnerScoreDirector)Mockito.verify((Object)scoreDirector)).changeVariableFacade((VariableDescriptor)variableDescriptor, (Object)a4, (Object)a5);
        ((InnerScoreDirector)Mockito.verify((Object)scoreDirector)).changeVariableFacade((VariableDescriptor)variableDescriptor, (Object)a3, (Object)a4);
        ((InnerScoreDirector)Mockito.verify((Object)scoreDirector)).changeVariableFacade((VariableDescriptor)variableDescriptor, (Object)a2, (Object)a3);
        ((InnerScoreDirector)Mockito.verify((Object)scoreDirector)).changeVariableFacade((VariableDescriptor)variableDescriptor, (Object)a7, (Object)a2);
        undoMove.doMove((ScoreDirector)scoreDirector);
        SelectorTestUtils.assertChain(a0, a1, a2, a3, a4, a5, a6, a7);
    }

    @Test
    public void toStringTest() {
        TestdataChainedAnchor a0 = new TestdataChainedAnchor("a0");
        TestdataChainedEntity a1 = new TestdataChainedEntity("a1", a0);
        TestdataChainedEntity a2 = new TestdataChainedEntity("a2", a1);
        TestdataChainedEntity a3 = new TestdataChainedEntity("a3", a2);
        TestdataChainedEntity a4 = new TestdataChainedEntity("a4", a3);
        TestdataChainedEntity a5 = new TestdataChainedEntity("a5", a4);
        TestdataChainedAnchor b0 = new TestdataChainedAnchor("b0");
        TestdataChainedEntity b1 = new TestdataChainedEntity("b1", b0);
        TestdataChainedEntity b2 = new TestdataChainedEntity("b2", b1);
        TestdataChainedEntity b3 = new TestdataChainedEntity("b3", b2);
        GenuineVariableDescriptor variableDescriptor = TestdataChainedEntity.buildVariableDescriptorForChainedObject();
        SingletonInverseVariableSupply inverseVariableSupply = SelectorTestUtils.mockSingletonInverseVariableSupply(new TestdataChainedEntity[]{a1, a2, a3, a4, a5, b1, b2, b3});
        Assert.assertEquals((Object)"[a2..a4] {a1} <-reversing-> [b1..b3] {b0}", (Object)new SubChainReversingSwapMove(variableDescriptor, inverseVariableSupply, new SubChain(Arrays.asList(a2, a3, a4)), new SubChain(Arrays.asList(b1, b2, b3))).toString());
        Assert.assertEquals((Object)"[a1..a2] {a0} <-reversing-> [a4..a5] {a3}", (Object)new SubChainReversingSwapMove(variableDescriptor, inverseVariableSupply, new SubChain(Arrays.asList(a1, a2)), new SubChain(Arrays.asList(a4, a5))).toString());
        Assert.assertEquals((Object)"[a3..a3] {a2} <-reversing-> [b2..b2] {b1}", (Object)new SubChainReversingSwapMove(variableDescriptor, inverseVariableSupply, new SubChain(Arrays.asList(a3)), new SubChain(Arrays.asList(b2))).toString());
    }
}

