/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.value.mimic;

import java.util.Iterator;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.optaplanner.core.impl.heuristic.selector.SelectorTestUtils;
import org.optaplanner.core.impl.heuristic.selector.value.EntityIndependentValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.mimic.MimicRecordingValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.mimic.MimicReplayingValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.mimic.ValueMimicRecorder;
import org.optaplanner.core.impl.phase.event.PhaseLifecycleListener;
import org.optaplanner.core.impl.phase.scope.AbstractPhaseScope;
import org.optaplanner.core.impl.phase.scope.AbstractStepScope;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;
import org.optaplanner.core.impl.testdata.domain.TestdataEntity;
import org.optaplanner.core.impl.testdata.domain.TestdataValue;
import org.optaplanner.core.impl.testdata.util.PlannerAssert;

public class MimicReplayingValueSelectorTest {
    @Test
    public void originalSelection() {
        EntityIndependentValueSelector childValueSelector = SelectorTestUtils.mockEntityIndependentValueSelector(TestdataEntity.class, "value", new TestdataValue("v1"), new TestdataValue("v2"), new TestdataValue("v3"));
        MimicRecordingValueSelector recordingValueSelector = new MimicRecordingValueSelector(childValueSelector);
        MimicReplayingValueSelector replayingValueSelector = new MimicReplayingValueSelector((ValueMimicRecorder)recordingValueSelector);
        DefaultSolverScope solverScope = (DefaultSolverScope)Mockito.mock(DefaultSolverScope.class);
        recordingValueSelector.solvingStarted(solverScope);
        replayingValueSelector.solvingStarted(solverScope);
        AbstractPhaseScope phaseScopeA = (AbstractPhaseScope)Mockito.mock(AbstractPhaseScope.class);
        Mockito.when((Object)phaseScopeA.getSolverScope()).thenReturn((Object)solverScope);
        recordingValueSelector.phaseStarted(phaseScopeA);
        replayingValueSelector.phaseStarted(phaseScopeA);
        AbstractStepScope stepScopeA1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA1.getPhaseScope()).thenReturn((Object)phaseScopeA);
        recordingValueSelector.stepStarted(stepScopeA1);
        replayingValueSelector.stepStarted(stepScopeA1);
        this.runOriginalAsserts(recordingValueSelector, replayingValueSelector);
        recordingValueSelector.stepEnded(stepScopeA1);
        replayingValueSelector.stepEnded(stepScopeA1);
        AbstractStepScope stepScopeA2 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA2.getPhaseScope()).thenReturn((Object)phaseScopeA);
        recordingValueSelector.stepStarted(stepScopeA2);
        replayingValueSelector.stepStarted(stepScopeA2);
        this.runOriginalAsserts(recordingValueSelector, replayingValueSelector);
        recordingValueSelector.stepEnded(stepScopeA2);
        replayingValueSelector.stepEnded(stepScopeA2);
        recordingValueSelector.phaseEnded(phaseScopeA);
        replayingValueSelector.phaseEnded(phaseScopeA);
        AbstractPhaseScope phaseScopeB = (AbstractPhaseScope)Mockito.mock(AbstractPhaseScope.class);
        Mockito.when((Object)phaseScopeB.getSolverScope()).thenReturn((Object)solverScope);
        recordingValueSelector.phaseStarted(phaseScopeB);
        replayingValueSelector.phaseStarted(phaseScopeB);
        AbstractStepScope stepScopeB1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB1.getPhaseScope()).thenReturn((Object)phaseScopeB);
        recordingValueSelector.stepStarted(stepScopeB1);
        replayingValueSelector.stepStarted(stepScopeB1);
        this.runOriginalAsserts(recordingValueSelector, replayingValueSelector);
        recordingValueSelector.stepEnded(stepScopeB1);
        replayingValueSelector.stepEnded(stepScopeB1);
        recordingValueSelector.phaseEnded(phaseScopeB);
        replayingValueSelector.phaseEnded(phaseScopeB);
        recordingValueSelector.solvingEnded(solverScope);
        replayingValueSelector.solvingEnded(solverScope);
        PlannerAssert.verifyPhaseLifecycle((PhaseLifecycleListener)childValueSelector, 1, 2, 3);
        ((EntityIndependentValueSelector)Mockito.verify((Object)childValueSelector, (VerificationMode)Mockito.times((int)3))).iterator();
    }

    private void runOriginalAsserts(MimicRecordingValueSelector recordingValueSelector, MimicReplayingValueSelector replayingValueSelector) {
        Iterator recordingIterator = recordingValueSelector.iterator();
        Assert.assertNotNull((Object)recordingIterator);
        Iterator replayingIterator = replayingValueSelector.iterator();
        Assert.assertNotNull((Object)replayingIterator);
        Assert.assertEquals((Object)true, (Object)recordingIterator.hasNext());
        Assert.assertEquals((Object)true, (Object)replayingIterator.hasNext());
        PlannerAssert.assertCode("v1", recordingIterator.next());
        PlannerAssert.assertCode("v1", replayingIterator.next());
        Assert.assertEquals((Object)true, (Object)recordingIterator.hasNext());
        Assert.assertEquals((Object)true, (Object)replayingIterator.hasNext());
        PlannerAssert.assertCode("v2", recordingIterator.next());
        PlannerAssert.assertCode("v2", replayingIterator.next());
        Assert.assertEquals((Object)false, (Object)replayingIterator.hasNext());
        Assert.assertEquals((Object)true, (Object)recordingIterator.hasNext());
        Assert.assertEquals((Object)true, (Object)replayingIterator.hasNext());
        Assert.assertEquals((Object)true, (Object)replayingIterator.hasNext());
        PlannerAssert.assertCode("v3", recordingIterator.next());
        PlannerAssert.assertCode("v3", replayingIterator.next());
        Assert.assertEquals((Object)false, (Object)recordingIterator.hasNext());
        Assert.assertEquals((Object)false, (Object)replayingIterator.hasNext());
        Assert.assertEquals((Object)false, (Object)replayingIterator.hasNext());
        Assert.assertEquals((Object)true, (Object)recordingValueSelector.isCountable());
        Assert.assertEquals((Object)true, (Object)replayingValueSelector.isCountable());
        Assert.assertEquals((Object)false, (Object)recordingValueSelector.isNeverEnding());
        Assert.assertEquals((Object)false, (Object)replayingValueSelector.isNeverEnding());
        Assert.assertEquals((long)3L, (long)recordingValueSelector.getSize());
        Assert.assertEquals((long)3L, (long)replayingValueSelector.getSize());
    }
}

