/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.localsearch.decider.acceptor.simulatedannealing;

import java.util.Random;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.hardmediumsoft.HardMediumSoftScore;
import org.optaplanner.core.api.score.buildin.simple.SimpleScore;
import org.optaplanner.core.impl.localsearch.decider.acceptor.AbstractAcceptorTest;
import org.optaplanner.core.impl.localsearch.decider.acceptor.simulatedannealing.SimulatedAnnealingAcceptor;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchMoveScope;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchPhaseScope;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchStepScope;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;

public class SimulatedAnnealingAcceptorTest
extends AbstractAcceptorTest {
    @Test
    public void lateAcceptanceSize() {
        SimulatedAnnealingAcceptor acceptor = new SimulatedAnnealingAcceptor();
        acceptor.setStartingTemperature((Score)SimpleScore.valueOf((int)200));
        DefaultSolverScope solverScope = new DefaultSolverScope();
        solverScope.setBestScore((Score)SimpleScore.valueOf((int)-1000));
        Random workingRandom = (Random)Mockito.mock(Random.class);
        solverScope.setWorkingRandom(workingRandom);
        LocalSearchPhaseScope phaseScope = new LocalSearchPhaseScope(solverScope);
        LocalSearchStepScope lastCompletedStepScope = new LocalSearchStepScope(phaseScope, -1);
        lastCompletedStepScope.setScore((Score)SimpleScore.valueOf((int)-1000));
        phaseScope.setLastCompletedStepScope(lastCompletedStepScope);
        acceptor.phaseStarted(phaseScope);
        LocalSearchStepScope stepScope0 = new LocalSearchStepScope(phaseScope);
        stepScope0.setTimeGradient(0.0);
        acceptor.stepStarted(stepScope0);
        LocalSearchMoveScope moveScope0 = this.buildMoveScope(stepScope0, -500);
        Mockito.when((Object)workingRandom.nextDouble()).thenReturn((Object)0.3);
        Assert.assertEquals((Object)false, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope0, -1300)));
        Mockito.when((Object)workingRandom.nextDouble()).thenReturn((Object)0.3);
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope0, -1200)));
        Mockito.when((Object)workingRandom.nextDouble()).thenReturn((Object)0.4);
        Assert.assertEquals((Object)false, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope0, -1200)));
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(moveScope0));
        stepScope0.setStep(moveScope0.getMove());
        stepScope0.setScore(moveScope0.getScore());
        solverScope.setBestScore(moveScope0.getScore());
        acceptor.stepEnded(stepScope0);
        phaseScope.setLastCompletedStepScope(stepScope0);
        LocalSearchStepScope stepScope1 = new LocalSearchStepScope(phaseScope);
        stepScope1.setTimeGradient(0.5);
        acceptor.stepStarted(stepScope1);
        LocalSearchMoveScope moveScope1 = this.buildMoveScope(stepScope1, -800);
        Mockito.when((Object)workingRandom.nextDouble()).thenReturn((Object)0.13);
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope1, -700)));
        Mockito.when((Object)workingRandom.nextDouble()).thenReturn((Object)0.14);
        Assert.assertEquals((Object)false, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope1, -700)));
        Mockito.when((Object)workingRandom.nextDouble()).thenReturn((Object)0.04);
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(moveScope1));
        stepScope1.setStep(moveScope1.getMove());
        stepScope1.setScore(moveScope1.getScore());
        acceptor.stepEnded(stepScope1);
        phaseScope.setLastCompletedStepScope(stepScope1);
        LocalSearchStepScope stepScope2 = new LocalSearchStepScope(phaseScope);
        stepScope2.setTimeGradient(1.0);
        acceptor.stepStarted(stepScope2);
        LocalSearchMoveScope moveScope2 = this.buildMoveScope(stepScope1, -400);
        Mockito.when((Object)workingRandom.nextDouble()).thenReturn((Object)0.01);
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope2, -800)));
        Mockito.when((Object)workingRandom.nextDouble()).thenReturn((Object)0.01);
        Assert.assertEquals((Object)false, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope2, -801)));
        Mockito.when((Object)workingRandom.nextDouble()).thenReturn((Object)0.01);
        Assert.assertEquals((Object)false, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope2, -1200)));
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope2, -700)));
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(moveScope2));
        stepScope2.setStep(moveScope2.getMove());
        stepScope2.setScore(moveScope2.getScore());
        solverScope.setBestScore(moveScope2.getScore());
        acceptor.stepEnded(stepScope2);
        phaseScope.setLastCompletedStepScope(stepScope2);
        acceptor.phaseEnded(phaseScope);
    }

    @Test(expected=IllegalArgumentException.class)
    public void negativeLateSimulatedAnnealingSize() {
        SimulatedAnnealingAcceptor acceptor = new SimulatedAnnealingAcceptor();
        acceptor.setStartingTemperature((Score)HardMediumSoftScore.parseScore((String)"1, -1, 2"));
        acceptor.phaseStarted(null);
    }
}

