/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.buildin.bendablebigdecimal;

import java.math.BigDecimal;
import org.junit.Assert;
import org.junit.Test;
import org.optaplanner.core.api.score.buildin.bendablebigdecimal.BendableBigDecimalScore;
import org.optaplanner.core.impl.score.buildin.bendablebigdecimal.BendableBigDecimalScoreDefinition;

public class BendableBigDecimalScoreDefinitionTest {
    @Test
    public void getLevelsSize() {
        Assert.assertEquals((long)2L, (long)new BendableBigDecimalScoreDefinition(1, 1).getLevelsSize());
        Assert.assertEquals((long)7L, (long)new BendableBigDecimalScoreDefinition(3, 4).getLevelsSize());
        Assert.assertEquals((long)7L, (long)new BendableBigDecimalScoreDefinition(4, 3).getLevelsSize());
        Assert.assertEquals((long)5L, (long)new BendableBigDecimalScoreDefinition(0, 5).getLevelsSize());
        Assert.assertEquals((long)5L, (long)new BendableBigDecimalScoreDefinition(5, 0).getLevelsSize());
    }

    @Test
    public void getLevelLabels() {
        Assert.assertArrayEquals((Object[])new String[]{"hard 0 score", "soft 0 score"}, (Object[])new BendableBigDecimalScoreDefinition(1, 1).getLevelLabels());
        Assert.assertArrayEquals((Object[])new String[]{"hard 0 score", "hard 1 score", "hard 2 score", "soft 0 score", "soft 1 score", "soft 2 score", "soft 3 score"}, (Object[])new BendableBigDecimalScoreDefinition(3, 4).getLevelLabels());
        Assert.assertArrayEquals((Object[])new String[]{"hard 0 score", "hard 1 score", "hard 2 score", "hard 3 score", "soft 0 score", "soft 1 score", "soft 2 score"}, (Object[])new BendableBigDecimalScoreDefinition(4, 3).getLevelLabels());
        Assert.assertArrayEquals((Object[])new String[]{"soft 0 score", "soft 1 score", "soft 2 score", "soft 3 score", "soft 4 score"}, (Object[])new BendableBigDecimalScoreDefinition(0, 5).getLevelLabels());
        Assert.assertArrayEquals((Object[])new String[]{"hard 0 score", "hard 1 score", "hard 2 score", "hard 3 score", "hard 4 score"}, (Object[])new BendableBigDecimalScoreDefinition(5, 0).getLevelLabels());
    }

    @Test
    public void getFeasibleLevelsSize() {
        Assert.assertEquals((long)1L, (long)new BendableBigDecimalScoreDefinition(1, 1).getFeasibleLevelsSize());
        Assert.assertEquals((long)3L, (long)new BendableBigDecimalScoreDefinition(3, 4).getFeasibleLevelsSize());
        Assert.assertEquals((long)4L, (long)new BendableBigDecimalScoreDefinition(4, 3).getFeasibleLevelsSize());
        Assert.assertEquals((long)0L, (long)new BendableBigDecimalScoreDefinition(0, 5).getFeasibleLevelsSize());
        Assert.assertEquals((long)5L, (long)new BendableBigDecimalScoreDefinition(5, 0).getFeasibleLevelsSize());
    }

    @Test(expected=IllegalArgumentException.class)
    public void createScoreWithIllegalArgument() {
        BendableBigDecimalScoreDefinition bendableScoreDefinition = new BendableBigDecimalScoreDefinition(2, 3);
        bendableScoreDefinition.createScore(new BigDecimal[]{new BigDecimal(1), new BigDecimal(2), new BigDecimal(3)});
    }

    @Test
    public void createScore() {
        for (int hardLevelSize = 1; hardLevelSize < 5; ++hardLevelSize) {
            for (int softLevelSize = 1; softLevelSize < 5; ++softLevelSize) {
                int levelSize = hardLevelSize + softLevelSize;
                BigDecimal[] scores = new BigDecimal[levelSize];
                for (int i = 0; i < levelSize; ++i) {
                    scores[i] = new BigDecimal(i);
                }
                BendableBigDecimalScoreDefinition bendableScoreDefinition = new BendableBigDecimalScoreDefinition(hardLevelSize, softLevelSize);
                BendableBigDecimalScore bendableScore = bendableScoreDefinition.createScore(scores);
                Assert.assertEquals((long)hardLevelSize, (long)bendableScore.getHardLevelsSize());
                Assert.assertEquals((long)softLevelSize, (long)bendableScore.getSoftLevelsSize());
                for (int i = 0; i < levelSize; ++i) {
                    if (i < hardLevelSize) {
                        Assert.assertEquals((Object)scores[i], (Object)bendableScore.getHardScore(i));
                        continue;
                    }
                    Assert.assertEquals((Object)scores[i], (Object)bendableScore.getSoftScore(i - hardLevelSize));
                }
            }
        }
    }
}

