/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.buildin.hardsoft;

import org.junit.Assert;
import org.junit.Test;
import org.optaplanner.core.api.score.buildin.hardsoft.HardSoftScore;
import org.optaplanner.core.config.score.trend.InitializingScoreTrendLevel;
import org.optaplanner.core.impl.score.buildin.AbstractScoreDefinitionTest;
import org.optaplanner.core.impl.score.buildin.hardsoft.HardSoftScoreDefinition;
import org.optaplanner.core.impl.score.trend.InitializingScoreTrend;

public class HardSoftScoreDefinitionTest
extends AbstractScoreDefinitionTest {
    @Test
    public void getLevelsSize() {
        Assert.assertEquals((long)2L, (long)new HardSoftScoreDefinition().getLevelsSize());
    }

    @Test
    public void getLevelLabels() {
        Assert.assertArrayEquals((Object[])new String[]{"hard score", "soft score"}, (Object[])new HardSoftScoreDefinition().getLevelLabels());
    }

    @Test
    public void getFeasibleLevelsSize() {
        Assert.assertEquals((long)1L, (long)new HardSoftScoreDefinition().getFeasibleLevelsSize());
    }

    @Test
    public void buildOptimisticBoundOnlyUp() {
        HardSoftScoreDefinition scoreDefinition = new HardSoftScoreDefinition();
        HardSoftScore optimisticBound = scoreDefinition.buildOptimisticBound(InitializingScoreTrend.buildUniformTrend((InitializingScoreTrendLevel)InitializingScoreTrendLevel.ONLY_UP, (int)2), HardSoftScore.valueOf((int)-1, (int)-2));
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)optimisticBound.getHardScore());
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)optimisticBound.getSoftScore());
    }

    @Test
    public void buildOptimisticBoundOnlyDown() {
        HardSoftScoreDefinition scoreDefinition = new HardSoftScoreDefinition();
        HardSoftScore optimisticBound = scoreDefinition.buildOptimisticBound(InitializingScoreTrend.buildUniformTrend((InitializingScoreTrendLevel)InitializingScoreTrendLevel.ONLY_DOWN, (int)2), HardSoftScore.valueOf((int)-1, (int)-2));
        Assert.assertEquals((long)-1L, (long)optimisticBound.getHardScore());
        Assert.assertEquals((long)-2L, (long)optimisticBound.getSoftScore());
    }

    @Test
    public void buildPessimisticBoundOnlyUp() {
        HardSoftScoreDefinition scoreDefinition = new HardSoftScoreDefinition();
        HardSoftScore pessimisticBound = scoreDefinition.buildPessimisticBound(InitializingScoreTrend.buildUniformTrend((InitializingScoreTrendLevel)InitializingScoreTrendLevel.ONLY_UP, (int)2), HardSoftScore.valueOf((int)-1, (int)-2));
        Assert.assertEquals((long)-1L, (long)pessimisticBound.getHardScore());
        Assert.assertEquals((long)-2L, (long)pessimisticBound.getSoftScore());
    }

    @Test
    public void buildPessimisticBoundOnlyDown() {
        HardSoftScoreDefinition scoreDefinition = new HardSoftScoreDefinition();
        HardSoftScore pessimisticBound = scoreDefinition.buildPessimisticBound(InitializingScoreTrend.buildUniformTrend((InitializingScoreTrendLevel)InitializingScoreTrendLevel.ONLY_DOWN, (int)2), HardSoftScore.valueOf((int)-1, (int)-2));
        Assert.assertEquals((long)Integer.MIN_VALUE, (long)pessimisticBound.getHardScore());
        Assert.assertEquals((long)Integer.MIN_VALUE, (long)pessimisticBound.getSoftScore());
    }
}

