/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.buildin.hardsoftdouble;

import org.junit.Assert;
import org.junit.Test;
import org.optaplanner.core.api.score.buildin.hardsoftdouble.HardSoftDoubleScore;
import org.optaplanner.core.config.score.trend.InitializingScoreTrendLevel;
import org.optaplanner.core.impl.score.buildin.hardsoftdouble.HardSoftDoubleScoreDefinition;
import org.optaplanner.core.impl.score.trend.InitializingScoreTrend;

public class HardSoftDoubleScoreDefinitionTest {
    @Test
    public void getLevelSize() {
        Assert.assertEquals((long)2L, (long)new HardSoftDoubleScoreDefinition().getLevelsSize());
    }

    @Test
    public void getLevelLabels() {
        Assert.assertArrayEquals((Object[])new String[]{"hard score", "soft score"}, (Object[])new HardSoftDoubleScoreDefinition().getLevelLabels());
    }

    @Test
    public void getFeasibleLevelsSize() {
        Assert.assertEquals((long)1L, (long)new HardSoftDoubleScoreDefinition().getFeasibleLevelsSize());
    }

    @Test
    public void buildOptimisticBoundOnlyUp() {
        HardSoftDoubleScoreDefinition scoreDefinition = new HardSoftDoubleScoreDefinition();
        HardSoftDoubleScore optimisticBound = scoreDefinition.buildOptimisticBound(InitializingScoreTrend.buildUniformTrend((InitializingScoreTrendLevel)InitializingScoreTrendLevel.ONLY_UP, (int)2), HardSoftDoubleScore.valueOf((double)-1.7, (double)-2.2));
        Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)optimisticBound.getHardScore(), (double)0.0);
        Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)optimisticBound.getSoftScore(), (double)0.0);
    }

    @Test
    public void buildOptimisticBoundOnlyDown() {
        HardSoftDoubleScoreDefinition scoreDefinition = new HardSoftDoubleScoreDefinition();
        HardSoftDoubleScore optimisticBound = scoreDefinition.buildOptimisticBound(InitializingScoreTrend.buildUniformTrend((InitializingScoreTrendLevel)InitializingScoreTrendLevel.ONLY_DOWN, (int)2), HardSoftDoubleScore.valueOf((double)-1.7, (double)-2.2));
        Assert.assertEquals((double)-1.7, (double)optimisticBound.getHardScore(), (double)0.0);
        Assert.assertEquals((double)-2.2, (double)optimisticBound.getSoftScore(), (double)0.0);
    }

    @Test
    public void buildPessimisticBoundOnlyUp() {
        HardSoftDoubleScoreDefinition scoreDefinition = new HardSoftDoubleScoreDefinition();
        HardSoftDoubleScore pessimisticBound = scoreDefinition.buildPessimisticBound(InitializingScoreTrend.buildUniformTrend((InitializingScoreTrendLevel)InitializingScoreTrendLevel.ONLY_UP, (int)2), HardSoftDoubleScore.valueOf((double)-1.7, (double)-2.2));
        Assert.assertEquals((double)-1.7, (double)pessimisticBound.getHardScore(), (double)0.0);
        Assert.assertEquals((double)-2.2, (double)pessimisticBound.getSoftScore(), (double)0.0);
    }

    @Test
    public void buildPessimisticBoundOnlyDown() {
        HardSoftDoubleScoreDefinition scoreDefinition = new HardSoftDoubleScoreDefinition();
        HardSoftDoubleScore pessimisticBound = scoreDefinition.buildPessimisticBound(InitializingScoreTrend.buildUniformTrend((InitializingScoreTrendLevel)InitializingScoreTrendLevel.ONLY_DOWN, (int)2), HardSoftDoubleScore.valueOf((double)-1.0, (double)-2.0));
        Assert.assertEquals((double)Double.NEGATIVE_INFINITY, (double)pessimisticBound.getHardScore(), (double)0.0);
        Assert.assertEquals((double)Double.NEGATIVE_INFINITY, (double)pessimisticBound.getSoftScore(), (double)0.0);
    }
}

