/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.director.incremental;

import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.optaplanner.core.api.domain.solution.Solution;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.simple.SimpleScore;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.score.director.incremental.IncrementalScoreCalculator;
import org.optaplanner.core.impl.score.director.incremental.IncrementalScoreDirector;
import org.optaplanner.core.impl.score.director.incremental.IncrementalScoreDirectorFactory;
import org.optaplanner.core.impl.testdata.domain.chained.rich.TestdataRichChainedAnchor;
import org.optaplanner.core.impl.testdata.domain.chained.rich.TestdataRichChainedEntity;
import org.optaplanner.core.impl.testdata.domain.chained.rich.TestdataRichChainedSolution;

public class IncrementalScoreDirectorTest {
    @Test
    public void variableListener() {
        TestdataRichChainedAnchor a0 = new TestdataRichChainedAnchor("a0");
        TestdataRichChainedEntity a1 = new TestdataRichChainedEntity("a1", a0);
        a0.setNextEntity(a1);
        TestdataRichChainedEntity a2 = new TestdataRichChainedEntity("a2", a1);
        a1.setNextEntity(a2);
        TestdataRichChainedEntity a3 = new TestdataRichChainedEntity("a3", a2);
        a2.setNextEntity(a3);
        TestdataRichChainedAnchor b0 = new TestdataRichChainedAnchor("b0");
        TestdataRichChainedEntity b1 = new TestdataRichChainedEntity("b1", b0);
        b0.setNextEntity(b1);
        TestdataRichChainedSolution solution = new TestdataRichChainedSolution("solution");
        List<TestdataRichChainedAnchor> anchorList = Arrays.asList(a0, b0);
        solution.setChainedAnchorList(anchorList);
        List<TestdataRichChainedEntity> originalEntityList = Arrays.asList(a1, a2, a3, b1);
        solution.setChainedEntityList(originalEntityList);
        SolutionDescriptor solutionDescriptor = TestdataRichChainedSolution.buildSolutionDescriptor();
        IncrementalScoreDirectorFactory scoreDirectorFactory = (IncrementalScoreDirectorFactory)Mockito.mock(IncrementalScoreDirectorFactory.class);
        Mockito.when((Object)scoreDirectorFactory.getSolutionDescriptor()).thenReturn((Object)solutionDescriptor);
        IncrementalScoreCalculator incrementalScoreCalculator = (IncrementalScoreCalculator)Mockito.mock(IncrementalScoreCalculator.class);
        IncrementalScoreDirector scoreDirector = new IncrementalScoreDirector(scoreDirectorFactory, false, incrementalScoreCalculator){

            public Score calculateScore() {
                return SimpleScore.valueOf((int)-100);
            }
        };
        scoreDirector.setWorkingSolution((Solution)solution);
        Mockito.reset((Object[])new IncrementalScoreCalculator[]{incrementalScoreCalculator});
        Assert.assertEquals(null, (Object)b1.getNextEntity());
        scoreDirector.beforeVariableChanged((Object)a3, "chainedObject");
        a3.setChainedObject(b1);
        scoreDirector.afterVariableChanged((Object)a3, "chainedObject");
        scoreDirector.triggerVariableListeners();
        Assert.assertEquals((Object)a3, (Object)b1.getNextEntity());
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{incrementalScoreCalculator});
        ((IncrementalScoreCalculator)inOrder.verify((Object)incrementalScoreCalculator, Mockito.times((int)1))).beforeVariableChanged((Object)a3, "chainedObject");
        ((IncrementalScoreCalculator)inOrder.verify((Object)incrementalScoreCalculator, Mockito.times((int)1))).afterVariableChanged((Object)a3, "chainedObject");
        ((IncrementalScoreCalculator)inOrder.verify((Object)incrementalScoreCalculator, Mockito.times((int)1))).beforeVariableChanged((Object)b1, "nextEntity");
        ((IncrementalScoreCalculator)inOrder.verify((Object)incrementalScoreCalculator, Mockito.times((int)1))).afterVariableChanged((Object)b1, "nextEntity");
        inOrder.verifyNoMoreInteractions();
    }
}

