/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.solver;

import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Test;
import org.optaplanner.core.config.SolverConfigContext;
import org.optaplanner.core.config.solver.SolverConfig;
import org.optaplanner.core.impl.solver.XStreamXmlSolverFactory;

public class XStreamXmlSolverFactoryTest {
    @Test
    public void configFileRemainsSameAfterReadWrite() throws Exception {
        String solverConfigResource = "testdataSolverConfigXStream.xml";
        String originalXml = IOUtils.toString((InputStream)this.getClass().getResourceAsStream(solverConfigResource), (String)"UTF-8");
        InputStream originalConfigInputStream = this.getClass().getResourceAsStream(solverConfigResource);
        XStreamXmlSolverFactory solverFactory = new XStreamXmlSolverFactory().configure(originalConfigInputStream);
        SolverConfig solverConfig = solverFactory.getSolverConfig();
        SolverConfigContext configContext = new SolverConfigContext();
        configContext.setClassLoader(this.getClass().getClassLoader());
        solverConfig.buildSolver(configContext);
        String savedXml = solverFactory.getXStream().toXML((Object)solverConfig);
        Assert.assertEquals((Object)originalXml, (Object)savedXml);
        originalConfigInputStream.close();
    }
}

