/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.solver.termination;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.optaplanner.core.impl.phase.scope.AbstractPhaseScope;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;
import org.optaplanner.core.impl.solver.termination.CalculateCountTermination;

public class CalculateCountTerminationTest {
    @Test
    public void solveTermination() {
        CalculateCountTermination termination = new CalculateCountTermination(1000L);
        DefaultSolverScope solverScope = (DefaultSolverScope)Mockito.mock(DefaultSolverScope.class);
        InnerScoreDirector scoreDirector = (InnerScoreDirector)Mockito.mock(InnerScoreDirector.class);
        Mockito.when((Object)solverScope.getScoreDirector()).thenReturn((Object)scoreDirector);
        Mockito.when((Object)scoreDirector.getCalculateCount()).thenReturn((Object)0L);
        Assert.assertEquals((Object)false, (Object)termination.isSolverTerminated(solverScope));
        Assert.assertEquals((double)0.0, (double)termination.calculateSolverTimeGradient(solverScope), (double)0.0);
        Mockito.when((Object)scoreDirector.getCalculateCount()).thenReturn((Object)100L);
        Assert.assertEquals((Object)false, (Object)termination.isSolverTerminated(solverScope));
        Assert.assertEquals((double)0.1, (double)termination.calculateSolverTimeGradient(solverScope), (double)0.0);
        Mockito.when((Object)scoreDirector.getCalculateCount()).thenReturn((Object)500L);
        Assert.assertEquals((Object)false, (Object)termination.isSolverTerminated(solverScope));
        Assert.assertEquals((double)0.5, (double)termination.calculateSolverTimeGradient(solverScope), (double)0.0);
        Mockito.when((Object)scoreDirector.getCalculateCount()).thenReturn((Object)700L);
        Assert.assertEquals((Object)false, (Object)termination.isSolverTerminated(solverScope));
        Assert.assertEquals((double)0.7, (double)termination.calculateSolverTimeGradient(solverScope), (double)0.0);
        Mockito.when((Object)scoreDirector.getCalculateCount()).thenReturn((Object)1000L);
        Assert.assertEquals((Object)true, (Object)termination.isSolverTerminated(solverScope));
        Assert.assertEquals((double)1.0, (double)termination.calculateSolverTimeGradient(solverScope), (double)0.0);
        Mockito.when((Object)scoreDirector.getCalculateCount()).thenReturn((Object)1200L);
        Assert.assertEquals((Object)true, (Object)termination.isSolverTerminated(solverScope));
        Assert.assertEquals((double)1.0, (double)termination.calculateSolverTimeGradient(solverScope), (double)0.0);
    }

    @Test
    public void phaseTermination() {
        CalculateCountTermination termination = new CalculateCountTermination(1000L);
        AbstractPhaseScope phaseScope = (AbstractPhaseScope)Mockito.mock(AbstractPhaseScope.class);
        InnerScoreDirector scoreDirector = (InnerScoreDirector)Mockito.mock(InnerScoreDirector.class);
        Mockito.when((Object)phaseScope.getScoreDirector()).thenReturn((Object)scoreDirector);
        Mockito.when((Object)scoreDirector.getCalculateCount()).thenReturn((Object)0L);
        Assert.assertEquals((Object)false, (Object)termination.isPhaseTerminated(phaseScope));
        Assert.assertEquals((double)0.0, (double)termination.calculatePhaseTimeGradient(phaseScope), (double)0.0);
        Mockito.when((Object)scoreDirector.getCalculateCount()).thenReturn((Object)100L);
        Assert.assertEquals((Object)false, (Object)termination.isPhaseTerminated(phaseScope));
        Assert.assertEquals((double)0.1, (double)termination.calculatePhaseTimeGradient(phaseScope), (double)0.0);
        Mockito.when((Object)scoreDirector.getCalculateCount()).thenReturn((Object)500L);
        Assert.assertEquals((Object)false, (Object)termination.isPhaseTerminated(phaseScope));
        Assert.assertEquals((double)0.5, (double)termination.calculatePhaseTimeGradient(phaseScope), (double)0.0);
        Mockito.when((Object)scoreDirector.getCalculateCount()).thenReturn((Object)700L);
        Assert.assertEquals((Object)false, (Object)termination.isPhaseTerminated(phaseScope));
        Assert.assertEquals((double)0.7, (double)termination.calculatePhaseTimeGradient(phaseScope), (double)0.0);
        Mockito.when((Object)scoreDirector.getCalculateCount()).thenReturn((Object)1000L);
        Assert.assertEquals((Object)true, (Object)termination.isPhaseTerminated(phaseScope));
        Assert.assertEquals((double)1.0, (double)termination.calculatePhaseTimeGradient(phaseScope), (double)0.0);
        Mockito.when((Object)scoreDirector.getCalculateCount()).thenReturn((Object)1200L);
        Assert.assertEquals((Object)true, (Object)termination.isPhaseTerminated(phaseScope));
        Assert.assertEquals((double)1.0, (double)termination.calculatePhaseTimeGradient(phaseScope), (double)0.0);
    }
}

