/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.testdata.domain.shadow.cyclic.reference;

import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.variable.CustomShadowVariable;
import org.optaplanner.core.api.domain.variable.PlanningVariable;
import org.optaplanner.core.api.domain.variable.PlanningVariableReference;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.listener.VariableListenerAdapter;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.core.impl.testdata.domain.TestdataObject;
import org.optaplanner.core.impl.testdata.domain.TestdataValue;
import org.optaplanner.core.impl.testdata.domain.shadow.cyclic.reference.TestdataCyclicReferencedShadowedSolution;

@PlanningEntity
public class TestdataCyclicReferencedShadowedEntity
extends TestdataObject {
    private TestdataValue value;
    private boolean barber;
    private boolean cutsOwnHair;

    public static EntityDescriptor buildEntityDescriptor() {
        SolutionDescriptor solutionDescriptor = TestdataCyclicReferencedShadowedSolution.buildSolutionDescriptor();
        return solutionDescriptor.findEntityDescriptorOrFail(TestdataCyclicReferencedShadowedEntity.class);
    }

    public static GenuineVariableDescriptor buildVariableDescriptorForValue() {
        SolutionDescriptor solutionDescriptor = TestdataCyclicReferencedShadowedSolution.buildSolutionDescriptor();
        EntityDescriptor entityDescriptor = solutionDescriptor.findEntityDescriptorOrFail(TestdataCyclicReferencedShadowedEntity.class);
        return entityDescriptor.getGenuineVariableDescriptor("value");
    }

    public TestdataCyclicReferencedShadowedEntity() {
    }

    public TestdataCyclicReferencedShadowedEntity(String code) {
        super(code);
    }

    public TestdataCyclicReferencedShadowedEntity(String code, TestdataValue value) {
        this(code);
        this.value = value;
    }

    @PlanningVariable(valueRangeProviderRefs={"valueRange"})
    public TestdataValue getValue() {
        return this.value;
    }

    public void setValue(TestdataValue value) {
        this.value = value;
    }

    @CustomShadowVariable(variableListenerClass=BarberAndCutsOwnHairUpdatingVariableListener.class, sources={@CustomShadowVariable.Source(variableName="value"), @CustomShadowVariable.Source(variableName="cutsOwnHair")})
    public boolean isBarber() {
        return this.barber;
    }

    public void setBarber(boolean barber) {
        this.barber = barber;
    }

    @CustomShadowVariable(variableListenerRef=@PlanningVariableReference(variableName="barber"))
    public boolean isCutsOwnHair() {
        return this.cutsOwnHair;
    }

    public void setCutsOwnHair(boolean cutsOwnHair) {
        this.cutsOwnHair = cutsOwnHair;
    }

    public static class BarberAndCutsOwnHairUpdatingVariableListener
    extends VariableListenerAdapter<TestdataCyclicReferencedShadowedEntity> {
        public void afterEntityAdded(ScoreDirector scoreDirector, TestdataCyclicReferencedShadowedEntity entity) {
            this.updateShadow(entity, scoreDirector);
        }

        public void afterVariableChanged(ScoreDirector scoreDirector, TestdataCyclicReferencedShadowedEntity entity) {
            this.updateShadow(entity, scoreDirector);
        }

        private void updateShadow(TestdataCyclicReferencedShadowedEntity entity, ScoreDirector scoreDirector) {
            TestdataValue value = entity.getValue();
            boolean barber = !entity.isCutsOwnHair();
            scoreDirector.beforeVariableChanged((Object)entity, "barber");
            entity.setBarber(value != null && barber);
            scoreDirector.afterVariableChanged((Object)entity, "barber");
            scoreDirector.beforeVariableChanged((Object)entity, "cutsOwnHair");
            entity.setCutsOwnHair(value != null && !barber);
            scoreDirector.afterVariableChanged((Object)entity, "cutsOwnHair");
        }
    }
}

